<?php
function monsterinsights_fbia_params( $options ) {
	if ( function_exists( 'is_transforming_instant_article' ) && is_transforming_instant_article() ) {
		if ( ! defined( 'MI_NO_TRACKING_OPTOUT' ) ) {
			define( 'MI_NO_TRACKING_OPTOUT', true );
		}
		$options['campaignSource'] = "'set', 'campaignSource', 'Facebook'";
		$options['campaignMedium'] = "'set', 'campaignMedium', 'Social Instant Article'";
		$options['title']          = "'set', 'title', '" . esc_js( get_the_title() ) . "'";
	}

	return $options;
}

add_filter( 'monsterinsights_frontend_tracking_options_analytics_before_pageview', 'monsterinsights_fbia_params' );

// Filter used for the gtag tracking.
function monsterinsights_fbia_params_gtag( $options ) {
	if ( function_exists( 'is_transforming_instant_article' ) && is_transforming_instant_article() ) {
		if ( ! defined( 'MI_NO_TRACKING_OPTOUT' ) ) {
			define( 'MI_NO_TRACKING_OPTOUT', true );
		}
		$options['campaign']   = json_encode( array(
			'source' => 'Facebook',
			'medium' => 'Social Instant Article',
		) );
		$options['page_title'] = esc_js( get_the_title() );
	}

	return $options;
}

add_filter( 'monsterinsights_frontend_tracking_options_gtag_before_pageview', 'monsterinsights_fbia_params_gtag' );

/**
 * Add tracking code to the registered analytics options.
 *
 * @param array $registry Reference param. The registry where it will be stored.
 */
function monsterinsights_fbia_add_to_registry( &$registry ) {

	if ( ! function_exists( 'monsterinsights_tracking_script' ) ) {
		return;
	}
	$display_name = 'Google Analytics by MonsterInsights';

	$identifier = 'google-analytics-for-wordpress';

	ob_start();
	monsterinsights_tracking_script();
	$embed_code = ob_get_clean();

	$registry[ $identifier ] = array(
		'name'    => $display_name,
		'payload' => $embed_code,
	);
}

add_action( 'instant_articles_compat_registry_analytics', 'monsterinsights_fbia_add_to_registry', 10, 1 );

/**
 * Remove 'async' tag from the script. Adding 'async' created an issue while
 * outputting the script due to invalid XML Format.
 *
 * @return bool
 * @since 1.1.3
 *
 */
function monsterinsights_remove_async_tag() {

	if ( function_exists( 'is_transforming_instant_article' ) && is_transforming_instant_article() ) {
		return false;
	}

	return true;
}

add_filter( 'monsterinsights_frontend_gtag_script_async', 'monsterinsights_remove_async_tag' );
