import { registerBlockType } from '@wordpress/blocks';

import blockMeta from './block.json';
import './style.scss';
import Edit from './edit';

const { name, ...settings } = blockMeta;

registerBlockType(
	name,
	{
		...settings,
		icon: (
			<svg width="24" height="14" viewBox="0 0 24 14" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path fillRule="evenodd" clipRule="evenodd" d="M20 2H22V12H20V14H22H24V12V2V0H22H20V2ZM4 2V0H2H0V2V12V14H2H4V12H2V2H4Z" fill="#2B292B" />
				<path
					fillRule="evenodd" clipRule="evenodd" d="M8.53498 6.307C8.62599 6.39801 8.69819 6.50605 8.74744 6.62495C8.7967 6.74386 8.82205 6.8713 8.82205 7C8.82205 7.12871 8.7967 7.25615 8.74744 7.37506C8.69819 7.49396 8.62599 7.602 8.53498 7.693C8.17603 8.04983 7.96902 8.53167 7.9573 9.03767C7.94558 9.54366 8.13005 10.0346 8.4721 10.4076C8.81415 10.7807 9.28725 11.007 9.79236 11.0391C10.2975 11.0712 10.7954 10.9067 11.182 10.58L11.392 10.39C11.588 10.2339 11.8365 10.1589 12.0862 10.1803C12.3358 10.2018 12.5678 10.318 12.7344 10.5053C12.901 10.6925 12.9896 10.9364 12.9819 11.1869C12.9742 11.4374 12.8708 11.6754 12.693 11.852C12.3289 12.2161 11.8967 12.5049 11.4209 12.702C10.9452 12.899 10.4354 13.0004 9.92048 13.0004C9.40558 13.0004 8.89572 12.899 8.42001 12.702C7.94431 12.5049 7.51207 12.2161 7.14798 11.852C6.78389 11.4879 6.49508 11.0557 6.29803 10.58C6.10099 10.1043 5.99957 9.59441 5.99957 9.0795C5.99957 8.5646 6.10099 8.05475 6.29803 7.57904C6.49508 7.10333 6.78389 6.67109 7.14798 6.307C7.239 6.21584 7.3471 6.14352 7.4661 6.09418C7.5851 6.04483 7.71266 6.01943 7.84148 6.01943C7.9703 6.01943 8.09786 6.04483 8.21686 6.09418C8.33586 6.14352 8.44396 6.21584 8.53498 6.307ZM13.386 5.614C13.477 5.70501 13.5492 5.81305 13.5984 5.93195C13.6477 6.05086 13.6731 6.1783 13.6731 6.307C13.6731 6.43571 13.6477 6.56315 13.5984 6.68206C13.5492 6.80096 13.477 6.909 13.386 7L12 8.386C11.8162 8.5698 11.5669 8.67305 11.307 8.67305C11.0471 8.67305 10.7978 8.5698 10.614 8.386C10.4302 8.20221 10.3269 7.95293 10.3269 7.693C10.3269 7.43308 10.4302 7.1838 10.614 7L12 5.614C12.091 5.52299 12.199 5.4508 12.3179 5.40154C12.4368 5.35229 12.5643 5.32693 12.693 5.32693C12.8217 5.32693 12.9491 5.35229 13.068 5.40154C13.1869 5.4508 13.295 5.52299 13.386 5.614ZM16.852 2.148C17.2162 2.51203 17.5051 2.94425 17.7022 3.41997C17.8993 3.89568 18.0008 4.40557 18.0008 4.9205C18.0008 5.43544 17.8993 5.94533 17.7022 6.42104C17.5051 6.89676 17.2162 7.32898 16.852 7.693C16.761 7.78408 16.6529 7.85633 16.534 7.90564C16.4151 7.95496 16.2876 7.98036 16.1588 7.98041C16.0301 7.98045 15.9026 7.95514 15.7836 7.90592C15.6647 7.85669 15.5566 7.78451 15.4655 7.6935C15.3744 7.6025 15.3022 7.49445 15.2528 7.37552C15.2035 7.25659 15.1781 7.12911 15.1781 7.00036C15.178 6.87161 15.2033 6.74411 15.2526 6.62515C15.3018 6.50618 15.374 6.39808 15.465 6.307C15.8239 5.95018 16.0309 5.46834 16.0427 4.96234C16.0544 4.45635 15.8699 3.96544 15.5279 3.59238C15.1858 3.21932 14.7127 2.99304 14.2076 2.96091C13.7025 2.92878 13.2045 3.09329 12.818 3.42L12.608 3.61C12.4119 3.76608 12.1635 3.84112 11.9138 3.81968C11.6641 3.79825 11.4321 3.68197 11.2655 3.49476C11.0989 3.30754 11.0104 3.06362 11.0181 2.81313C11.0258 2.56264 11.1292 2.32462 11.307 2.148C11.671 1.78381 12.1032 1.4949 12.5789 1.29779C13.0547 1.10068 13.5645 0.999222 14.0795 0.999222C14.5944 0.999222 15.1043 1.10068 15.58 1.29779C16.0557 1.4949 16.488 1.78381 16.852 2.148Z" fill="#2B292B"
				/>
			</svg>
		),
		edit: Edit,
		save: () => null,
		transforms: {
			from: [
				{
					type: 'shortcode',
					tag: [ 'gv_entry_link' ],
					attributes: {
						viewId: {
							type: 'string',
							shortcode: ( { named: { viewId } } ) => viewId
						},
						entryId: {
							type: 'string',
							shortcode: ( { named: { entryId } } ) => entryId
						},
						action: {
							type: 'string',
							shortcode: ( { named: { action } } ) => action
						},
						postId: {
							type: 'number',
							shortcode: ( { named: { postId } } ) => postId
						},
						return: {
							type: 'string',
							shortcode: ( { named: { returnFormat } } ) => returnFormat
						},
						linkAtts: {
							type: 'string',
							shortcode: ( { named: { linkAtts } } ) => linkAtts
						},
						fieldValues: {
							type: 'string',
							shortcode: ( { named: { fieldValues } } ) => fieldValues
						},
						content: {
							type: 'string',
							shortcode: ( ref, data ) => data?.shortcode?.content
						},
					},
				},
			],
		},
	}
);
