<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.
/**
 *
 * Field: icon
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! class_exists( 'GREET_BUBBLE_PRO_Field_icon' ) ) {
  class GREET_BUBBLE_PRO_Field_icon extends GREET_BUBBLE_PRO_Fields {

    public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {
      parent::__construct( $field, $value, $unique, $where, $parent );
    }

    public function render() {

      $args = wp_parse_args( $this->field, array(
        'button_title' => esc_html__( 'Add Icon', 'greet-bubble-pro' ),
        'remove_title' => esc_html__( 'Remove Icon', 'greet-bubble-pro' ),
      ) );

      echo wp_kses_post($this->field_before());

      $nonce  = wp_create_nonce( 'greet_bubble_pro_icon_nonce' );
      $hidden = ( empty( $this->value ) ) ? ' hidden' : '';

      echo '<div class="greet-bubble-pro-icon-select">';
      echo '<span class="greet-bubble-pro-icon-preview'. esc_attr( $hidden ) .'"><i class="'. esc_attr( $this->value ) .'"></i></span>';
      echo '<a href="#" class="button button-primary greet-bubble-pro-icon-add" data-nonce="'. esc_attr( $nonce ) .'">'. $args['button_title'] .'</a>';
      echo '<a href="#" class="button greet-bubble-pro-warning-primary greet-bubble-pro-icon-remove'. esc_attr( $hidden ) .'">'. $args['remove_title'] .'</a>';
      echo '<input type="hidden" name="'. esc_attr( $this->field_name() ) .'" value="'. esc_attr( $this->value ) .'" class="greet-bubble-pro-icon-value"'. $this->field_attributes() .' />';
      echo '</div>';

      echo wp_kses_post($this->field_after());

    }

    public function enqueue() {
      add_action( 'admin_footer', array( 'GREET_BUBBLE_PRO_Field_icon', 'add_footer_modal_icon' ) );
      add_action( 'customize_controls_print_footer_scripts', array( 'GREET_BUBBLE_PRO_Field_icon', 'add_footer_modal_icon' ) );
    }

    public static function add_footer_modal_icon() {
    ?>
      <div id="greet-bubble-pro-modal-icon" class="greet-bubble-pro-modal greet-bubble-pro-modal-icon hidden">
        <div class="greet-bubble-pro-modal-table">
          <div class="greet-bubble-pro-modal-table-cell">
            <div class="greet-bubble-pro-modal-overlay"></div>
            <div class="greet-bubble-pro-modal-inner">
              <div class="greet-bubble-pro-modal-title">
                <?php esc_html_e( 'Add Icon', 'greet-bubble-pro' ); ?>
                <div class="greet-bubble-pro-modal-close greet-bubble-pro-icon-close"></div>
              </div>
              <div class="greet-bubble-pro-modal-header">
                <input type="text" placeholder="<?php esc_html_e( 'Search...', 'greet-bubble-pro' ); ?>" class="greet-bubble-pro-icon-search" />
              </div>
              <div class="greet-bubble-pro-modal-content">
                <div class="greet-bubble-pro-modal-loading"><div class="greet-bubble-pro-loading"></div></div>
                <div class="greet-bubble-pro-modal-load"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php
    }

  }
}
