<?php

namespace ThemeAtelier\GreetBubblePro\Admin\Settings;

use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;
// Cannot access directly.
if (!defined('ABSPATH')) {
    die;
}
/**
 * This class is responsible for Custom CSS settings tab in settings page.
 *
 * @since      1.0.0
 */
class IDonateSettings
{

    /**
     * Custom CSS settings.
     *
     * @since 1.0.0
     * @param string $prefix IDonateSettings.
     */
    public static function section($prefix)
    {

        GREET_BUBBLE_PRO::createSection(
            $prefix,
            array(
                'title'  => esc_html__('GENERAL', 'greet-bubble-pro'),
                'icon'    => 'greet-bubble-pro-tab-icon fa fa-gear',
                'fields' => array(
                    array(
                        'id'       => 'test',
                        'type'     => 'text',
                        'title'    => esc_html__('Test', 'greet-bubble-pro'),
                    ),
                ),
            )
        );
        GREET_BUBBLE_PRO::createSection(
            $prefix,
            array(
                'title'  => esc_html__('GENERAL', 'greet-bubble-pro'),
                'icon'    => 'greet-bubble-pro-tab-icon icofont-settings-alt',
                'fields' => array(
                    array(
                        'id'       => 'test',
                        'type'     => 'text',
                        'title'    => esc_html__('Test', 'greet-bubble-pro'),
                    ),
                ),
            )
        );
    }
}
