<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package greet-bubble-pro
 * @subpackage greet-bubble-pro/Admin/Views/GreetBubbleAdvanced
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\GreetBubblePro\Admin\Views;

use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;

class GreetBubbleAdvanced
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        GREET_BUBBLE_PRO::createSection($prefix, array(
            'title'       => esc_html__('ADVANCED', 'greet-bubble-pro'),
            'icon'        => 'icofont-code-alt',
            'fields' => array(
                array(
                    'id'       => 'greet_additional_css',
                    'type'     => 'code_editor',
                    'title'    => esc_html__('Additional CSS', 'greet-bubble-pro'),
                    'settings' => array(
                        'theme' => 'mbo',
                        'mode'  => 'css',
                    ),
                ),
                array(
                    'id'       => 'greet_additional_js',
                    'type'     => 'code_editor',
                    'title'    => esc_html__('Additional JS', 'greet-bubble-pro'),
                    'settings' => array(
                        'theme' => 'mbo',
                        'mode'  => 'js',
                    ),
                ),
            ),

        ));
    }
}
