<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package greet-bubble-pro
 * @subpackage greet-bubble-pro/Admin/Views/GreetBubbleAppearance
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\GreetBubblePro\Admin\Views;

use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;

class GreetBubbleAppearance
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        GREET_BUBBLE_PRO::createSection($prefix, array(
            'title' => esc_html__('APPEARANCE', 'greet-bubble-pro'),
            'icon' => 'icofont-paint',
            'fields' => array(
                array(
                    'type' => 'section_tab',
                    'tabs' => array(
                        array(
                            'title' => esc_html__('Bubble', 'greet-bubble-pro'),
                            'icon'  => 'icofont-chat',
                            'fields' => array(
                                array(
                                    'id' => 'hi_text',
                                    'title' => esc_html__('Hi text Input', 'greet-bubble-pro'),
                                    'desc' => esc_html__('Change small hi text here', 'greet-bubble-pro'),
                                    'type' => 'text',
                                    'default' => esc_html__('Hi', 'greet-bubble-pro'),
                                ),
                                array(
                                    'id' => 'time_based_load',
                                    'type'  => 'slider',
                                    'title' => esc_html__('Time-Based Loading', 'greet-bubble-pro'),
                                    'desc'  => esc_html__('Define the time range for the Greet plugin to be active. Plugin functions will operate according to the schedule you specify. Use: 0 to 100 second value.', 'greet-bubble-pro'),
                                    'min'     => 0,
                                    'max'     => 100,
                                    'step'    => 1,
                                    'default' => 0,
                                ),
                                array(
                                    'id' => 'session-hide',
                                    'type' => 'switcher',
                                    'title' => esc_html__("Hide for session", "greet-bubble-pro"),
                                    'desc' => esc_html__("Turn on to hide permanently for this session of user visit on close button click", "greet-bubble-pro"),
                                ),
                                array(
                                    'id' => 'pause-video',
                                    'type' => 'switcher',
                                    'title' => esc_html__('Pause video when leaving page', 'greet-bubble-pro'),
                                    'desc' => esc_html__('Turn on the option to pause video if they switch browser tab.', 'greet-bubble-pro'),
                                ),

                                array(
                                    'id' => 'border_color',
                                    'type' => 'color',
                                    'title' => esc_html__('Border Color', 'greet-bubble-pro'),
                                    'desc' => esc_html__('Change bubble border color here', 'greet-bubble-pro'),
                                    'default' => '#7432ff',
                                ),
                                array(
                                    'id'    => 'bubble_button_tooltip',
                                    'type'    => 'switcher',
                                    'title'   => esc_html__('Button tooltip', 'greet-bubble-pro'),
                                    'subtitle' => esc_html__('Show button tooltip.', 'greet-bubble-pro'),
                                    'text_on' => esc_html__('Show', 'greet-bubble-pro'),
                                    'text_off'  => esc_html__('Hide', 'greet-bubble-pro'),
                                    'default'   => true,
                                    'text_width'    => 80,
                                ),
                                array(
                                    'id'    => 'bubble_button_tooltip_text',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Button Tooltip Text', 'greet-bubble-pro'),
                                    'subtitle' => esc_html__('Set button tooltip text.', 'greet-bubble-pro'),
                                    'default' => esc_html__('Need Help? <strong>Chat with us</strong>', 'greet-bubble-pro'),
                                    'dependency' => array('bubble_button_tooltip', '==', 'true'),
                                ),
                                array(
                                    'id'    => 'bubble_button_tooltip_width',
                                    'type'    => 'slider',
                                    'title'   => esc_html__('Button Tooltip Width', 'greet-bubble-pro'),
                                    'subtitle' => esc_html__('Set bubble button tooltip width.', 'greet-bubble-pro'),
                                    'min'     => 20,
                                    'max'     => 500,
                                    'step'    => 5,
                                    'unit'    => 'px',
                                    'default' => 190,
                                    'dependency' => array('bubble_button_tooltip', '==', 'true'),
                                ),
                                array(
                                    'id' => 'bubble_visibility',
                                    'type' => 'button_set',
                                    'title' => esc_html__('Bubble Visibility', 'greet-bubble-pro'),
                                    'desc' => esc_html__('Select bubble visibility you want to show', 'greet-bubble-pro'),
                                    'options' => array(
                                        'everywhere'  => esc_html__('Everywhere', 'greet-bubble-pro'),
                                        'desktop'   => esc_html__('Desktop Only', 'greet-bubble-pro'),
                                        'tablet'    => esc_html__('Tablet Only', 'greet-bubble-pro'),
                                        'mobile'    => esc_html__('Mobile Only', 'greet-bubble-pro'),
                                    ),
                                    'default' => 'everywhere',
                                ),
                            ),
                        ),
                        array(
                            'title' => esc_html__('Position', 'greet-bubble'),
                            'icon'  => 'icofont-hand-drag',
                            'fields'    => array(

                                array(
                                    'id'      => 'bubble_position',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Bubble position', 'greet-bubble-pro'),
                                    'default' => 'right_bottom',
                                    'options'    => array(
                                        'right_bottom'  => esc_html__('Right Bottom', 'greet-bubble-pro'),
                                        'left_bottom' => esc_html__('Left Bottom', 'greet-bubble-pro'),
                                        'right_middle' => esc_html__('Right Middle', 'greet-bubble-pro'),
                                        'left_middle' => esc_html__('Left Middle', 'greet-bubble-pro'),
                                    ),
                                ),

                                array(
                                    'id'    => 'right_bottom',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Bottom', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'default'  => array(
                                        'right'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position', '==', 'right_bottom', 'any'),
                                ),

                                array(
                                    'id'    => 'left_bottom',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Bottom', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'right'  => false,
                                    'default'  => array(
                                        'left'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position', '==', 'left_bottom', 'any'),
                                ),

                                array(
                                    'id'    => 'right_middle',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Middle', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'bottom'  => false,
                                    'default'  => array(
                                        'right'    => '20',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position', '==', 'right_middle', 'any'),
                                ),

                                array(
                                    'id'    => 'left_middle',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Middle', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'right' => false,
                                    'bottom' => false,
                                    'default'  => array(
                                        'left' => '20',
                                        'unit' => 'px',
                                    ),
                                    'dependency' => array('bubble_position', '==', 'left_middle', 'any'),
                                ),

                                array(
                                    'type'  => 'subheading',
                                    'title' => esc_html__('Different Positioning on Tablet', 'greet-bubble-pro'),
                                    'dependency' => array('bubble_visibility', '==', 'everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'enable-positioning-tablet',
                                    'type'  => 'switcher',
                                    'title' => esc_html__('Use Different Positioning for Tablet Devices', 'greet-bubble-pro'),
                                    'text_on' => esc_html__('Yes', 'greet-bubble-pro'),
                                    'text_off'  => esc_html__('No', 'greet-bubble-pro'),
                                    'dependency' => array('bubble_visibility', '==', 'everywhere', 'any'),
                                ),

                                // Bubble position
                                array(
                                    'id'      => 'bubble_position_tablet',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Bubble position', 'greet-bubble-pro'),
                                    'default' => 'right_bottom',
                                    'options'    => array(
                                        'right_bottom'  => esc_html__('Right Bottom', 'greet-bubble-pro'),
                                        'left_bottom' => esc_html__('Left Bottom', 'greet-bubble-pro'),
                                        'right_middle' => esc_html__('Right Middle', 'greet-bubble-pro'),
                                        'left_middle' => esc_html__('Left Middle', 'greet-bubble-pro'),
                                    ),
                                    'dependency' => array('enable-positioning-tablet|bubble_visibility', '==|==', 'true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'right_bottom_tablet',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Bottom', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'default'  => array(
                                        'right'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position_tablet|enable-positioning-tablet|bubble_visibility', '==|==|==', 'right_bottom|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'left_bottom_tablet',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Bottom', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'right'  => false,
                                    'default'  => array(
                                        'left'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position_tablet|enable-positioning-tablet|bubble_visibility', '==|==|==', 'left_bottom|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'right_middle_tablet',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Middle', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'bottom'  => false,
                                    'default'  => array(
                                        'right'    => '20',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position_tablet|enable-positioning-tablet|bubble_visibility', '==|==|==', 'right_middle|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'left_middle_tablet',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Middle', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'right' => false,
                                    'bottom' => false,
                                    'default'  => array(
                                        'left' => '20',
                                        'unit' => 'px',
                                    ),
                                    'dependency' => array('bubble_position_tablet|enable-positioning-tablet|bubble_visibility', '==|==|==', 'left_middle|true|everywhere', 'any'),
                                ),

                                array(
                                    'type'  => 'subheading',
                                    'title' => esc_html__('Different Positioning on Mobile', 'greet-bubble-pro'),
                                    'dependency'    => array('bubble_visibility', '==', 'everywhere', 'any')
                                ),
                                array(
                                    'id'    => 'enable-positioning-mobile',
                                    'type'  => 'switcher',
                                    'title' => esc_html__('Use Different Positioning for Mobile Devices', 'greet-bubble-pro'),
                                    'text_on' => esc_html__('Yes', 'greet-bubble-pro'),
                                    'text_off'  => esc_html__('No', 'greet-bubble-pro'),
                                    'dependency'    => array('bubble_visibility', '==', 'everywhere', 'any')
                                ),

                                // Bubble position
                                array(
                                    'id'      => 'bubble_position_mobile',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Bubble position', 'greet-bubble-pro'),
                                    'default' => 'right_bottom',
                                    'options'    => array(
                                        'right_bottom'  => esc_html__('Right Bottom', 'greet-bubble-pro'),
                                        'left_bottom' => esc_html__('Left Bottom', 'greet-bubble-pro'),
                                        'right_middle' => esc_html__('Right Middle', 'greet-bubble-pro'),
                                        'left_middle' => esc_html__('Left Middle', 'greet-bubble-pro'),
                                    ),
                                    'dependency' => array('enable-positioning-mobile|bubble_visibility', '==|==', 'true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'right_bottom_mobile',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Bottom', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'default'  => array(
                                        'right'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position_mobile|enable-positioning-mobile|bubble_visibility', '==|==|==', 'right_bottom|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'left_bottom_mobile',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Bottom', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'right'  => false,
                                    'default'  => array(
                                        'left'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position_mobile|enable-positioning-mobile|bubble_visibility', '==|==|==', 'left_bottom|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'right_middle_mobile',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Middle', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'bottom'  => false,
                                    'default'  => array(
                                        'right'    => '20',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble_position_mobile|enable-positioning-mobile|bubble_visibility', '==|==|==', 'right_middle|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'left_middle_mobile',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Middle', 'greet-bubble-pro'),
                                    'top'   => false,
                                    'right' => false,
                                    'bottom' => false,
                                    'default'  => array(
                                        'left' => '20',
                                        'unit' => 'px',
                                    ),
                                    'dependency' => array('bubble_position_mobile|enable-positioning-mobile|bubble_visibility', '==|==|==', 'left_middle|true|everywhere', 'any'),
                                ),

                            )
                        ),
                        array(
                            'title' => esc_html__('Button', 'greet-bubble-pro'),
                            'icon'  => 'icofont-external-link',
                            'fields' => array(
                                array(
                                    'id' => 'button_display_type',
                                    'type' => 'button_set',
                                    'title' => esc_html__('Button Display Type', 'greet-bubble-pro'),
                                    'options' => array(
                                        'text_only' => esc_html__('Text Only', 'greet-bubble-pro'),
                                        'with_icon_and_text' => esc_html__('With Icon and Text', 'greet-bubble-pro'),
                                        'icon_only' => esc_html__('Icon Only', 'greet-bubble-pro'),
                                    ),
                                    'default' => 'text_only',
                                ),
                                array(
                                    'id' => 'icon_only_button_dimension',
                                    'title' => esc_html__('Button Dimension', 'greet-bubble-pro'),
                                    'type' => 'dimensions',
                                    'default' => array(
                                        'width' => '40',
                                        'height' => '40',
                                        'unit' => 'px',
                                    ),
                                    'dependency' => array('button_display_type', '==', 'icon_only'),
                                ),
                                array(
                                    'id' => 'button_type',
                                    'type' => 'button_set',
                                    'title' => esc_html__('Button Type', 'greet-bubble-pro'),
                                    'options' => array(
                                        'square' => esc_html__('Square', 'greet-bubble-pro'),
                                        'rounded' => esc_html__('Rounded', 'greet-bubble-pro'),
                                    ),
                                    'default' => 'rounded',
                                ),
                                array(
                                    'id' => 'button_radius',
                                    'type' => 'slider',
                                    'title' => esc_html__('Button Radius', 'greet-bubble-pro'),
                                    'default' => 5,
                                    'dependency' => array('button_type', '==', 'rounded'),
                                ),
                                array(
                                    'id' => 'buttonsColors',
                                    'type' => 'color_group',
                                    'title' => esc_html__('Buttons Colors', 'greet-bubble-pro'),
                                    'options' => array(
                                        'buttons_bg' => esc_html__('Background', 'greet-bubble-pro'),
                                        'buttons_color' => esc_html__('Text Color', 'greet-bubble-pro'),
                                        'buttons_hover_bg' => esc_html__('Background Hover', 'greet-bubble-pro'),
                                        'buttons_hover_color' => esc_html__('Hover Text Color', 'greet-bubble-pro'),
                                    ),
                                    'default' => array(
                                        'buttons_bg' => '#7432ff',
                                        'buttons_color' => '#ffffff',
                                        'buttons_hover_bg' => '#7113ff',
                                        'buttons_hover_color' => '#ffffff',
                                    ),
                                ),
                                array(
                                    'id'    => 'buttons_tooltip',
                                    'type'    => 'switcher',
                                    'title'   => esc_html__('Buttons tooltip', 'greet-bubble-pro'),
                                    'subtitle' => esc_html__('Show button tooltip.', 'greet-bubble-pro'),
                                    'text_on' => esc_html__('Show', 'greet-bubble-pro'),
                                    'text_off'  => esc_html__('Hide', 'greet-bubble-pro'),
                                    'default'   => true,
                                    'text_width'    => 80,
                                ),
                                array(
                                    'id'    => 'buttons_tooltip_width',
                                    'type'    => 'slider',
                                    'title'   => esc_html__('Buttons Tooltip Width', 'greet-bubble-pro'),
                                    'subtitle' => esc_html__('Set bubble under button tooltip width.', 'greet-bubble-pro'),
                                    'min'     => 20,
                                    'max'     => 500,
                                    'step'    => 5,
                                    'unit'    => 'px',
                                    'default' => 190,
                                    'dependency' => array('buttons_tooltip', '==', 'true'),
                                ),
                                array(
                                    'id' => 'buttons_tooltip_position',
                                    'type' => 'button_set',
                                    'title' => esc_html__('Buttons tooltip Position', 'greet-bubble-pro'),
                                    'options' => array(
                                        'top' => esc_html__('Top', 'greet-bubble-pro'),
                                        'bottom' => esc_html__('Bottom', 'greet-bubble-pro'),
                                        'left' => esc_html__('Left', 'greet-bubble-pro'),
                                        'right' => esc_html__('Right', 'greet-bubble-pro'),
                                    ),
                                    'default' => 'top',
                                ),
                            ),
                        ),
                        array(
                            'title' => esc_html__('Others', 'greet-bubble-pro'),
                            'icon'  => 'icofont-swirl',
                            'fields' => array(
                                array(
                                    'id' => 'scroll_bar_colors',
                                    'type' => 'color_group',
                                    'title' => esc_html__('Scroll Bar Colors', 'greet-bubble-pro'),
                                    'desc' => esc_html__('Some popup elements like contact forms use scroll bars. Change their colors from this option.', 'greet-bubble-pro'),
                                    'options' => array(
                                        'track_bg' => esc_html__('Track Background', 'greet-bubble-pro'),
                                        'thumb_bg' => esc_html__('Thumb Background', 'greet-bubble-pro'),
                                    ),
                                    'default' => array(
                                        'thumb_bg' => '#7432ff',
                                        'track_bg' => '#eeeeee',
                                    ),
                                ),
                                array(
                                    'id' => 'show_pages',
                                    'type' => 'select',
                                    'title' => esc_html__('Show Specific Pages Only', 'greet-bubble-pro'),
                                    'chosen' => true,
                                    'multiple' => true,
                                    'sortable' => false,
                                    'ajax' => true,
                                    'options' => 'pages',
                                    'placeholder' => esc_html__('Select Pages', 'greet-bubble-pro'),
                                ),
                                array(
                                    'id'        => 'disallow_pages',
                                    'type'      => 'select',
                                    'title'     => esc_html__('Disallowed Pages', 'greet-bubble-pro'),
                                    'chosen'    => true,
                                    'multiple'  => true,
                                    'sortable'  => false,
                                    'ajax'      => true,
                                    'options'   => 'pages',
                                    'placeholder' => esc_html__('Select Pages', 'greet-bubble-pro'),
                                ),
                                array(
                                    'id'        => 'show_posts',
                                    'type'      => 'select',
                                    'title'     => esc_html__('Show Specific Post Only', 'greet-bubble-pro'),
                                    'chosen'    => true,
                                    'multiple'  => true,
                                    'sortable'  => false,
                                    'ajax'      => true,
                                    'options'   => 'post',
                                    'placeholder' => esc_html__('Select Post', 'greet-bubble-pro'),
                                ),
                                array(
                                    'id'        => 'disallow_posts',
                                    'type'      => 'select',
                                    'title'     => esc_html__('Disallowed Posts', 'greet-bubble-pro'),
                                    'chosen'    => true,
                                    'multiple'  => true,
                                    'sortable'  => false,
                                    'ajax'      => true,
                                    'options'   => 'post',
                                    'placeholder' => esc_html__('Select Post', 'greet-bubble-pro'),
                                ),
                            ),
                        ),
                    ),
                ),
            ),
        ));
    }
}
