<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package greet-bubble-pro
 * @subpackage greet-bubble-pro/Admin/Views/GreetBubbleControls
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\GreetBubblePro\Admin\Views;

use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;

class GreetBubbleControls
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        GREET_BUBBLE_PRO::createSection($prefix, array(
            'title'       => esc_html__('CONTROLS', 'greet-bubble-pro'),
            'icon'        => 'icofont-eye-alt',
            'fields'      => array(
                array(
                    'id'      => 'loop_video',
                    'type'    => 'switcher',
                    'title'   => esc_html__('Loop video', 'greet-bubble-pro'),
                    'default' => true,
                ),
                array(
                    'id'      => 'hide_replay',
                    'type'    => 'switcher',
                    'title'   => esc_html__('Hide re-play control', 'greet-bubble-pro'),
                    'default' => true,
                ),
                array(
                    'id'      => 'hide_mute_unmute',
                    'type'    => 'switcher',
                    'title'   => esc_html__('Hide mute/unmute control', 'greet-bubble-pro'),
                    'default' => true,
                ),
                array(
                    'title'   => esc_html__('Hide fullscreen control', 'greet-bubble-pro'),
                    'id'      => 'hide_fullscreen',
                    'type'    => 'switcher',
                    'default' => true,
                ),
            )
        ));
    }
}
