<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package greet-bubble-pro
 * @subpackage greet-bubble-pro/Admin/Views/GreetBubbleGeneral
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\GreetBubblePro\Admin\Views;

use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;

class GreetBubbleGeneral
{
    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        GREET_BUBBLE_PRO::createSection($prefix, array(
            'title'  => esc_html__('General', 'greet-bubble-pro'),
            'icon'   => 'icofont-settings',
            'fields' => array(
                array(
                    'id'    => 'poster',
                    'type'  => 'media',
                    'title' => esc_html__('Default video poster', 'greet-bubble-pro'),
                    'desc'  => esc_html__('Specifies an image to be shown while the video is downloading, or until the user hits the play button. If this is not included, the first frame of the video will be used instead.', 'greet-bubble-pro'),
                    'library' => 'image',
                ),
                array(
                    'id'      => 'video',
                    'type'    => 'media',
                    'title'   => esc_html__('Upload default Video (mp4)*', 'greet-bubble-pro'),
                    'desc'  =>  __('If you do not have a mp4 video you may use <a href="http://www.freeconvert.com" target="_blank">this website</a> to convert your current version of video.', 'greet-bubble-pro'),
                    'subtitle'  => esc_html__('This field is required to work greet bubble in your website.', 'greet-bubble-pro'),
                    'library' => 'video',

                ),
                array(
                    'id'     => 'bubble_buttons',
                    'type'   => 'group',
                    'accordion_title_number' => true,
                    'title'  => esc_html__('Include Buttons', 'greet-bubble-pro'),
                    'desc'   => __('By including a button you will able to use different functionalities on button click', 'greet-bubble-pro'),
                    'fields' => array(


                        array(
                            'id'    => 'button_text',
                            'title' => esc_html__('Button Text', 'greet-bubble-pro'),
                            'desc' => esc_html__('Add button text here. If you don\'t want to show the button just keep it blank.', 'greet-bubble-pro'),
                            'type'  => 'text',
                            'default' => esc_html__('Make a booking', 'greet-bubble-pro'),
                        ),
                        array(
                            'id'    => 'button_icon',
                            'title' => esc_html__('Button Icon', 'greet-bubble-pro'),
                            'desc' => esc_html__('Select Button icon', 'greet-bubble-pro'),
                            'type'  => 'icon',
                        ),

                        array(
                            'id'      => 'button_behavior',
                            'type'    => 'button_set',
                            'inline'    => 'true',
                            'title'   => esc_html__('Button Behavior', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Select option to behave on button click', 'greet-bubble-pro'),
                            'options'    => array(
                                'another_video' => esc_html__('Another Video', 'greet-bubble-pro'),
                                'external_link' => esc_html__('External Link', 'greet-bubble-pro'),
                                'contact_form' => esc_html__('Contact Form', 'greet-bubble-pro'),
                            ),
                            'default' => 'another_video',
                        ),
                        array(
                            'id'      => 'video_link',
                            'type'    => 'media',
                            'title'   => esc_html__('Upload Video (mp4)*', 'greet-bubble-pro'),
                            'desc'  =>  __('If you do not have a mp4 video you may use <a href="http://www.freeconvert.com" target="_blank">this website</a> to convert your current version of video.', 'greet-bubble-pro'),
                            'library' => 'video',
                            'dependency' => array('button_behavior', '==', 'another_video'),
                        ),

                        array(
                            'id'    => 'button_link',
                            'title' => esc_html__('Add Button Link', 'greet-bubble-pro'),
                            'desc' => esc_html__('Add link for opening as external link on first button click. Remove link if you want to load second video instead of link.', 'greet-bubble-pro'),
                            'type'  => 'link',
                            'dependency' => array('button_behavior', '==', 'external_link'),
                        ),
                        array(
                            'id'    => 'form_title',
                            'type'  => 'text',
                            'title' => esc_html__('Form Title', 'greet-bubble-pro'),
                            'desc' => esc_html__('Add form title to show before form input.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior', '==', 'contact_form'),
                        ),
                        array(
                            'id'      => 'form_type',
                            'type'    => 'radio',
                            'inline'    => 'true',
                            'title'   => esc_html__('Form Type', 'greet-bubble-pro'),
                            'options'    => array(
                                'web3forms' => esc_html__('Web3Forms', 'greet-bubble-pro'),
                                'external_form_shortcode' => esc_html__('Shortcode', 'greet-bubble-pro'),
                                'whatsapp_form' => esc_html__('Whatsapp', 'greet-bubble-pro'),
                            ),
                            'default' => 'web3forms',
                            'dependency' => array('button_behavior', '==', 'contact_form'),
                        ),
                        array(
                            'id'    => 'email_subject',
                            'type'  => 'text',
                            'title' => esc_html__('Email Subject', 'greet-bubble-pro'),
                            'default' => esc_html__('New Email form your website', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Set text for email subject.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'name',
                            'type'  => 'text',
                            'title' => esc_html__('Name Placeholder', 'greet-bubble-pro'),
                            'default' => esc_html__('Your Name', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Placeholder text for name field.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'email',
                            'type'  => 'text',
                            'validate'  => 'email',
                            'title' => esc_html__('Email Placeholder', 'greet-bubble-pro'),
                            'default' => esc_html__('Your Email', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Placeholder text for email field.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'phone',
                            'type'  => 'text',
                            'title' => esc_html__('Phone Placeholder', 'greet-bubble-pro'),
                            'default' => esc_html__('Your Phone', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Placeholder text for phone number field.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'message',
                            'type'  => 'text',
                            'title' => esc_html__('Message Placeholder', 'greet-bubble-pro'),
                            'default' => esc_html__('Enter your message here..', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Placeholder text for message field.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'external_form_shortcode',
                            'type'  => 'text',
                            'title' => esc_html__('Shortcode', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Set Shortcode for contact form.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|external_form_shortcode'),
                        ),
                        array(
                            'id'    => 'web3form_button_text',
                            'type'  => 'text',
                            'title' => esc_html__('Button Text', 'greet-bubble-pro'),
                            'default' => esc_html__('Send Email', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Set text for button.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'web3form_loading_message',
                            'type'  => 'text',
                            'title' => esc_html__('Loading Message Text', 'greet-bubble-pro'),
                            'default' => esc_html__('Please wait...', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Set text for loading message.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'web3form_success_message',
                            'type'  => 'text',
                            'title' => esc_html__('Success Message Text', 'greet-bubble-pro'),
                            'default' => esc_html__('Email Sent Successful!', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Set text for success message.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'web3form_error_message',
                            'type'  => 'text',
                            'title' => esc_html__('Error Message Text', 'greet-bubble-pro'),
                            'default' => esc_html__('Something went wrong!', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Set text for error message.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'access_key',
                            'type'  => 'text',
                            'title' => esc_html__('Access Key', 'greet-bubble-pro'),
                            'desc'  => __('Enter <a style="font-weight: 700;" target="_blank" href="https://web3forms.com/#start">Web3Form</a> access key.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|web3forms'),
                        ),
                        array(
                            'id'    => 'whatsapp_number',
                            'type'  => 'text',
                            'title' => esc_html__('Number', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Enter your WhatsApp number here including country code.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|whatsapp_form'),
                        ),
                        array(
                            'id'    => 'user_name',
                            'type'  => 'text',
                            'title' => esc_html__('Name Placeholder', 'greet-bubble-pro'),
                            'default' => esc_html__('Name', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Placeholder text for subject field.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|whatsapp_form'),
                        ),
                        array(
                            'id'    => 'whatsapp_message',
                            'type'  => 'text',
                            'title' => esc_html__('Message Placeholder', 'greet-bubble-pro'),
                            'default' => esc_html__('Enter your message here..', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Placeholder text for message field.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|whatsapp_form'),
                        ),
                        array(
                            'id'    => 'whatsapp_button_text',
                            'type'  => 'text',
                            'title' => esc_html__('Button Text', 'greet-bubble-pro'),
                            'default' => esc_html__('Send Message', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Add text for whatsapp form button.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|whatsapp_form'),
                        ),
                        array(
                            'id'    => 'whatsapp_loading_text',
                            'type'  => 'text',
                            'title' => esc_html__('Loading Text', 'greet-bubble-pro'),
                            'default' => esc_html__('Redirecting...', 'greet-bubble-pro'),
                            'desc'  => esc_html__('Add text for submit loading text.', 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|whatsapp_form'),
                        ),

                        array(
                            'id'    => 'greet_email_template',
                            'type'  => 'textarea',
                            'title' => esc_html__('Message Template', 'greet-bubble-pro'),
                            'default' => esc_html__("Name: {name}.\n\n Message: {message}\n\nDate: {date}", 'greet-bubble-pro'),
                            'desc'  => esc_html__("Available tags &ndash; {name}, {message}, {date}, {siteURL}, {currentURL}", 'greet-bubble-pro'),
                            'dependency' => array('button_behavior|form_type', '==|==', 'contact_form|whatsapp_form'),
                        ),
                    ),
                ),

            )
        ));
    }
}
