<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package greet-bubble-pro
 * @subpackage greet-bubble-pro/Admin/Views/GreetBubbleMetaboxOptions
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\GreetBubblePro\Admin\Views;

use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleGeneral;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleMetaboxAppearance;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleControls;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleTypography;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleAdvanced;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleBackup;
use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;

class GreetBubbleMetaboxOptions
{
  /**
   * Custom CSS settings.
   *
   * @since 1.0.0
   * @param string $prefix GreetBubbleMetaboxOptions.
   */
  public static function section($prefix)
  {
    GREET_BUBBLE_PRO::createMetabox($prefix, array(
      'title'        => esc_html__('Greet Video Options', 'greet-bubble-pro'),
      'post_type'    => array("post", "page", "product"),
      'theme'        => 'light',
      'nav'        => 'inline',
      'show_restore' => true,
    ));



    GreetBubbleGeneral::options($prefix);
    GreetBubbleMetaboxAppearance::options($prefix);
    GreetBubbleControls::options($prefix);
    GreetBubbleTypography::options($prefix);
    GreetBubbleAdvanced::options($prefix);
  }
}
