<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package greet-bubble-pro
 * @subpackage greet-bubble-pro/Admin/Views/GreetBubbleTypography
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\GreetBubblePro\Admin\Views;

use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;

class GreetBubbleTypography
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        GREET_BUBBLE_PRO::createSection($prefix, array(
            'title'       => esc_html__('TYPOGRAPHY', 'greet-bubble-pro'),
            'icon'        => 'icofont-font',
            'fields'      => array(
                array(
                    'id'    => 'hi_text_typography',
                    'title' => esc_html__('Hi text typography', 'greet-bubble-pro'),
                    'output'    => '.greet_wrapper .greet_text',
                    'type'  => 'typography',
                ),
                array(
                    'id'    => 'buttons_typography',
                    'type'  => 'typography',
                    'title' => esc_html__('Buttons Typography', 'greet-bubble-pro'),
                    'color' => false,
                    'text_align'    => false,
                    'output'    => '.greet_wrapper_full .greet_change_video [class*=video] a',
                ),

            )
        ));
    }
}
