"use strict";
let greetWrapper = document.getElementById("greet_wrapper");
let greetVideo = document.getElementById("greet_video");
let greetToggler = document.querySelector(".greet_toggler");
let greetFullPlay = document.getElementById("greet_full_play");
let greetFullReplay = document.getElementById("greet_full_replay");
let greetFullVolume = document.getElementById("greet_full_volume");
let greetFullMute = document.getElementById("greet_full_mute");
let greetFullExpand = document.getElementById("greet_full_expand");
let greetFullBtn = document.getElementById("greet_full_btn");
let greetText = document.getElementById("greet_text");
let greetClose = document.querySelector(".greet_close");
let greetFullClose = document.querySelector(".greet_full_close");
let video = document.getElementById("playVideo");
let greetFormClose = document.querySelectorAll(".greet_form_close");
let greetAddFrom = document.querySelectorAll(".greet_add-form");
let emailForm = document.querySelectorAll(".greet_contact_form");
let web3forms = document.querySelectorAll(".web3forms");
let greetWhatsappForm = document.querySelectorAll(".greet_whatsapp_form");
const { pause_on_switch, hide_for_session, loop_video, time_based_load, ajaxurl, nonce } = frontend_scripts;

let timeBasedLoad = time_based_load * 1000;
setTimeout(function() {
  greetWrapper.classList.add("animation_fade");
}, timeBasedLoad); 

if (greetWrapper) {
  (function ($) {
    $("#greet_video").attr("playsinline", "");
  })(jQuery);
 

  greetVideo.autoplay = true;
  greetVideo.muted = true;
  if(loop_video == '1') {
    greetVideo.loop = true;
  } else {
    greetVideo.loop = false;
  }

  if (greetFullExpand) {
    greetFullExpand.addEventListener("click", () => {
      greetVideo.requestFullscreen();
    });
  }
  // Pause video on borwser tab switch
  if (pause_on_switch) {
    document.addEventListener("visibilitychange", () => {
      // Check if any form has the "email-form-active" class
      let isAnyFormActive = Array.from(emailForm).some((form) =>
        form.classList.contains("email-form-active")
      );

      if (document.hidden || isAnyFormActive) {
        greetVideo.pause();
      } else {
        greetVideo.play();
        greetFullPlay.style.display = "none";
        greetWrapper.classList.add("play-video");
      }
    });
  }

  // REPLAY GREET
  if (greetFullReplay) {
    greetFullReplay.addEventListener("click", () => {
      greetVideo.currentTime = 0;
    });
  }
  // VOLUME UP
  if (greetFullVolume) {
    greetFullVolume.addEventListener("click", () => {
      greetFullMute.style.display = "flex";
      greetFullVolume.style.display = "none";
      greetVideo.muted = true;
    });
  }
  // VOLUME MUTE
  if (greetFullMute) {
    greetFullMute.addEventListener("click", () => {
      greetFullVolume.style.display = "flex";
      greetFullMute.style.display = "none";
      greetVideo.muted = false;
    });
  }
  // VIDEO PLAY
  greetFullPlay.addEventListener("click", () => {
    greetVideo.play();
    greetFullPlay.style.display = "none";
    greetWrapper.classList.toggle("play-video");
  });
  // CLOSE TOTAL GREET
  greetClose.addEventListener("click", () => {
    greetWrapper.style.display = "none";
    sessionStorage.setItem(
      "hide_for_session",
      hide_for_session
    );
  });

  let isHideSession = sessionStorage.getItem("hide_for_session") ? sessionStorage.getItem("hide_for_session") : "";

  if (isHideSession == 1) {
    greetWrapper.remove();
  }

  // CLOSE FULL GREET
  greetFullClose.addEventListener("click", () => {
    greetWrapper.classList.remove("greet_wrapper_full");
    greetWrapper.classList.remove("play-video");
    greetVideo.muted = true;
    greetVideo.play();
    greetFullBtn.style.display = "none";
  });
  // OPEN FULL GREET
  const videoModal = () => {
    if (!greetWrapper.classList.contains("greet_wrapper_full")) {
      greetVideo.currentTime = 0;
    }
    greetWrapper.classList.add("greet_wrapper_full");
    greetWrapper.classList.toggle("play-video");
    greetVideo.muted = false;
    if (greetFullMute) {
      greetFullMute.style.display = "none";
    }
    if (greetFullVolume) {
      greetFullVolume.style.display = "flex";
    }
    if (greetWrapper.classList.contains("play-video")) {
      greetVideo.play();
      greetFullPlay.style.display = "none";
    } else {
      greetVideo.pause();
      greetFullPlay.style.display = "flex";
    }
    greetFullBtn.style.display = "block";
  };

  greetVideo.addEventListener("click", () => {
    videoModal();
  });
  greetText.addEventListener("click", () => {
    videoModal();
  });

  // ON SCROLL SIZE CHANGE
  window.addEventListener("scroll", function (event) {
    let scroll = scrollY;
    if (scroll > 1) {
      greetWrapper.classList.add("greet_wrapper-resize");
    } else {
      greetWrapper.classList.remove("greet_wrapper-resize");
    }
  });

  /* Email form */
  if (greetAddFrom) {
    greetAddFrom.forEach((addFrom, $key) => {
      addFrom.addEventListener("click", () => {
        let btnId = addFrom.getAttribute("data-id");
        let formDiv = document.querySelectorAll(".greet_contact_form");
        formDiv.forEach(function (form) {
          let formDataId = form.getAttribute("data-id");
          if (formDataId === btnId) {
            form.classList.add("email-form-active");
          }
        });
        greetVideo.pause();
      });
    });
  }

  if (greetFormClose) {
    greetFormClose.forEach((closeForm) => {
      closeForm.addEventListener("click", () => {
        if (emailForm) {
          emailForm.forEach((form) => {
            form.classList.remove("email-form-active");
          });
        }
        greetVideo.play();
        greetFullPlay.style.display = "none";
        greetWrapper.classList.add("play-video");
      });
    });
  }

  if (web3forms) {
    web3forms.forEach((form) => {
      let button = form.getAttribute("data-button");
      let loading = form.getAttribute("data-loading");
      let successMsg = form.getAttribute("data-success");
      let errorMsg = form.getAttribute("data-error");
      let greetEmailSubmit = form.querySelector(".greet_email_submit");

      form.addEventListener("submit", function (e) {
        const formData = new FormData(form);
        e.preventDefault();
        let object = {};
        formData.forEach((value, key) => {
          object[key] = value;
        });
        let json = JSON.stringify(object);
        greetEmailSubmit.innerHTML = loading;

        fetch("https://api.web3forms.com/submit", {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            Accept: "application/json",
          },
          body: json,
        })
          .then(async (response) => {
            let json = await response.json();
            if (response.status == 200) {
              greetEmailSubmit.innerHTML = successMsg;
            } else {
              greetEmailSubmit.innerHTML = json.message;
            }
          })
          .catch((error) => {
            greetEmailSubmit.innerHTML = errorMsg;
          })
          .then(function () {
            form.reset();
            setTimeout(() => {
              greetEmailSubmit.innerHTML = button;
            }, 5000);
          });
      });
    });
  }
}
/* VIDEO CHANGE ON REPLY BTN CLICK */
function videoChange(videoUrl) {
  video.setAttribute("src", videoUrl);
  greetVideo.load();
  greetVideo.play();
  greetFullPlay.style.display = "none";
  greetWrapper.classList.add("play-video");
}

(function ($) {
  greetWhatsappForm.forEach((whatsappForm) => {
    let submit_btn = whatsappForm.querySelector(".greet_email_submit");
    $(whatsappForm).submit(function (e) {
      e.preventDefault();

      var form = $(this),
        ajaxurl = ajaxurl,
        nonce = nonce;

      let button = whatsappForm.getAttribute("data-button");
      let loading = whatsappForm.getAttribute("data-loading");
      let number = whatsappForm.getAttribute("data-number");
      let template = whatsappForm.getAttribute("data-template");
      let name = form.find("#greet-name").val();
      let message = form.find("#greet-message").val();

      $.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "handle_form_submission",
          nonce: nonce,
          name: name,
          message: message,
          template: template,
          agent: number,
          current_url: window.location.href,
        },
        success: function (response) {
          if (response.success) {
            submit_btn.innerHTML = loading;
            setTimeout(function () {
              window.open(response.data.whatsAppURL, "_blank");
              form[0].reset();
              submit_btn.innerHTML = button;
            }, 2000);
          } else {
            alert("There was an error processing your request.");
          }
        },
        error: function (error) {
          alert("An unexpected error occurred.");
        },
      });
    });
  });
})(jQuery);
