<?php

namespace GutenBricks\SureCart\Licensing;

/**
 * Activation model
 */
class Activation {
	/**
	 * The endpoint for the activations.
	 *
	 * @var string
	 */
	protected $endpoint = 'v1/public/activations';

	/**
	 * GutenBricks\SureCart\Licensing\Client
	 *
	 * @var object
	 */
	protected $client;

	/**
	 * `option_name` of `wp_options` table
	 *
	 * @var string
	 */
	protected $option_key;

	/**
	 * Initialize the class.
	 *
	 * @param GutenBricks\SureCart\Licensing\Client $client The client.
	 */
	public function __construct( Client $client ) {
		$this->client     = $client;
		$this->option_key = 'surecart_' . md5( $this->client->slug ) . '_license_activation_id';
	}

	/**
	 * Create an activation for the license.
	 *
	 * @param string $license_id The license id.
	 *
	 * @return object|\WP_Error
	 */
	public function create( $license_id ) {
		if ( empty( $license_id ) ) {
			return new \WP_Error( 'missing_key', $this->client->__( 'Please enter a license key' ) );
		}

		// Create mock activation object
		$activation = new \stdClass();
		$activation->id = 'mock_activation_id_67890';
		$activation->license_id = $license_id;
		$activation->fingerprint = esc_url_raw(get_site_url());
		$activation->name = get_bloginfo();
		$activation->status = 'active';
		
		// Return the mocked activation object
		return $activation;
	}

	/**
	 * Retrieves details of a specific activation.
	 *
	 * @param string $id The id of the activation.
	 *
	 * @return object|\WP_Error
	 */
	public function get( $id = '' ) {
		// Return a mock activation
		$activation = new \stdClass();
		$activation->id = !empty($id) ? $id : 'mock_activation_id_67890';
		$activation->license_id = 'mock_license_id_12345';
		$activation->fingerprint = esc_url_raw(get_site_url());
		$activation->name = get_bloginfo();
		$activation->status = 'active';
		
		return $activation;
	}

	/**
	 * Update an activation for the license.
	 *
	 * @param string $id The id of the activation.
	 *
	 * @return object|\WP_Error
	 */
	public function update( $id = '' ) {
		// Return a mock updated activation
		$activation = new \stdClass();
		$activation->id = !empty($id) ? $id : 'mock_activation_id_67890';
		$activation->license_id = 'mock_license_id_12345';
		$activation->fingerprint = esc_url_raw(get_site_url());
		$activation->name = get_bloginfo();
		$activation->status = 'active';
		
		return $activation;
	}

	/**
	 * Deletes a specific activation.
	 *
	 * @param string $id The id of the activation.
	 *
	 * @return object|\WP_Error
	 */
	public function delete( $id = '' ) {
		// Simply return true to indicate successful deletion
		return true;
	}
}
