"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["vendors-node_modules_jfb-editor_src_main_js"],{

/***/ "../node_modules/jfb-editor/src/actions/EditorData.js":
/*!************************************************************!*\
  !*** ../node_modules/jfb-editor/src/actions/EditorData.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   getAction: () => (/* binding */ getAction),
/* harmony export */   setAction: () => (/* binding */ setAction)
/* harmony export */ });
class EditorData {
	constructor( type, label ) {
		this.type = type;
		this.label = label;
		this.source = {};
		this.__labels = {};
		this.__help_messages = {};
		this.__gateway_attrs = {};
		this.__messages = {};
	}

	static findIndexByType( staticType ) {
		return window.jetFormActionTypes.findIndex( type => staticType === type.id );
	}

	setSource( config ) {
		this.source = config;

		return this;
	}

	setLabels( config ) {
		this.__labels = JSON.parse( JSON.stringify( config ) );

		return this;
	}

	setHelp( config ) {
		this.__help_messages = JSON.parse( JSON.stringify( config ) );

		return this;
	}

	setGatewayAttrs( config ) {
		this.__gateway_attrs = JSON.parse( JSON.stringify( config ) );

		return this;
	}

	setMessages( config ) {
		this.__messages = JSON.parse( JSON.stringify( config ) );

		return this;
	}

	importAction() {
		if ( ! ( 'jetFormActionTypes' in window ) ) {
			throw new Error( 'There is no registered notifications' );
		}

		const actionIndex = EditorData.findIndexByType( this.type );

		if ( -1 === actionIndex ) {
			throw new Error( `Action type: '${ this.type }' is undefined` );
		}

		const current = window.jetFormActionTypes[ actionIndex ];

		if ( current.__labels ) {
			this.setLabels( current.__labels );
			delete current.__labels;
		}
		if ( current.__help_messages ) {
			this.setHelp( current.__help_messages );
			delete current.__help_messages;
		}
		if ( current.__gateway_attrs ) {
			this.setGatewayAttrs( current.__gateway_attrs );
			delete current.__gateway_attrs;
		}
		if ( current.__messages ) {
			this.setMessages( current.__messages );
			delete current.__gateway_attrs;
		}

		return { ...current, ...this.getExportObject() };
	}

	getExportObject() {
		const label = this.exportLabels();
		const help = this.exportHelp();
		const gatewayAttrs = this.exportGatewayAttrs();
		const messages = this.exportMessages();

		return { label, help, messages, gatewayAttrs }
	}

	exportAll() {
		if ( ! ( 'jetFormActionTypes' in window ) ) {
			window.jetFormActionTypes = [];
		}

		const exportObj = this.getExportObject();
		const actionIndex = EditorData.findIndexByType( this.type );
		const actionData = {
			id: this.type,
			name: this.label,
			...exportObj,
		};

		if ( -1 === actionIndex ) {
			window.jetFormActionTypes.push( actionData );
		} else {
			window.jetFormActionTypes[ actionIndex ] = {
				...window.jetFormActionTypes[ actionIndex ] ,
				...exportObj
			};
		}

		return exportObj;
	}


	exportLabels() {
		return this.getLocalizedWithFunc( '__labels', '[Empty Label]' );
	};

	exportHelp() {
		return this.getLocalizedWithFunc( '__help_messages' );
	};

	exportGatewayAttrs() {
		return this.getLocalizedWithFunc( '__gateway_attrs', [] );
	};

	exportMessages() {
		return this.getLocalizedWithFunc( '__messages', {} );
	};

	getLocalizedWithFunc( objectKey, ifEmptyReturn = '' ) {

		let action = false;

		if ( objectKey in this ) {
			action = this[ objectKey ];
		}

		if ( ! action ) {
			return () => ifEmptyReturn;
		}

		return attr => {
			if ( attr ) {
				return ( action[ attr ] ? action[ attr ] : ifEmptyReturn );
			} else {
				return action;
			}
		};
	};
}

function getAction( type ) {
	const index = EditorData.findIndexByType( type );

	return -1 === index ? {} : window.jetFormActionTypes[ index ];
}

function setAction( type, settings ) {
	delete settings.id;
	const index = EditorData.findIndexByType( type );

	if ( -1 === index ) {
		return false;
	}

	window.jetFormActionTypes[ index ] = {
		...window.jetFormActionTypes[ index ],
		...settings
	};
}



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditorData);

/***/ }),

/***/ "../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue":
/*!*************************************************************************!*\
  !*** ../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _JetFormEditorRow_vue_vue_type_template_id_076e38b6__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./JetFormEditorRow.vue?vue&type=template&id=076e38b6 */ "../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=template&id=076e38b6");
/* harmony import */ var _JetFormEditorRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./JetFormEditorRow.vue?vue&type=script&lang=js */ "../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=script&lang=js");
/* harmony import */ var _vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../vue-loader/lib/runtime/componentNormalizer.js */ "../node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _JetFormEditorRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  _JetFormEditorRow_vue_vue_type_template_id_076e38b6__WEBPACK_IMPORTED_MODULE_0__.render,
  _JetFormEditorRow_vue_vue_type_template_id_076e38b6__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) // removed by dead control flow
{ var api; }
component.options.__file = "node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue"
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);

/***/ }),

/***/ "../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=script&lang=js":
/*!*************************************************************************************************!*\
  !*** ../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _vue_loader_lib_index_js_vue_loader_options_JetFormEditorRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../vue-loader/lib/index.js??vue-loader-options!./JetFormEditorRow.vue?vue&type=script&lang=js */ "../node_modules/vue-loader/lib/index.js??vue-loader-options!../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=script&lang=js");
 /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_vue_loader_lib_index_js_vue_loader_options_JetFormEditorRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=template&id=076e38b6":
/*!*******************************************************************************************************!*\
  !*** ../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=template&id=076e38b6 ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_vue_loader_lib_index_js_vue_loader_options_JetFormEditorRow_vue_vue_type_template_id_076e38b6__WEBPACK_IMPORTED_MODULE_0__.render),
/* harmony export */   staticRenderFns: () => (/* reexport safe */ _vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_vue_loader_lib_index_js_vue_loader_options_JetFormEditorRow_vue_vue_type_template_id_076e38b6__WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)
/* harmony export */ });
/* harmony import */ var _vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_vue_loader_lib_index_js_vue_loader_options_JetFormEditorRow_vue_vue_type_template_id_076e38b6__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../vue-loader/lib/index.js??vue-loader-options!./JetFormEditorRow.vue?vue&type=template&id=076e38b6 */ "../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../node_modules/vue-loader/lib/index.js??vue-loader-options!../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=template&id=076e38b6");


/***/ }),

/***/ "../node_modules/jfb-editor/src/fields/EditorData.js":
/*!***********************************************************!*\
  !*** ../node_modules/jfb-editor/src/fields/EditorData.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getBlockSource: () => (/* binding */ getBlockSource),
/* harmony export */   getCallbackForAttr: () => (/* binding */ getCallbackForAttr),
/* harmony export */   getFieldSource: () => (/* binding */ getFieldSource)
/* harmony export */ });
function getCallbackForAttr( source, objectKey, ifEmptyReturn = '' ) {
	let propertyObject = false;

	if ( objectKey in source ) {
		propertyObject = source[ objectKey ];
	}

	if ( ! propertyObject ) {
		return () => ifEmptyReturn;
	}

	return attr => {
		if ( attr ) {
			return ( propertyObject[ attr ] ? propertyObject[ attr ] : ifEmptyReturn );
		} else {
			return propertyObject;
		}
	};
}

function getBlockSource( block ) {
	const [ nameSpace, blockName ] = block.name.split( '/' );

	return getFieldSource( blockName );
}

function getFieldSource( fieldId ) {
	const source = window.JetFormBuilderFields[ fieldId ] || {};

	const props = [
		[ '__labels', 'label' ],
		[ '__help', 'help' ],
	];

	props.forEach( ( [ propName, callbackName, ifEmpty = '' ] ) => {
		source[ callbackName ] = getCallbackForAttr( source, propName, ifEmpty );
	} )

	return source;
}



/***/ }),

/***/ "../node_modules/jfb-editor/src/main.js":
/*!**********************************************!*\
  !*** ../node_modules/jfb-editor/src/main.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Actions: () => (/* binding */ Actions),
/* harmony export */   Blocks: () => (/* binding */ Blocks),
/* harmony export */   JetFormEditorRow: () => (/* reexport safe */ _engine_editor_JetFormEditorRow__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _actions_EditorData__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./actions/EditorData */ "../node_modules/jfb-editor/src/actions/EditorData.js");
/* harmony import */ var _engine_editor_JetFormEditorRow__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./engine-editor/JetFormEditorRow */ "../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue");
/* harmony import */ var _fields_EditorData__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./fields/EditorData */ "../node_modules/jfb-editor/src/fields/EditorData.js");





const Blocks = {
	getBlockSource: _fields_EditorData__WEBPACK_IMPORTED_MODULE_2__.getBlockSource,
	getFieldSource: _fields_EditorData__WEBPACK_IMPORTED_MODULE_2__.getFieldSource,
};

const Actions = {
	EditorData: _actions_EditorData__WEBPACK_IMPORTED_MODULE_0__["default"],
	getAction: _actions_EditorData__WEBPACK_IMPORTED_MODULE_0__.getAction,
	setAction: _actions_EditorData__WEBPACK_IMPORTED_MODULE_0__.setAction,
};



/***/ }),

/***/ "../node_modules/vue-loader/lib/index.js??vue-loader-options!../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************!*\
  !*** ../node_modules/vue-loader/lib/index.js??vue-loader-options!../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: 'jet-form-editor-row',
	props: {
		label: {
			type: String,
			default: ''
		},
		labelClass: {
			type: String,
			default: ''
		},
		helpClass: {
			type: String,
			default: ''
		},
		controlClass: {
			type: String,
			default: ''
		},
	},
	computed: {
		labelClassObject() {
			return this.getClass( 'defaultLabelClass', 'labelClass' )
		},
		helpClassObject() {
			return this.getClass( 'defaultHelpClass', 'helpClass' )
		},
		controlClassObject() {
			return this.getClass( 'defaultControlClass', 'controlClass' )
		}
	},
	data() {
		return {
			defaultLabelClass: 'jet-form-editor__row-label',
			defaultHelpClass: 'jet-form-editor__row-notice',
			defaultControlClass: 'jet-form-editor__row-control',
		}
	},
	methods: {
		getClass( defaultKey, propKey ) {
			return {
				[ `${ this[ defaultKey ] } ${ this[ propKey ] }` ]: this[ propKey ],
				[ this[ defaultKey ] ]: ! this[ propKey ]
			};
		}
	}
});


/***/ }),

/***/ "../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../node_modules/vue-loader/lib/index.js??vue-loader-options!../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=template&id=076e38b6":
/*!*************************************************************************************************************************************************************************************************************************************************!*\
  !*** ../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../node_modules/vue-loader/lib/index.js??vue-loader-options!../node_modules/jfb-editor/src/engine-editor/JetFormEditorRow.vue?vue&type=template&id=076e38b6 ***!
  \*************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render),
/* harmony export */   staticRenderFns: () => (/* binding */ staticRenderFns)
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c
  return _c("div", { staticClass: "jet-form-editor__row" }, [
    _c("div", { class: _vm.labelClassObject }, [
      _vm._v("\n\t\t" + _vm._s(_vm.label) + "\n\t\t"),
      this.$slots.helpLabel
        ? _c("div", { class: _vm.helpClassObject }, [_vm._t("helpLabel")], 2)
        : _vm._e(),
    ]),
    _vm._v(" "),
    _c(
      "div",
      { class: _vm.controlClassObject },
      [
        _vm._t("default"),
        _vm._v(" "),
        this.$slots.helpControl
          ? _c(
              "div",
              { class: _vm.helpClassObject },
              [_vm._t("helpControl")],
              2
            )
          : _vm._e(),
      ],
      2
    ),
    _vm._v(" "),
    this.$slots.helpSide
      ? _c(
          "div",
          { class: _vm.helpClassObject },
          [_vm._v("\n\t\t    "), _vm._t("helpSide")],
          2
        )
      : _vm._e(),
  ])
}
var staticRenderFns = []
render._withStripped = true



/***/ }),

/***/ "../node_modules/vue-loader/lib/runtime/componentNormalizer.js":
/*!*********************************************************************!*\
  !*** ../node_modules/vue-loader/lib/runtime/componentNormalizer.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ normalizeComponent)
/* harmony export */ });
/* globals __VUE_SSR_CONTEXT__ */

// IMPORTANT: Do NOT use ES2015 features in this file (except for modules).
// This module is a runtime utility for cleaner component module output and will
// be included in the final webpack user bundle.

function normalizeComponent(
  scriptExports,
  render,
  staticRenderFns,
  functionalTemplate,
  injectStyles,
  scopeId,
  moduleIdentifier /* server only */,
  shadowMode /* vue-cli only */
) {
  // Vue.extend constructor export interop
  var options =
    typeof scriptExports === 'function' ? scriptExports.options : scriptExports

  // render functions
  if (render) {
    options.render = render
    options.staticRenderFns = staticRenderFns
    options._compiled = true
  }

  // functional template
  if (functionalTemplate) {
    options.functional = true
  }

  // scopedId
  if (scopeId) {
    options._scopeId = 'data-v-' + scopeId
  }

  var hook
  if (moduleIdentifier) {
    // server build
    hook = function (context) {
      // 2.3 injection
      context =
        context || // cached call
        (this.$vnode && this.$vnode.ssrContext) || // stateful
        (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext) // functional
      // 2.2 with runInNewContext: true
      if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
        context = __VUE_SSR_CONTEXT__
      }
      // inject component styles
      if (injectStyles) {
        injectStyles.call(this, context)
      }
      // register component module identifier for async chunk inferrence
      if (context && context._registeredComponents) {
        context._registeredComponents.add(moduleIdentifier)
      }
    }
    // used by ssr in case component is cached and beforeCreate
    // never gets called
    options._ssrRegister = hook
  } else if (injectStyles) {
    hook = shadowMode
      ? function () {
          injectStyles.call(
            this,
            (options.functional ? this.parent : this).$root.$options.shadowRoot
          )
        }
      : injectStyles
  }

  if (hook) {
    if (options.functional) {
      // for template-only hot-reload because in that case the render fn doesn't
      // go through the normalizer
      options._injectStyles = hook
      // register for functional component in vue file
      var originalRender = options.render
      options.render = function renderWithStyleInjection(h, context) {
        hook.call(context)
        return originalRender(h, context)
      }
    } else {
      // inject component registration as beforeCreate hook
      var existing = options.beforeCreate
      options.beforeCreate = existing ? [].concat(existing, hook) : [hook]
    }
  }

  return {
    exports: scriptExports,
    options: options
  }
}


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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