<?php

namespace LWVendor\PhpOffice\PhpSpreadsheet\Style\ConditionalFormatting;

class ConditionalFormatValueObject
{
    /** @var mixed */
    private $type;
    /** @var mixed */
    private $value;
    /** @var mixed */
    private $cellFormula;
    /**
     * ConditionalFormatValueObject constructor.
     *
     * @param mixed $type
     * @param mixed $value
     * @param null|mixed $cellFormula
     */
    public function __construct($type, $value = null, $cellFormula = null)
    {
        $this->type = $type;
        $this->value = $value;
        $this->cellFormula = $cellFormula;
    }
    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * @param mixed $type
     */
    public function setType($type) : self
    {
        $this->type = $type;
        return $this;
    }
    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * @param mixed $value
     */
    public function setValue($value) : self
    {
        $this->value = $value;
        return $this;
    }
    /**
     * @return mixed
     */
    public function getCellFormula()
    {
        return $this->cellFormula;
    }
    /**
     * @param mixed $cellFormula
     */
    public function setCellFormula($cellFormula) : self
    {
        $this->cellFormula = $cellFormula;
        return $this;
    }
}
