<?php

/**
 * MainWP WP Rocket
 *
 * MainWP WP Rocket Extension handler.
 *
 * @link https://mainwp.com/extension/rocket/
 *
 * @package MainWP\Child
 *
 * Credits
 *
 * Plugin-Name: WP Rocket
 * Plugin URI: https://wp-rocket.me
 * Author:  WP Media
 * Author URI: https://wp-media.me
 * Licence: GPLv2 or later
 */

class MainWP_Rocket_Plugin { //phpcs:ignore -- NOSONAR - multi methods.

  // phpcs:disable WordPress.Security.NonceVerification, WordPress.Security.SafeRedirect

    private $option_handle  = 'mainwp_rocket_plugin_option';
    private $option         = array();
    private static $order   = '';
    private static $orderby = '';

    // Singleton
    private static $instance = null;

    public static function get_instance() {
        if ( null == self::$instance ) {
            self::$instance = new MainWP_Rocket_Plugin();
        }
        return self::$instance;
    }

    public function __construct() {
        $this->option = get_option( $this->option_handle );
    }

    public function admin_init() {
        do_action( 'mainwp_ajax_add_action', 'mainwp_rocket_active_plugin', array( $this, 'ajax_active_plugin' ) );
        do_action( 'mainwp_ajax_add_action', 'mainwp_rocket_upgrade_plugin', array( $this, 'ajax_upgrade_plugin' ) );
        do_action( 'mainwp_ajax_add_action', 'mainwp_wprocket_showhide_plugin', array( $this, 'ajax_showhide_plugin' ) );
    }

    public function get_option( $key = null, $default = '' ) {
        if ( isset( $this->option[ $key ] ) ) {
            return $this->option[ $key ];
        }
        return $default;
    }

    public function set_option( $key, $value ) {
        $this->option[ $key ] = $value;
        return update_option( $this->option_handle, $this->option );
    }

    public static function gen_dashboard_tab( $websites ) {
        $orderby = 'name';
        $_order  = 'desc';

        self::$order   = $_order;
        self::$orderby = $orderby;

        usort( $websites, array( 'MainWP_Rocket_Plugin', 'wprocket_data_sort' ) );
        ?>
    
    <table class="ui single line table" id="mainwp-rocket-sites-table" style="width:100%">
        <thead>
        <tr>
            <th scope="col" class="no-sort collapsing check-column" ><span class="ui checkbox"><input type="checkbox"></span></th>
            <th scope="col"><?php _e( 'Site', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col" class="no-sort collapsing"><i class="sign in icon"></i></th>
            <th scope="col"><?php _e( 'URL', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col"><?php _e( 'Version', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col" class="center aligned collapsing"><?php _e( 'Hidden', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col"><?php _e( 'Settings', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col" class="no-sort collapsing center aligned"></th>
        </tr>
        </thead>
        <tbody>
        <?php if ( is_array( $websites ) && count( $websites ) > 0 ) : ?>
            <?php self::get_plugin_dashboard_table_row( $websites ); ?>
        <?php else : ?>
            <tr>
            <td colspan="8"><?php _e( 'No websites were found with the WP Rocket plugin installed.', 'mainwp-rocket-extension' ); ?></td>
            </tr>
        <?php endif; ?>
        </tbody>
        <tfoot>
        <tr>
            <th class="check-column" scope="col"><span class="ui checkbox"><input type="checkbox"></span></th>
            <th scope="col"><?php _e( 'Site', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col"><i class="sign-in icon"></i></th>
            <th scope="col"><?php _e( 'URL', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col"><?php _e( 'Version', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col"><?php _e( 'Visibility', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col"><?php _e( 'Settings', 'mainwp-rocket-extension' ); ?></th>
            <th scope="col"></th>
        </tr>
        </tfoot>
    </table>
        <?php if ( is_array( $websites ) && count( $websites ) > 0 ) : ?>
    <script type="text/javascript">
        jQuery('#mainwp-rocket-sites-table').DataTable({
        "stateSave": true,
        "stateDuration": 0, // forever
        "scrollX": true,
        "colReorder": {
            fixedColumnsLeft: 1,
            fixedColumnsRight: 1
        },
        "lengthMenu": [
            [10, 25, 50, 100, -1],
            [10, 25, 50, 100, "All"]
        ],
        "columnDefs": [{
            "targets": 'no-sort',
            "orderable": false
        }],
        "order": [
            [1, "asc"]
        ],
        "drawCallback": function(settings) {
            jQuery('#mainwp-rocket-sites-table .ui.checkbox').checkbox();
            jQuery('#mainwp-rocket-sites-table .ui.dropdown').dropdown();
            if (typeof mainwp_datatable_fix_menu_overflow === 'function') {
            mainwp_datatable_fix_menu_overflow();
            };
        },
        });

        jQuery(document).ready(function($) {
        if (typeof mainwp_datatable_fix_menu_overflow === 'function') {
            mainwp_datatable_fix_menu_overflow();
        };
        });
    </script>
    <?php endif; ?>
        <?php
    }
    /**
     * Plugin dashboard get class active
     *
     * @param mixed $website website data.
     * @return string class string.
     */
    private static function plugin_dashboard_get_class_active( $website ) {
        return ! empty( $website['wprocket_active'] ) && $website['wprocket_active'] === 1 ? '' : 'error';
    }

    /**
     * Plugin dashboard get class update
     *
     * @param mixed  $website website data.
     * @param string $class_active class string.
     * @return string class update.
     */
    private static function plugin_dashboard_get_class_update( $website, $class_active ) {
        $class_update = ! empty( $website['wprocket_upgrade'] ) ? 'warning' : '';
        return $class_active == 'error' ? 'error' : $class_update;
    }

    /**
     * Plugin dashboard render dropdown menu
     *
     * @param mixed  $website
     * @param int    $website_id
     * @param string $location
     */
    private static function plugin_dashboard_render_dropdown_menu( $website, $website_id, $location ) {
        ?>
    <div class="ui left pointing dropdown" style="z-index:999">
        <a href="javascript:void(0)"><i class="ellipsis vertical icon"></i></a>
        <div class="menu">
            <?php if ( isset( $website['wprocket_active'] ) && empty( $website['wprocket_active'] ) ) : ?>
                <a class="item mwp_rocket_active_plugin" href="#"><?php _e( 'Activate Plugin', 'mainwp-rocket-extension' ); ?></a>
            <?php else : ?>
                <a class="item" href="#" onclick="mainwp_rocket_dashboard_tab_purge_all( <?php echo $website['id']; ?>, this ); return false;"><?php _e( 'Clear Cache', 'mainwp-rocket-extension' ); ?></a> <!-- NOSONAR - safe. -->
                <a class="item" href="admin.php?page=SiteOpen&newWindow=yes&websiteid=<?php echo intval( $website_id ); ?>&location=<?php echo base64_encode( $location ); ?>&_opennonce=<?php echo wp_create_nonce( 'mainwp-admin-nonce' ); ?>" target="_blank" rel="noopener noreferrer">
                    <?php _e( 'Open WP Rocket', 'mainwp-rocket-extension' ); ?>
                </a>
            <?php endif; ?>
            <div class="ui divider"></div>
            <a class="item" href="admin.php?page=managesites&dashboard=<?php echo intval( $website_id ); ?>">
                <?php _e( 'Overview', 'mainwp-rocket-extension' ); ?>
            </a>
            <a class="item" href="admin.php?page=managesites&id=<?php echo intval( $website_id ); ?>">
                <?php _e( 'Edit', 'mainwp-rocket-extension' ); ?>
            </a>
            <div class="ui divider"></div>
            <?php if ( 1 == $website['hide_plugin'] ) : ?>
                <a class="item mwp_rocket_showhide_plugin" href="#" showhide="show"><?php _e( 'Unhide Plugin', 'mainwp-rocket-extension' ); ?></a>
            <?php else : ?>
                <a class="item mwp_rocket_showhide_plugin" href="#" showhide="hide"><?php _e( 'Hide Plugin', 'mainwp-rocket-extension' ); ?></a>
            <?php endif; ?>
            <?php if ( isset( $website['wprocket_upgrade'] ) && ! empty( $website['wprocket_upgrade'] ) ) : ?>
                <a class="item mwp_rocket_upgrade_plugin" href="#"><?php _e( 'Update Plugin', 'mainwp-rocket-extension' ); ?></a>
            <?php endif; ?>
        </div>
    </div>
        <?php
    }
    /**
     * Plugin dashboard render table row
     *
     * @param mixed  $website website data.
     * @param int    $website_id website id.
     * @param string $website_name website name.
     * @param string $website_url website url.
     */
    private static function plugin_dashboard_render_table_row( $website, $website_id, $website_name, $website_url ) {
        $location = 'options-general.php?page=wprocket';
        ?>
    <td class="check-column"><span class="ui checkbox"><input type="checkbox" name="checked[]"></span></td>
    <td>
        <a href="admin.php?page=managesites&dashboard=<?php echo intval( $website_id ); ?>">
        <?php echo stripslashes( $website_name ); ?>
        </a>
        <span class="processing"></span>
    </td>
    <td>
        <a target="_blank" rel="noopener noreferrer" href="admin.php?page=SiteOpen&newWindow=yes&websiteid=<?php echo intval( $website_id ); ?>&_opennonce=<?php echo wp_create_nonce( 'mainwp-admin-nonce' ); ?>">
        <i class="sign in icon"></i>
        </a>
    </td>
    <td>
        <a href="<?php echo $website_url; ?>" target="_blank" rel="noopener noreferrer">
        <?php echo esc_html( $website_url ); ?>
        </a>
    </td>
    <td>
        <?php echo ( isset( $website['wprocket_upgrade'] ) && ! empty( $website['wprocket_upgrade'] ) ) ? '<i class="exclamation circle icon"></i>' : ''; ?>
        <?php echo ( isset( $website['wprocket_plugin_version'] ) ) ? $website['wprocket_plugin_version'] : 'N/A'; ?>
    </td>
    <td class="wp-rocket-visibility">
        <?php echo ( 1 == $website['hide_plugin'] ) ? __( 'Yes', 'mainwp-rocket-extension' ) : __( 'No', 'mainwp-rocket-extension' ); ?>
    </td>
    <td>
        <?php echo $website['isOverride'] ? __( 'Individual', 'mainwp-rocket-extension' ) : __( 'General', 'mainwp-rocket-extension' ); ?>
    </td>
    <td class="center aligned">
        <?php self::plugin_dashboard_render_dropdown_menu( $website, $website_id, $location ); ?>
    </td>
        <?php
    }

    /**
     * Plugin dashboard get version
     *
     * @param mixed $website
     */
    private static function plugin_dashboard_get_version( $website ) {
        $version = '';
        if ( isset( $website['wprocket_upgrade'] ) ) {
            $version = isset( $website['wprocket_upgrade']['new_version'] ) ? $website['wprocket_upgrade']['new_version'] : '';
        }
        return $version;
    }
    /**
     * Plugin dashboard get plugin slug
     *
     * @param mixed $website website data.
     * @return string slug of plugin.
     */
    private static function plugin_dashboard_get_plugin_slug( $website ) {
        $plugin_slug = esc_html( $website['plugin_slug'] );
        if ( ! empty( $website['wprocket_upgrade'] ) && ! empty( $website['wprocket_upgrade']['plugin'] ) ) {
            $plugin_slug = esc_html( $website['wprocket_upgrade']['plugin'] );
        }

        return $plugin_slug;
    }
    /**
     * Plugin dashboard table row.
     *
     * @param mixed $websites
     */
    public static function get_plugin_dashboard_table_row( $websites ) {

        $plugin_name = 'WP Rocket';

        foreach ( $websites as $website ) {
            $website_id   = intval( $website['id'] );
            $plugin_slug  = self::plugin_dashboard_get_plugin_slug( $website );
            $class_active = self::plugin_dashboard_get_class_active( $website );
            $class_update = self::plugin_dashboard_get_class_update( $website, $class_active );
            $version      = self::plugin_dashboard_get_version( $website );
            $url          = esc_url( $website['url'] );
            $name         = stripslashes( $website['name'] );

            ?>
        <tr class="<?php echo $class_active . ' ' . $class_update; ?>" website-id="<?php echo intval( $website_id ); ?>" plugin-name="<?php echo $plugin_name; ?>" plugin-slug="<?php echo $plugin_slug; ?>" version="<?php echo esc_html( $version ); ?>">
            <?php self::plugin_dashboard_render_table_row( $website, $website_id, $name, $url ); ?>
        </tr>
            <?php
        }
    }

    public static function wprocket_data_sort( $a, $b ) {
        if ( 'version' == self::$orderby ) {
            $a   = $a['wprocket_plugin_version'];
            $b   = $b['wprocket_plugin_version'];
            $cmp = version_compare( $a, $b );
        } elseif ( 'url' == self::$orderby ) {
            $a   = $a['url'];
            $b   = $b['url'];
            $cmp = strcmp( $a, $b );
        } elseif ( 'hidden' == self::$orderby ) {
            $a   = $a['hide_plugin'];
            $b   = $b['hide_plugin'];
            $cmp = $a - $b;
        } else {
            $a   = $a['name'];
            $b   = $b['name'];
            $cmp = strcmp( $a, $b );
        }
        if ( 0 == $cmp ) {
            return 0;
        }

        if ( 'desc' == self::$order ) {
            return ( $cmp > 0 ) ? -1 : 1;
        } else {
            return ( $cmp > 0 ) ? 1 : -1;
        }
    }
    private function get_websites_with_the_plugin_upgrade_info( $website ) {
        $plugin_upgrades = json_decode( $website->plugin_upgrades, true );

        if ( ! empty( $plugin_upgrades ) && is_array( $plugin_upgrades ) && isset( $plugin_upgrades[ MAINWP_ROCKET_FILE_PATH ] ) ) {
            $upgrade                  = $plugin_upgrades[ MAINWP_ROCKET_FILE_PATH ];
            $site['wprocket_upgrade'] = $upgrade['update'];
            return ! empty( $upgrade['update'] ) ? $upgrade['update'] : '';
        }
        return '';
    }

    private function get_websites_with_the_plugin_update_plugin_data( $site, $plugin_data_sites ) {
        $plugin_ds = isset( $plugin_data_sites[ $site['id'] ] ) ? $plugin_data_sites[ $site['id'] ] : array();
        if ( ! is_array( $plugin_ds ) ) {
            $plugin_ds = array();
        }

        if ( ! isset( $plugin_ds['is_active'] ) || $site['wprocket_active'] != $plugin_ds['is_active'] ) {
            // update active status
            $update = array(
                'site_id'   => $site['id'],
                'is_active' => $site['wprocket_active'],
            );
            MainWP_Rocket_DB::get_instance()->update_wprocket( $update );
        }

        $site['isOverride'] = isset( $plugin_ds['override'] ) ? $plugin_ds['override'] : 0;

        $others_data = isset( $plugin_ds['others'] ) ? $plugin_ds['others'] : array();
        if ( ! empty( $others_data ) && is_array( $others_data ) && ! empty( $others_data['rocket_boxes'] ) ) {
            $site['rocket_boxes'] = (array) $others_data['rocket_boxes'];
        }

        return $site;
    }

    /**
     * Get websites with the plugin process websites
     *
     * @param mixed $websites website data
     * @param array $plugin_hide Plugin hide
     * @param array $plugin_data_sites Plugin data sites
     * @return array websites wp rocket
     */
  private function get_websites_with_the_plugin_process_websites($websites, $plugin_hide, $plugin_data_sites) { //phpcs:ignore -- NOSONAR - multi methods.
        $websites_wprocket = array();
        foreach ( $websites as $website ) {
            if ( $website && $website->plugins != '' ) {
                $plugins = json_decode( $website->plugins, true );
                if ( is_array( $plugins ) && count( $plugins ) > 0 ) {
                    foreach ( $plugins as $plugin ) {
                        if ( MAINWP_ROCKET_FILE_PATH == strtolower( $plugin['slug'] ) ) {
                            $site                    = MainWP_Rocket_Utility::map_site( $website, array( 'id', 'name', 'url' ) );
                            $site['wprocket_active'] = ! empty( $plugin['active'] ) ? (int) $plugin['active'] : 0;
                            // get upgrade info
                            $site['wprocket_plugin_version'] = $plugin['version'];
                            $site['plugin_slug']             = $plugin['slug'];
                            $site['wprocket_upgrade']        = $this->get_websites_with_the_plugin_upgrade_info( $website );
                            $site['hide_plugin']             = ! empty( $plugin_hide[ $website->id ] ) ? $plugin_hide[ $website->id ] : 0;
                            $site                            = $this->get_websites_with_the_plugin_update_plugin_data( $site, $plugin_data_sites );
                            $site['version']                 = property_exists( $website, 'version' ) ? $website->version : '';
                            $websites_wprocket[]             = $site;
                            break;
                        }
                    }
                }
            }
            }
        return $websites_wprocket;
    }
    /**
     * Get websites with the plugin process group websites
     *
     * @param mixed $websites website data.
     * @param array $plugin_data_sites Plugin data site.
     * @param array $plugin_hide  Plugin hide.
     * @param int   $selected_group Selected group.
     * @return  array  websites wp rocket.
     */
  private function get_websites_with_the_plugin_process_group_websites( $websites, $plugin_data_sites, $plugin_hide, $selected_group ) { //phpcs:ignore -- NOSONAR - multi methods.
        global $mainWPRocketExtensionActivator; // phpcs:ignore -- global variable

        $group_websites = apply_filters(
            'mainwp_getdbsites',
            $mainWPRocketExtensionActivator->get_child_file(),
            $mainWPRocketExtensionActivator->get_child_key(),
            array(),
            array( $selected_group )
        );
        $sites          = array_map(
        function ( $site ) {
            return $site->id;
        },
            $group_websites
        );

        $websites_wprocket = array();

        foreach ( $websites as $website ) {
            if ( $website && $website->plugins != '' && in_array( $website->id, $sites ) ) {
                $plugins = wp_json_encode( $website->plugins, 1 );
                if ( ! empty( $plugins ) && is_array( $plugins ) ) {
                    foreach ( $plugins as $plugin ) {
                        if ( MAINWP_ROCKET_FILE_PATH == strtolower( $plugin['slug'] ) ) {
                            $site                            = MainWP_Rocket_Utility::map_site( $website, array( 'id', 'name', 'url' ) );
                            $site['wprocket_active']         = ! empty( $plugin['active'] ) ? (int) $plugin['active'] : 0;
                            $site['wprocket_plugin_version'] = $plugin['version'];

                            $site['wprocket_upgrade'] = $this->get_websites_with_the_plugin_upgrade_info( $website );
                            $site['hide_plugin']      = ! empty( $plugin_hide[ $website->id ] ) ? $plugin_hide[ $website->id ] : 0;

                            $site = $this->get_websites_with_the_plugin_update_plugin_data( $site, $plugin_data_sites );

                            $site['version']     = $website->version;
                            $websites_wprocket[] = $site;
                            break;
                        }
                    }
                }
            }
            }
        return $websites_wprocket;
    }

    /**
     * Get websites with the plugin filter websites by search
     *
     * @param array  $websites_wprocket
     * @param string $search_term
     */
    private function get_websites_with_the_plugin_filter_websites_by_search( $websites_wprocket, $search_term ) {
        return array_filter(
            $websites_wprocket,
            function ( $website ) use ( $search_term ) {
                return stripos( $website['name'], $search_term ) !== false || stripos( $website['url'], $search_term ) !== false;
            }
        );
    }
    /**
     * Get websites with the plugin
     *
     * @param mixed $websites
     * @param int   $selected_group
     * @param array $plugin_data_sites
     */
    public function get_websites_with_the_plugin( $websites, $selected_group = 0, $plugin_data_sites = array() ) {
        $websites_wprocket = array();
        $plugin_hide       = $this->get_option( 'hide_the_plugin' );
        $plugin_hide       = is_array( $plugin_hide ) ? $plugin_hide : array();

        if ( empty( $websites ) || ! is_array( $websites ) ) {
            return $websites_wprocket;
        }

        if ( empty( $selected_group ) ) {
            $websites_wprocket = $this->get_websites_with_the_plugin_process_websites( $websites, $plugin_hide, $plugin_data_sites );
        } else {
            $websites_wprocket = $this->get_websites_with_the_plugin_process_group_websites( $websites, $plugin_data_sites, $plugin_hide, $selected_group );
        }

        // if search action
        if ( ! empty( $_GET['s'] ) ) {
            $websites_wprocket = $this->get_websites_with_the_plugin_filter_websites_by_search( $websites_wprocket, trim( $_GET['s'] ) );
        }

        return $websites_wprocket;
    }


    public static function render_mainwp_rocket_bulk_actions() {
        ?>
        <div class="mainwp-actions-bar">
            <div class="ui grid">
            <div class="ui two column row">
                <div class="column">
                <select class="ui mini dropdown" id="mwp_rocket_plugin_action">
                    <option value="none"><?php _e( 'Bulk Actions', 'mainwp-rocket-extension' ); ?></option>
                    <option value="activate-selected"><?php _e( 'Activate Plugin', 'mainwp-rocket-extension' ); ?></option>
                    <option value="update-selected"><?php _e( 'Update Plugin', 'mainwp-rocket-extension' ); ?></option>
                    <option value="hide-selected"><?php _e( 'Hide Plugin', 'mainwp-rocket-extension' ); ?></option>
                    <option value="show-selected"><?php _e( 'Unhide plugin', 'mainwp-rocket-extension' ); ?></option>
                </select>
                <input type="button" name="" id="wprocket_plugin_doaction_btn" class="ui mini basic button" value="<?php _e( 'Apply', 'mainwp-rocket-extension' ); ?>" />
                <?php do_action( 'mainwp_rocket_actions_bar_left' ); ?>
                </div>
                <div class="right aligned column">
                <?php do_action( 'mainwp_rocket_actions_bar_right' ); ?>
                </div>
            </div>
            </div>
        </div>
        <?php
    }


    public function ajax_active_plugin() {
        do_action( 'mainwp_secure_request', 'mainwp_rocket_active_plugin' );
        $_POST['websiteId'] = $_POST['wprocketRequestSiteID'];
        do_action( 'mainwp_activePlugin' );
        die();
    }

    public function ajax_upgrade_plugin() {
        do_action( 'mainwp_secure_request', 'mainwp_rocket_upgrade_plugin' );
        $_POST['websiteId'] = $_POST['wprocketRequestSiteID'];
        do_action( 'mainwp_upgradePluginTheme' );
        die();
    }

    public function ajax_showhide_plugin() {
        do_action( 'mainwp_secure_request', 'mainwp_wprocket_showhide_plugin' );
        $siteid   = isset( $_POST['wprocketRequestSiteID'] ) ? $_POST['wprocketRequestSiteID'] : null;
        $showhide = isset( $_POST['showhide'] ) ? $_POST['showhide'] : null;
        if ( null !== $siteid && null !== $showhide ) {
            global $mainWPRocketExtensionActivator;
            $post_data   = array(
                'mwp_action' => 'set_showhide',
                'showhide'   => $showhide,
            );
            $information = apply_filters( 'mainwp_fetchurlauthed', $mainWPRocketExtensionActivator->get_child_file(), $mainWPRocketExtensionActivator->get_child_key(), $siteid, 'wp_rocket', $post_data );

            if ( is_array( $information ) && isset( $information['result'] ) && 'SUCCESS' === $information['result'] ) {
                $hide_plugin = $this->get_option( 'hide_the_plugin' );
                if ( ! is_array( $hide_plugin ) ) {
                    $hide_plugin = array();
                }
                $hide_plugin[ $siteid ] = ( 'hide' === $showhide ) ? 1 : 0;
                $this->set_option( 'hide_the_plugin', $hide_plugin );
            }
            die( wp_json_encode( $information ) );
        }
        die();
    }
}
