window.mainwpRocketVars = window.mainwpRocketVars || {};
mainwpRocketVars.bulkTaskRunning = false;
mainwpRocketVars.bulkTotal = 0;
mainwpRocketVars.bulkFinished = 0;
mainwpRocketVars.bulkCurrentThreads = 0;
mainwpRocketVars.maxThreads = 3;

jQuery(document).ready(
    function ($) {
        
        $('.one-click-exclusions-list-header-arrow').on('click', function () {
            $(this).closest('.one-click-exclusions-list').toggleClass('open');
        });

        $(".one-click-exclusions-main-checkbox").change(
            function () {
                const val = $(this).val();
                const class_el = `.list-${val}-body`;

                // Check or uncheck all the checkboxes based on the main checkbox state
                $(`${class_el} input[type="checkbox"]`).prop("checked", $(this).is(":checked"));
            }
        );

        // When an individual checkbox One-click exclusions is toggled
        $('.one-click-exclusions-list-body input[type="checkbox"]').change(
            function () {
                // Get all the checkboxes inside the list
                const allCheckboxes = $(
                    '.one-click-exclusions-list-body input[type="checkbox"]'
                );

                // Check if all the checkboxes are checked
                const allChecked =
                    allCheckboxes.length === allCheckboxes.filter(":checked").length;

                // Update the state of the main checkbox
                $(".one-click-exclusions-main-checkbox").prop("checked", allChecked);
            }
        );

        // Tab : File Optimization ->  Delay JavaScript execution
        function updateMainCheckboxState() {
            let all_classes = [];
            $(".one-click-exclusions-list-body").each(function () {
                let class_string = $(this).attr("class");
                if (class_string) {
                    all_classes = all_classes.concat(class_string.split(" "));
                }
            });

            // Remove duplicate classes
            all_classes = [...new Set(all_classes)];

            all_classes.forEach(function (class_item) {
                const all_checkboxes = $(`.${class_item}.one-click-exclusions-list-body input[type="checkbox"]`);
                const checkbox_name = $(`.${class_item}.one-click-exclusions-list-body`).attr('data-name');
                const all_checked = all_checkboxes.length === all_checkboxes.filter(":checked").length;
                $(`#checkboxes-${checkbox_name}`).prop("checked", all_checked);
            });

        }

        // When an individual checkbox is toggled
        $('.one-click-exclusions-list-body input[type="checkbox"]').change(
            function () {
                updateMainCheckboxState();
            }
        );

        // Update the main checkbox state on page load
        updateMainCheckboxState();

        // Tab: File Optimization -> Optimize CSS delivery : Show Optimize Css Tabs
        jQuery(".tabular.menu.optimize-css-tabs .item").tab();

        // Trigger the Show/Hide plugin action
        $(".mwp_rocket_showhide_plugin").on(
            "click",
            function () {
                mainwp_rocket_plugin_showhide_start_specific($(this), false);
                return false;
            }
        );

        // Trigger the plugin activation action
        $(".mwp_rocket_active_plugin").on(
            "click",
            function () {
                mainwp_rocket_plugin_active_start_specific($(this), false);
                return false;
            }
        );

        // Trigger the update plugin action
        $(".mwp_rocket_upgrade_plugin").on(
            "click",
            function () {
                mainwp_rocket_plugin_upgrade_start_specific($(this), false);
                return false;
            }
        );

        // Check all checkboxes
        jQuery('#mainwp-rocket-sites-table th input[type="checkbox"]').change(
            function () {
                const checkboxes = jQuery("#mainwp-rocket-sites-table").find(":checkbox");
                if (jQuery(this).prop("checked")) {
                    checkboxes.prop("checked", true);
                } else {
                    checkboxes.prop("checked", false);
                }
            }
        );

        // Trigger the bulk actions
        $("#wprocket_plugin_doaction_btn").on(
            "click",
            function () {
                const bulk_act = $("#mwp_rocket_plugin_action").val();
                mainwp_rocket_plugin_do_bulk_action(bulk_act);
            }
        );

        $(".rocket_individual_settings_save_btn").on(
            "click",
            function () {
                const statusEl = jQuery(this).parents().find(".status");
                const data = mainwp_secure_data(
                    {
                        action: "mainwp_rocket_site_override_settings",
                        wprocketRequestSiteID: $(
                            "input[name=mainwp_rocket_current_site_id]"
                        ).val(),
                        override: $("#mainwp_rocket_override_general_settings").is(":checked")
                            ? 1
                            : 0,
                        _wprocketNonce: mainwp_rocket_loc.nonce,
                    }
                );
                statusEl
                    .html(
                        '<i class="notched circle loading icon"></i> Saving. Please wait...'
                    )
                    .fadeIn();
                jQuery.post(
                    ajaxurl,
                    data,
                    function (response) {
                        if (response) {
                            if (response.error) {
                                statusEl.html(response.error);
                            } else if (response.result == "SUCCESS") {
                                statusEl.html(
                                    '<i class="green check icon"></i> Saved successfully.'
                                );
                                setTimeout(
                                    function () {
                                        statusEl.fadeOut();
                                        window.location.reload();
                                    },
                                    1000
                                );
                            } else {
                                statusEl.html(
                                    '<i class="red times icon"></i> Saving failed. Please, try again.'
                                );
                            }
                        } else {
                            statusEl.html(
                                '<i class="red times icon"></i> Saving failed. Please, try again.'
                            );
                        }
                    },
                    "json"
                );

                return false;
            }
        );

        $("#mainwp-rocket-load-optimize-db-info").on(
            "click",
            function () {
                const statusEl = jQuery(this).parent().find(".status");
                const site_id = $("input[name=mainwp_rocket_current_site_id]").val();
                const data = mainwp_secure_data(
                    {
                        action: "mainwp_rocket_reload_optimize_info",
                        wprocketRequestSiteID: site_id,
                        _wprocketNonce: mainwp_rocket_loc.nonce,
                    }
                );
                statusEl.html('<i class="notched circle loading icon"></i>').fadeIn();
                jQuery(this).attr("disabled", true);
                let e = this;
                jQuery.post(
                    ajaxurl,
                    data,
                    function (response) {
                        jQuery(e).attr("disabled", false);
                        if (response) {
                            if (response.error) {
                                statusEl.html(response.error);
                            } else if (response.result == "SUCCESS") {
                                statusEl.html('<i class="green check icon"></i>');
                                if (response.optimize_info) {
                                    jQuery("span#opt-info-total_revisions")
                                        .show()
                                        .find(".count-info")
                                        .html(response.optimize_info.total_revisions);
                                    jQuery("span#opt-info-total_auto_draft")
                                        .show()
                                        .find(".count-info")
                                        .html(response.optimize_info.total_auto_draft);
                                    jQuery("span#opt-info-total_trashed_posts")
                                        .show()
                                        .find(".count-info")
                                        .html(response.optimize_info.total_trashed_posts);

                                    jQuery("span#opt-info-total_spam_comments")
                                        .show()
                                        .find(".count-info")
                                        .html(response.optimize_info.total_spam_comments);
                                    jQuery("span#opt-info-total_trashed_comments")
                                        .show()
                                        .find(".count-info")
                                        .html(response.optimize_info.total_trashed_comments);
                                    jQuery("span#opt-info-total_expired_transients")
                                        .show()
                                        .find(".count-info")
                                        .html(response.optimize_info.total_expired_transients);
                                    jQuery("span#opt-info-total_all_transients")
                                        .show()
                                        .find(".count-info")
                                        .html(response.optimize_info.total_all_transients);
                                    jQuery("span#opt-info-total_optimize_tables")
                                        .show()
                                        .find(".count-info")
                                        .html(response.optimize_info.total_optimize_tables);
                                }
                                setTimeout(
                                    function () {
                                        statusEl.fadeOut();
                                    },
                                    3000
                                );
                            } else {
                                statusEl.html('<i class="red times icon"></i>');
                            }
                        } else {
                            statusEl.html('<i class="red times icon"></i>');
                        }
                    },
                    "json"
                );

                return false;
            }
        );

        // Close modal and reload page.
        $("#mainwp-rocket-sync-data-modal .icon.reload.close").on(
            "click",
            function () {
                window.location.href =
                    "admin.php?page=Extensions-Mainwp-Rocket-Extension";
            }
        );

        // Manage Child options
        $('.mainwp-parent-field input[type="checkbox"]').change(
            function () {
                if (this.checked) {
                    $(this)
                        .closest(".mainwp-parent-field")
                        .next(".mainwp-child-field")
                        .fadeIn();
                } else {
                    $(this)
                        .closest(".mainwp-parent-field")
                        .next(".mainwp-child-field")
                        .fadeOut();
                }
            }
        );
        // Manage Child options
        $('.mainwp-parent2-field input[type="checkbox"]').change(
            function () {
                if (this.checked) {
                    $(this)
                        .closest(".mainwp-parent2-field")
                        .find(".mainwp-child2-field")
                        .fadeIn();
                } else {
                    $(this)
                        .closest(".mainwp-parent2-field")
                        .find(".mainwp-child2-field")
                        .fadeOut();
                }
            }
        );

        jQuery(document).on(
            "click",
            "#mainwp-rocket-cname-add",
            function () {
                const addnew = jQuery("#cdn-cnames-field-creator").html();
                jQuery("#mainwp-rocket-cname-add").before(addnew);
                return false;
            }
        );

        jQuery(document).on(
            "click",
            "#mainwp-rocket-cname-remove",
            function () {
                jQuery(this).closest(".cdn-cnames-field").remove();
                return false;
            }
        );
    }
);

/**
 * Clear cache on a single site
 */
const mainwp_rocket_dashboard_tab_purge_all = function (pSiteId, pObj) {
    const row = jQuery("tr[website-id=" + pSiteId + "]");

    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_preload_purge_cache_all",
            wprocketRequestSiteID: pSiteId,
            _wprocketNonce: mainwp_rocket_loc.nonce,
            where: "dashboard_tab",
        }
    );

    row.append(
        '<div class="ui active inverted dimmer"><div class="ui text loader">Clearing cache...</div></div>'
    );

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    row.find(".ui.text").html(response.error);
                    setTimeout(
                        function () {
                            window.location.reload();
                        },
                        2000
                    );
                } else if (response.message) {
                    row.find(".ui.text").html(response.message);
                    setTimeout(function () {
                        window.location.reload();
                    }, 2000);
                } else if (response.result == "SUCCESS") {
                    row.find(".ui.text").html(__("Cache cleared successfully."));
                    setTimeout(
                        function () {
                            row.find(".ui.dimmer").fadeOut();
                        },
                        2000
                    );
                } else {
                    row.find(".ui.text").html(__("Undefined error occurred."));
                    setTimeout(
                        function () {
                            window.location.reload();
                        },
                        2000
                    );
                }
            } else {
                row.find(".ui.text").html(__("Undefined error occurred."));
                setTimeout(
                    function () {
                        window.location.reload();
                    },
                    2000
                );
            }
        },
        "json"
    );
};

let rocket_bulkMaxThreads = 3;
let rocket_bulkTotalThreads = 0;
let rocket_bulkCurrentThreads = 0;
let rocket_bulkFinishedThreads = 0;

const mainwp_rocket_plugin_do_bulk_action = function (act) {
    let selector = "";
    switch (act) {
        case "activate-selected":
            selector = "tbody tr.error";
            jQuery(selector).addClass("queue");
            mainwp_rocket_plugin_active_start_next(selector);
            break;
        case "update-selected":
            selector = "tbody tr.warning";
            jQuery(selector).addClass("queue");
            mainwp_rocket_plugin_upgrade_start_next(selector);
            break;
        case "hide-selected":
            selector = 'tbody tr .mwp_rocket_showhide_plugin[showhide="hide"]';
            jQuery(selector).addClass("queue");
            mainwp_rocket_plugin_showhide_start_next(selector);
            break;
        case "show-selected":
            selector = 'tbody tr .mwp_rocket_showhide_plugin[showhide="show"]';
            jQuery(selector).addClass("queue");
            mainwp_rocket_plugin_showhide_start_next(selector);
            break;
        case "load-settings":
            selector = "tbody tr";
            jQuery(selector).addClass("queue");
            mainwp_rocket_load_settings_start_next(selector);
            break;
    }
};

// Loop through sites to load settings
const mainwp_rocket_load_settings_start_next = function (selector) {
    let objProcess = jQuery(selector + ".queue:first");
    while (
        objProcess.length > 0 &&
        rocket_bulkCurrentThreads < rocket_bulkMaxThreads
    ) {
        objProcess.removeClass("queue");
        if (
            objProcess.closest("tr").find('td input[type="checkbox"]:checked')
                .length == 0
        ) {
            continue;
        }
        rocket_bulkCurrentThreads++;
        mainwp_rocket_load_settings_start_specific(objProcess, selector);
    }
};

// Load settings from child site
const mainwp_rocket_load_settings_start_specific = function (pObj, selector) {
    const row = pObj.closest("tr");
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_site_load_existing_settings",
            wprocketRequestSiteID: row.attr("website-id"),
            _wprocketNonce: mainwp_rocket_loc.nonce,
        }
    );

    const status = row.find("span.processing");
    status
        .html(
            '<i class="ui active inline loader tiny"></i>&nbsp;Updating the plugin...'
        )
        .show();

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response?.error) {
                status.html(response.error);
            } else if (response && response.result == "SUCCESS") {
                status.html(__("Plugin updated successfully."));
            } else {
                status.html(__("Undefined error occurred."));
            }

            if (jQuery(selector + ".queue:first").length == 0) {
                setTimeout(
                    function () {
                        window.location.href =
                            "admin.php?page=Extensions-Mainwp-Rocket-Extension";
                    },
                    2000
                );
            }
            // Update thread counts and process the next item
            rocket_bulkCurrentThreads--;
            rocket_bulkFinishedThreads++;

            mainwp_rocket_load_settings_start_next(selector);
        },
        "json"
    );

    return false;
};

// Loop through sites to Show/Hide the plugin
const mainwp_rocket_plugin_showhide_start_next = function (selector) {
    let objProcess = jQuery(selector + ".queue:first");
    while (
        objProcess.length > 0 &&
        rocket_bulkCurrentThreads < 1
    ) {
        objProcess.removeClass("queue");
        if (
            objProcess.closest("tr").find('td input[type="checkbox"]:checked')
                .length == 0
        ) {
            continue;
        }
        rocket_bulkCurrentThreads++;
        mainwp_rocket_plugin_showhide_start_specific(objProcess, true, selector);
    }
};

// Show/Hide the plugin
const mainwp_rocket_plugin_showhide_start_specific = function (pObj, bulk, selector) {
    const parent = pObj.closest("tr");
    const showhide = pObj.attr("showhide");
    const statusEl = parent.find(".wp-rocket-visibility");
    const data = mainwp_secure_data(
        {
            action: "mainwp_wprocket_showhide_plugin",
            wprocketRequestSiteID: parent.attr("website-id"),
            showhide: showhide,
        }
    );

    statusEl.html('<i class="notched circle loading icon"></i>');

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            pObj.removeClass("queue");
            if (response?.error) {
                statusEl.html('<i class="red times icon"></i>');
            } else if (response?.result && response.result == "SUCCESS") {
                if (showhide == "show") {
                    pObj.text("Hide plugin");
                    pObj.attr("showhide", "hide");
                    statusEl.html(__("No"));
                } else {
                    pObj.text("Unhide plugin");
                    pObj.attr("showhide", "show");
                    statusEl.html(__("Yes"));
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }
            // Update thread counts and process the next item
            if (bulk) {
                rocket_bulkCurrentThreads--;
                rocket_bulkFinishedThreads++;
                mainwp_rocket_plugin_showhide_start_next(selector);
            }
        },
        "json"
    );
    return false;
};

// Loop through sites to update the plugin
const mainwp_rocket_plugin_upgrade_start_next = function (selector) {
    let objProcess = jQuery(selector + ".queue:first");
    while (
        objProcess.length > 0 &&
        rocket_bulkCurrentThreads < rocket_bulkMaxThreads
    ) {
        objProcess.removeClass("queue");
        if (
            objProcess.closest("tr").find('td input[type="checkbox"]:checked')
                .length == 0
        ) {
            continue;
        }
        rocket_bulkCurrentThreads++;
        mainwp_rocket_plugin_upgrade_start_specific(objProcess, true, selector);
    }
};

// Update the plugin
const mainwp_rocket_plugin_upgrade_start_specific = function (pObj, bulk, selector) {
    const row = pObj.closest("tr");
    const slug = row.attr("plugin-slug");
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_upgrade_plugin",
            wprocketRequestSiteID: row.attr("website-id"),
            type: "plugin",
            "slugs[]": slug,
        }
    );

    row.append(
        '<div class="ui active inverted dimmer"><div class="ui text loader">Updating the plugin...</div></div>'
    );

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response?.error) {
                row.find(".ui.text").html(response["error"]);
            } else if (response?.upgrades?.[slug]) {
                row.find(".ui.text").html(__("Plugin updated successfully."));
                row.removeClass("warning");
                setTimeout(function () {
                    row.find(".ui.dimmer").fadeOut();
                }, 2000);
            } else {
                row.find(".ui.text").html(__("Undefined error occurred."));
            }

            if (bulk) {
                if (jQuery(selector + ".queue:first").length == 0) {
                    setTimeout(
                        function () {
                            window.location.href =
                                "admin.php?page=Extensions-Mainwp-Rocket-Extension";
                        },
                        2000
                    );
                }
                rocket_bulkCurrentThreads--;
                rocket_bulkFinishedThreads++;
                mainwp_rocket_plugin_upgrade_start_next(selector);
            }
        },
        "json"
    );
    return false;
};

// Loop through sites to activate the plugin
const mainwp_rocket_plugin_active_start_next = function (selector) {
    let objProcess = jQuery(selector + ".queue:first");
    while (
        objProcess.length > 0 &&
        objProcess.closest("tr").find('td input[type="checkbox"]:checked').length >
        0 &&
        rocket_bulkCurrentThreads < rocket_bulkMaxThreads
    ) {
        objProcess.removeClass("queue");
        if (
            objProcess.closest("tr").find('td input[type="checkbox"]:checked')
                .length == 0
        ) {
            continue;
        }

        rocket_bulkCurrentThreads++;
        mainwp_rocket_plugin_active_start_specific(objProcess, true, selector);
    }
};

// Activate the plugin
const mainwp_rocket_plugin_active_start_specific = function (pObj, bulk, selector) {
    const row = pObj.closest("tr");
    const slug = row.attr("plugin-slug");
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_active_plugin",
            wprocketRequestSiteID: row.attr("website-id"),
            "plugins[]": [slug],
        }
    );
    row.append(
        '<div class="ui active inverted dimmer"><div class="ui text loader">Activating the plugin...</div></div>'
    );

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            pObj.removeClass("queue");
            // NOSONAR
            if (response?.error) {
                row.find(".ui.text").html(response?.error);
                setTimeout(function () {
                    window.location.reload();
                }, 2000);
            } else if (response.result) {
                row.find(".ui.text").html(__("Plugin activated successfully."));
                row.removeClass("error");
                setTimeout(function () {
                    row.find(".ui.dimmer").fadeOut();
                }, 2000);
            }
            if (bulk) {
                rocket_bulkCurrentThreads--;
                rocket_bulkFinishedThreads++;
                mainwp_rocket_plugin_active_start_next(selector);
            }
        },
        "json"
    );
    return false;
};

const mainwp_rocket_individual_perform_action = function (pSiteId, action) {
    if (action == "save_opts_child_sites") {
        mainwp_rocket_individual_save_opts_to_site(pSiteId);
    } else if (action == "show_save_opts_child_sites") {
        mainwp_rocket_individual_save_opts_to_site(pSiteId);
    } else if (action == "optimize_database") {
        mainwp_rocket_individual_optimize_database_on_site(pSiteId);
    } else if (action == "update_exclusion_list") {
        mainwp_rocket_individual_update_exclusion_list_on_site(pSiteId);
    }
};

const mainwp_rocket_individual_save_opts_to_site = function (pSiteId) {
    let messageEl = jQuery("#mainwp-rocket-message-zone");
    messageEl.removeClass('red', 'green', 'info');
    messageEl
        .html(
            '<i class="notched circle loading icon"></i> ' +
            __("Saving settings to child site ...")
        )
        .show();
    const optimize_db = Boolean(
        jQuery('input[name="rocket_do_optimize_db"]').val()
    );

    const data = mainwp_secure_data({
        action: "mainwp_rocket_save_opts_to_child_site",
        wprocketRequestSiteID: pSiteId,
        _wprocketNonce: mainwp_rocket_loc.nonce,
        individual: 1,
        optimize_db: optimize_db,
    });
    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    messageEl.addClass('red');
                    messageEl.html(response.error);
                } else if (response.message) {
                    messageEl.addClass('info');
                    messageEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    messageEl.addClass('green');
                    messageEl.html(__("Settings saved to child sites successfully!"));
                } else {
                    messageEl.addClass('red');
                    messageEl.html(__("Undefined error occured. Please try again."));
                }
            } else {
                messageEl.addClass('red');
                messageEl.html(__("Undefined error occured. Please try again."));
            }
        },
        "json"
    );
};

const mainwp_rocket_individual_update_exclusion_list_on_site = function (pSiteId) {
    let messageEl = jQuery("#mainwp-rocket-message-zone");
    messageEl.removeClass('red', 'green', 'info');
    messageEl
        .html(
            '<i class="notched circle loading icon"></i> ' +
            __("Updating inclusion and exclusion lists...")
        )
        .show();

    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_update_exclusion_list_child_site",
            wprocketRequestSiteID: pSiteId,
            _wprocketNonce: mainwp_rocket_loc.nonce,
            individual: 1,
        }
    );
    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    messageEl.addClass('red');
                    messageEl.html(response.error);
                } else if (response.message) {
                    messageEl.addClass('info');
                    messageEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    messageEl.addClass('green');
                    messageEl.html(__("Lists updated successfully!"));
                } else {
                    messageEl.addClass('red');
                    messageEl.html(__("Undefined error occured. Please try again."));
                }
            } else {
                messageEl.addClass('red');
                messageEl.html(__("Undefined error occured. Please try again."));
            }
        },
        "json"
    );
};

const mainwp_rocket_individual_optimize_database_on_site = function (pSiteId) {
    let messageEl = jQuery("#mainwp-rocket-message-zone");
    messageEl.removeClass('red', 'green', 'info');
    messageEl.html('<i class="notched circle loading icon"></i> ' + __("Optimizing Database on child site...")).show();

    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_optimize_data_on_child_site",
            wprocketRequestSiteID: pSiteId,
            _wprocketNonce: mainwp_rocket_loc.nonce,
            individual: 1,
        }
    );
    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    messageEl.addClass('red');
                    messageEl.html(response.error);
                } else if (response.message) {
                    messageEl.addClass('info');
                    messageEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    messageEl.addClass('green');
                    messageEl.html(__("Optimizations completed successfully!"));
                } else {
                    messageEl.addClass('red');
                    messageEl.html(__("Undefined error occured. Please try again."));
                }
            } else {
                messageEl.addClass('red');
                messageEl.html(__("Undefined error occured. Please try again."));
            }
        },
        "json"
    );
};

// not used?
const mainwp_rocket_individual_purge_cloudflare = function (pSiteId) {
    let messageEl = jQuery("#mainwp-rocket-message-zone");
    messageEl.removeClass('red', 'green', 'info');
    messageEl
        .html(
            '<i class="notched circle loading icon"></i> ' +
            __("Purging Cloudflre cache...")
        )
        .show();
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_purge_cloudflare",
            wprocketRequestSiteID: pSiteId,
            _wprocketNonce: mainwp_rocket_loc.nonce,
            individual: 1,
        }
    );

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    messageEl.addClass('red');
                    messageEl.html(response.error);
                } else if (response.message) {
                    messageEl.addClass('info');
                    messageEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    messageEl.addClass('green');
                    messageEl.html(__("Cloudflare cachec purged successfully!"));
                } else {
                    messageEl.addClass('red');
                    messageEl.html(__("Undefined error occured. Please try again."));
                }
            } else {
                messageEl.addClass('red');
                messageEl.html(__("Undefined error occured. Please try again."));
            }
        },
        "json"
    );
};

const mainwp_rocket_individual_purge_all = function (pSiteId, pObj) {
    let statusEl = jQuery(pObj).parent().find(".status");
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_preload_purge_cache_all",
            wprocketRequestSiteID: pSiteId,
            _wprocketNonce: mainwp_rocket_loc.nonce,
            individual: 1,
        }
    );
    statusEl.html('<i class="notched circle loading icon"></i>').fadeIn();
    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                    setTimeout(
                        function () {
                            statusEl.fadeOut();
                        },
                        3000
                    );
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }
        },
        "json"
    );
};

const mainwp_rocket_individual_generate_critical_css = function (pSiteId, pObj) {
    let statusEl = jQuery(pObj).parent().find(".status");
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_generate_critical_css",
            wprocketRequestSiteID: pSiteId,
            _wprocketNonce: mainwp_rocket_loc.nonce,
            individual: 1,
        }
    );

    statusEl.html('<i class="notched circle loading icon"></i>').fadeIn();
    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                    setTimeout(
                        function () {
                            statusEl.fadeOut();
                        },
                        3000
                    );
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }
        },
        "json"
    );
};

/**
 * Execute actions
 */
const mainwp_rocket_perform_action_start_next = function (action) {
    let objProcess = jQuery(".processing-item[status=queue]:first");
    while (
        objProcess.length > 0 &&
        rocket_bulkCurrentThreads < rocket_bulkMaxThreads // NOSONAR
    ) {
        objProcess.attr("status", "processed");
        if (action == "purge_cloudflare") {
            mainwp_rocket_purge_cloudflare_start_specific(objProcess);
        } else if (action == "preload_purge_cache_all") {
            mainwp_rocket_preload_purge_cache_all_start_specific(objProcess, false);
        } else if (action == "generate_critical_css") {
            mainwp_rocket_generate_critical_css_start_specific(objProcess, false);
        } else if (action == "save_opts_child_sites") {
            mainwp_rocket_save_opts_child_sites_start_specific(objProcess);
        } else if (action == "optimize_database") {
            mainwp_rocket_optimize_child_sites_start_specific(objProcess);
        } else if (action == "update_exclusion_list") {
            mainwp_rocket_update_exclusion_list_child_sites_start_specific(
                objProcess
            );
        } else if (action == "clear_priority_elements") {
            mainwp_rocket_clear_priority_elements_start_specific(objProcess, false);
        }
    }
    if (
        rocket_bulkFinishedThreads > 0 &&
        rocket_bulkFinishedThreads == rocket_bulkTotalThreads
    ) {
        let msg = __("Performed action completed. ");
        jQuery("#mainwp_rocket_settings #mainwp-rocket-sync-data-modal").append('<div class="ui info message">' + msg + '</div>');
    }
};

// Loop through sites to clear all cache
const mainwp_rocket_rightnow_perform_action_start_next = function (action) {
    let objProcess = jQuery(
        "#mainwp-rocket-overview-page-clear-cache-modal .processing-item[status=queue]:first"
    );
    while (
        objProcess.length > 0 &&
        rocket_bulkCurrentThreads < rocket_bulkMaxThreads // NOSONAR
    ) {
        objProcess.attr("status", "processed");
        if (action == "preload_purge_cache_all") {
            mainwp_rocket_preload_purge_cache_all_start_specific(objProcess, true);
        } else if (action == "generate_critical_css") {
            mainwp_rocket_generate_critical_css_start_specific(objProcess, true);
        }
    }

    if (rocket_bulkCurrentThreads == 0) {
        setTimeout(
            function () {
                jQuery("#mainwp-rocket-overview-page-clear-cache-modal").modal("hide");
            },
            3000
        );
    }

};

// Clear CloudFlare cache
const mainwp_rocket_purge_cloudflare_start_specific = function (objProcess) {
    let statusEl = objProcess.find(".status");
    rocket_bulkCurrentThreads++;
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_purge_cloudflare",
            _wprocketNonce: mainwp_rocket_loc.nonce,
            wprocketRequestSiteID: objProcess.attr("site-id"),
            individual: 0,
        }
    );

    statusEl.html('<i class="notched circle loading icon"></i>');

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }

            rocket_bulkCurrentThreads--;
            rocket_bulkFinishedThreads++;

            mainwp_rocket_perform_action_start_next("purge_cloudflare");
        },
        "json"
    );
};

/**
 * Clear all Cache and preload.
 */
const mainwp_rocket_preload_purge_cache_all_start_specific = function (
    objProcess,
    rightNow
) {
    let statusEl = objProcess.find(".status");
    rocket_bulkCurrentThreads++;
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_preload_purge_cache_all",
            _wprocketNonce: mainwp_rocket_loc.nonce,
            wprocketRequestSiteID: objProcess.attr("site-id"),
        }
    );

    if (!rightNow) {
        data["individual"] = 0;
    }

    statusEl.html('<i class="notched circle loading icon"></i>');

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }

            rocket_bulkCurrentThreads--;
            rocket_bulkFinishedThreads++;

            if (!rightNow) {
                mainwp_rocket_perform_action_start_next("preload_purge_cache_all");
            } else {
                mainwp_rocket_rightnow_perform_action_start_next(
                    "preload_purge_cache_all"
                );
            }
        },
        "json"
    );
};

/**
 * Clear Priority Elements
 * @param any objProcess 
 * @param any rightNow 
 */
const mainwp_rocket_clear_priority_elements_start_specific = function (objProcess, rightNow) {
    const statusEl = objProcess.find(".status");
    rocket_bulkCurrentThreads++;
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_clear_priority_elements",
            _wprocketNonce: mainwp_rocket_loc.nonce,
            wprocketRequestSiteID: objProcess.attr("site-id"),
        }
    );

    if (!rightNow) {
        data["individual"] = 0;
    }
    statusEl.html('<i class="notched circle loading icon"></i>');
    jQuery.post(ajaxurl, data, function (response) {
        if (response) {
            if (response.error) {
                statusEl.html(response.error);
            } else if (response.message) {
                statusEl.html(response.message);
            } else if (response.result == "SUCCESS") {
                statusEl.html('<i class="green check icon"></i>');
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }
        } else {
            statusEl.html('<i class="red times icon"></i>');
        }
        rocket_bulkCurrentThreads--;
        rocket_bulkFinishedThreads++;

        if (!rightNow) {
            mainwp_rocket_perform_action_start_next("clear_priority_elements");
        } else {
            mainwp_rocket_rightnow_perform_action_start_next("clear_priority_elements");
        }
    },
        "json"
    );
}

const mainwp_rocket_individual_clear_priority_elements = function (pSiteId, pObj) {
    let statusEl = jQuery(pObj).parent().find(".status");
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_clear_priority_elements",
            wprocketRequestSiteID: pSiteId,
            _wprocketNonce: mainwp_rocket_loc.nonce,
            individual: 1,
        }
    );
    statusEl.html('<i class="notched circle loading icon"></i>').fadeIn();
    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                    setTimeout(
                        function () {
                            statusEl.fadeOut();
                        },
                        3000
                    );
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }
        },
        "json"
    );
};


const mainwp_rocket_generate_critical_css_start_specific = function (
    objProcess,
    rightNow
) {
    let statusEl = objProcess.find(".status");
    rocket_bulkCurrentThreads++;
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_generate_critical_css",
            _wprocketNonce: mainwp_rocket_loc.nonce,
            wprocketRequestSiteID: objProcess.attr("site-id"),
        }
    );
    if (!rightNow) {
        data["individual"] = 0;
    }

    statusEl.html('<i class="notched circle loading icon"></i>');
    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }
            rocket_bulkCurrentThreads--;
            rocket_bulkFinishedThreads++;

            if (!rightNow) {
                mainwp_rocket_perform_action_start_next("generate_critical_css");
            } else {
                mainwp_rocket_rightnow_perform_action_start_next(
                    "generate_critical_css"
                );
            }
        },
        "json"
    );
};

// Save settings to child sites
const mainwp_rocket_save_opts_child_sites_start_specific = function (
    objProcess
) {
    let statusEl = objProcess.find(".status");
    rocket_bulkCurrentThreads++;
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_save_opts_to_child_site",
            _wprocketNonce: mainwp_rocket_loc.nonce,
            wprocketRequestSiteID: objProcess.attr("site-id"),
            individual: 0,
        }
    );

    statusEl.html('<i class="notched circle loading icon"></i>');

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }

            rocket_bulkCurrentThreads--;
            rocket_bulkFinishedThreads++;

            mainwp_rocket_perform_action_start_next("save_opts_child_sites");
        },
        "json"
    );
};
// Update exclusion list
const mainwp_rocket_update_exclusion_list_child_sites_start_specific = function (
    objProcess
) {
    let statusEl = objProcess.find(".status");
    rocket_bulkCurrentThreads++;
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_update_exclusion_list_child_site",
            _wprocketNonce: mainwp_rocket_loc.nonce,
            wprocketRequestSiteID: objProcess.attr("site-id"),
            individual: 0,
        }
    );

    statusEl.html('<i class="notched circle loading icon"></i>');

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }
            rocket_bulkCurrentThreads--;
            rocket_bulkFinishedThreads++;
            mainwp_rocket_perform_action_start_next("optimize_database");
        },
        "json"
    );
};

// Optimize database
const mainwp_rocket_optimize_child_sites_start_specific = function (objProcess) {
    let statusEl = objProcess.find(".status");
    rocket_bulkCurrentThreads++;
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_optimize_data_on_child_site",
            _wprocketNonce: mainwp_rocket_loc.nonce,
            wprocketRequestSiteID: objProcess.attr("site-id"),
            individual: 0,
        }
    );

    statusEl.html('<i class="notched circle loading icon"></i>');

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    statusEl.html(response.error);
                } else if (response.message) {
                    statusEl.html(response.message);
                } else if (response.result == "SUCCESS") {
                    statusEl.html('<i class="green check icon"></i>');
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
            } else {
                statusEl.html('<i class="red times icon"></i>');
            }
            rocket_bulkCurrentThreads--;
            rocket_bulkFinishedThreads++;
            mainwp_rocket_perform_action_start_next("optimize_database");
        },
        "json"
    );
};

// Clear modal on the Individual Overview page
const mainwp_rocket_rightnow_clearcache_individual = function (siteId) {
    jQuery("#mainwp-rocket-overview-page-clear-cache-modal").modal("show");
    jQuery("#mainwp-rocket-overview-page-clear-cache-modal .content").html(
        '<div class="ui active inverted dimmer"><div class="ui text loader"></div></div>'
    );

    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_preload_purge_cache_all",
            wprocketRequestSiteID: siteId,
            _wprocketNonce: mainwp_rocket_loc.nonce,
        }
    );

    jQuery.post(
        ajaxurl,
        data,
        function (response) {
            if (response) {
                if (response.error) {
                    jQuery(
                        "#mainwp-rocket-overview-page-clear-cache-modal .content"
                    ).html('<div class="ui red message">' + response.error + "</div>");
                } else if (response.message) {
                    jQuery(
                        "#mainwp-rocket-overview-page-clear-cache-modal .content"
                    ).html(
                        '<div class="ui yellow message">' + response.message + "</div>"
                    );
                } else if (response.result == "SUCCESS") {
                    jQuery(
                        "#mainwp-rocket-overview-page-clear-cache-modal .content"
                    ).html(
                        '<div class="ui green message">' +
                        __("Process completed successfully!") +
                        "</div>"
                    );
                    setTimeout(
                        function () {
                            jQuery("#mainwp-rocket-overview-page-clear-cache-modal").modal(
                                "hide"
                            );
                        },
                        3000
                    );
                } else {
                    jQuery(
                        "#mainwp-rocket-overview-page-clear-cache-modal .content"
                    ).html(
                        '<div class="ui red message">' +
                        __("Undefined error occurred. Please try again.") +
                        "</div>"
                    );
                }
            } else {
                jQuery("#mainwp-rocket-overview-page-clear-cache-modal .content").html(
                    '<div class="ui red message">' +
                    __("Undefined error occurred. Please try again.") +
                    "</div>"
                );
            }
        },
        "json"
    );

    return false;
};

/**
 * Clear/Preload modal on the Overview page
 */
const mainwp_rocket_rightnow_loadsites = function (action) {
    let msg = "Clear and Preload";

    // confirm
    if (!confirm(`You are about to ${msg} WP Rocket cache on all your child sites. Do you want to proceed ? `)) {
        return Promise.resolve(false);
    }

    jQuery("#mainwp-rocket-overview-page-clear-cache-modal").modal("show");
    jQuery("#mainwp-rocket-overview-page-clear-cache-modal .content").html(
        '<div class="ui active inverted dimmer"><div class="ui text loader"></div></div>'
    );

    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_rightnow_load_sites",
            _wprocketNonce: mainwp_rocket_loc.nonce,
            rightnow_action: action,
        }
    );
    return new Promise((resolve, reject) => {
        jQuery
            .post(ajaxurl, data, function (response) {
                if (response) {
                    jQuery("#mainwp-rocket-overview-page-clear-cache-modal .content").html(
                        response
                    );
                    rocket_bulkCurrentThreads = 0;
                    rocket_bulkFinishedThreads = 0;
                    rocket_bulkTotalThreads = jQuery(
                        "#mainwp-rocket-overview-page-clear-cache-modal .processing-item[status=queue]"
                    ).length;
                    if (rocket_bulkTotalThreads > 0) {
                        rocket_bulkCurrentThreads++;
                        mainwp_rocket_rightnow_perform_action_start_next(action);
                        resolve(true);
                    }
                    resolve(true);
                } else {
                    jQuery("#mainwp-rocket-overview-page-clear-cache-modal .content").html(
                        '<div class="ui red message">' +
                        __("Undefined error occurred. Please try again.") +
                        "</div>"
                    );
                    resolve(false);
                }
            })
            .fail(function () {
                jQuery("#mainwp-rocket-overview-page-clear-cache-modal .content").html(
                    '<div class="ui red message">' +
                    __("Request failed. Please try again.") +
                    "</div>"
                );
                resolve(false);
            });
    });

};

jQuery(document).on(
    "click",
    "#mainwp-do-sites-bulk-actions",
    function () {
        const action = jQuery("#mainwp-sites-bulk-actions-menu").dropdown("get value");
        if (action == "") {
            return false;
        }

        if (action == "clear_wprocket_preload_cache") {
            if (mainwpRocketVars.bulkTaskRunning) {
                return false;
            }

            let msg =
                "You are about to clear WP Rocket Cache and preload on the selected sites?";

            if (!confirm(msg)) {
                return false;
            }

            managesites_bulk_init();

            mainwpRocketVars.bulkTotal = jQuery(
                '#mainwp-manage-sites-body-table .check-column INPUT:checkbox:checked[status="queue"]'
            ).length;
            mainwpRocketVars.bulkTaskRunning = true;

            if (action == "clear_wprocket_preload_cache") {
                mainwp_managesites_bulk_clear_rocket_cache_next();
            }
            return false;
        }
    }
);

/**
 *  Mainwp manage bulk rocket cache clearing.
 */
const mainwp_managesites_bulk_clear_rocket_cache_next = function () {
    let checkedBox = jQuery('#mainwp-manage-sites-body-table .check-column INPUT:checkbox:checked[status="queue"]:first');
    while (
        checkedBox.length > 0 &&
        mainwpRocketVars.bulkCurrentThreads < mainwpRocketVars.maxThreads
    ) {
        mainwp_managesites_bulk_clear_rocket_preload_cache_specific(checkedBox);
    }
    if (
        mainwpRocketVars.bulkTotal > 0 &&
        mainwpRocketVars.bulkFinished == mainwpRocketVars.bulkTotal
    ) {
        managesites_bulk_done();
        setHtml("#mainwp-message-zone", __("Bulk Clear WP Rocket Cache finished."));
    }
};

/**
 * Mainwp managesites bulk clear rocket preload cache specific.
 */
const mainwp_managesites_bulk_clear_rocket_preload_cache_specific = function (
    pCheckedBox
) {
    pCheckedBox.attr("status", "running");
    const rowObj = pCheckedBox.closest("tr");
    mainwpRocketVars.bulkCurrentThreads++;
    const loadingEl = rowObj.find(".column-site-bulk i");
    let statusEl = rowObj.find(".column-site-bulk .status");
    loadingEl.show();
    statusEl.hide();
    const data = mainwp_secure_data(
        {
            action: "mainwp_rocket_preload_purge_cache_all",
            wprocketRequestSiteID: rowObj.attr("siteid"),
            _wprocketNonce: mainwp_rocket_loc.nonce,
        }
    );

    jQuery.ajax(
        {
            type: "POST",
            url: ajaxurl,
            data: data,
            success: function (response) {
                mainwpRocketVars.bulkCurrentThreads--;
                mainwpRocketVars.bulkFinished++;
                loadingEl.hide();

                if (response) {
                    if (response.error) {
                        statusEl.html('<i class="red times icon"></i>');
                    } else if (response.message) {
                        statusEl.html('<i class="red times icon"></i>');
                    } else if (response.result == "SUCCESS") {
                        statusEl.html('<i class="green check icon"></i>');
                        setTimeout(
                            function () {
                                statusEl.fadeOut();
                            },
                            3000
                        );
                    } else {
                        statusEl.html('<i class="red times icon"></i>');
                    }
                } else {
                    statusEl.html('<i class="red times icon"></i>');
                }
                statusEl.show();
                // re call clear cache
                mainwp_managesites_bulk_clear_rocket_cache_next();
            },
            dataType: "json",
        }
    );
    return false;
};

const mainwp_rightnow_rocket_show_box = function (action) {
    let rocketBox = jQuery("#rightnow-rocket-box");
    let title =
        action == __("Clearing and Pre-loading  WP Rocket cache on child sites");
    rocketBox.attr("title", title);
    jQuery('div[aria-describedby="rightnow-rocket-box"]')
        .find(".ui-dialog-title")
        .html(title);

    rocketBox.dialog(
        {
            resizable: false,
            height: 350,
            width: 500,
            modal: true,
            close: function (event, ui) {
                jQuery("#rightnow-rocket-box").dialog("destroy");
            },
        }
    );
};
