<?php
/*
Plugin Name: MapSVG.Gallery
Plugin URI: http://codecanyon.net/item/mapsvg-interactive-vector-maps/2547255?ref=RomanCode
Description: MapSVG add-on: Slider, Gallery, Lightbox
Author: Roman S. Stepanov
Author URI: http://codecanyon.net/user/RomanCode
Version: 1.3.1
*/

if (!defined('ABSPATH')) exit; // Exit if accessed directly

define('MAPSVG_GAL_DEBUG', defined('MAPSVG_DEBUG') ?  MAPSVG_DEBUG : false);

define('MAPSVG_GAL_PLUGIN_URL', plugin_dir_url(__FILE__));
define('MAPSVG_GAL_PLUGIN_DIR', realpath(plugin_dir_path(__FILE__)));
$parts = parse_url(MAPSVG_GAL_PLUGIN_URL);
define('MAPSVG_GAL_PLUGIN_PATH', $parts['path']);
define('MAPSVG_GAL_VERSION', '1.3.1');
define('MAPSVG_GAL_ASSET_VERSION', MAPSVG_GAL_VERSION . (MAPSVG_GAL_DEBUG ? rand() : ''));

/**
 * Add JS & CSS
 */
function mapsvg_gal_add_jscss_common()
{
	if (MAPSVG_GAL_DEBUG) {
		wp_enqueue_script('photoswipe', MAPSVG_GAL_PLUGIN_URL . 'js/photoswipe.min.js', array('mapsvg'), MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_script('photoswipe-ui', MAPSVG_GAL_PLUGIN_URL . 'js/photoswipe-ui-default.min.js', array('photoswipe'), MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_style('mapsvg-gallery', MAPSVG_GAL_PLUGIN_URL . "css/mapsvg-gallery.css", null, MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_style('photoswipe', MAPSVG_GAL_PLUGIN_URL . "css/photoswipe.css", null, MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_style('photoswipe-skin', MAPSVG_GAL_PLUGIN_URL . "css/default-skin/default-skin.css", null, MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_script('mapsvg-gallery', MAPSVG_GAL_PLUGIN_URL . "js/mapsvg-gallery.js", null, MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_style('slick', MAPSVG_GAL_PLUGIN_URL . "css/slick.css", null, MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_style('slick-theme', MAPSVG_GAL_PLUGIN_URL . "css/slick-theme.css", null, MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_script('slick', MAPSVG_GAL_PLUGIN_URL . "js/slick.min.js", null, MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_style('justifiedGallery', MAPSVG_GAL_PLUGIN_URL . "css/justifiedGallery.min.css", null, MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_script('justifiedGallery', MAPSVG_GAL_PLUGIN_URL . "js/jquery.justifiedGallery.min.js", null, MAPSVG_GAL_ASSET_VERSION);
	} else {
		wp_enqueue_script('mapsvg-gallery-front', MAPSVG_GAL_PLUGIN_URL . 'dist/mapsvg-gallery-front.min.js', array('mapsvg'), MAPSVG_GAL_ASSET_VERSION);
		wp_enqueue_style('mapsvg-gallery-full', MAPSVG_GAL_PLUGIN_URL . 'dist/mapsvg-gallery-full.min.css', null, MAPSVG_GAL_ASSET_VERSION);
	}
}
function mapsvg_gal_add_jscss_admin()
{
	if (isset($_GET['page']) && $_GET['page'] == 'mapsvg-config') {

		// mapsvg_gal_add_jscss_common();

		$deps = array('mapsvg', 'admin.mapsvg', 'controller.admin.mapsvg');

		if (MAPSVG_GAL_DEBUG) {
			wp_register_script('gallery.controller.admin.mapsvg', MAPSVG_GAL_PLUGIN_URL . 'js/gallery-controller.js', $deps, MAPSVG_GAL_ASSET_VERSION);
			wp_localize_script('gallery.controller.admin.mapsvg', 'mapsvg_gal_paths', array(
				'root'      => MAPSVG_GAL_PLUGIN_PATH,
				'templates' => MAPSVG_GAL_PLUGIN_PATH . 'js/templates/'
			));
			wp_enqueue_script('gallery.controller.admin.mapsvg');
			wp_enqueue_script('gallery-list.controller.admin.mapsvg', MAPSVG_GAL_PLUGIN_URL . 'js/gallery-list-controller.js', $deps, MAPSVG_GAL_ASSET_VERSION);
		} else {
			wp_register_script('mapsvg-gallery-admin', MAPSVG_GAL_PLUGIN_URL . 'dist/mapsvg-gallery-admin.min.js', $deps, MAPSVG_GAL_ASSET_VERSION);
			wp_localize_script('mapsvg-gallery-admin', 'mapsvg_gal_paths', array(
				'root'      => MAPSVG_GAL_PLUGIN_PATH,
				'templates' => MAPSVG_GAL_PLUGIN_PATH . 'js/templates/'
			));
			wp_enqueue_script('mapsvg-gallery-admin');
		}
	}
}
add_action('admin_enqueue_scripts', 'mapsvg_gal_add_jscss_admin', 0);
add_action('mapsvg_shortcode', 'mapsvg_gal_add_jscss_common');
