<?php

require_once WP_PLUGIN_DIR . '/nichecreator/includes/libraries/action-scheduler/action-scheduler.php';
require_once plugin_dir_path(__FILE__).'../includes/funcionesduplicacion.php';


require_once WP_PLUGIN_DIR . '/nichecreator/includes/spintax.php';

if (!function_exists('tag_exists')) {
    require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
}


function lanzar_cargar_categorias()
{
        global $wpdb;
	///////////////////////////////////////////////////////////////////////////////////////
	// TAREAS CREAR CATEGORIAS....
	//////////////////////////////////////////////////////////////////////////////////////
	require_once ABSPATH .'wp-includes/pluggable.php';
	if (isset($_POST['regenerarcats']) && !isset($_POST['guardarsettings']) && !isset($_POST['pararcats']))
	{
	if (!wp_verify_nonce($_POST['_wpnonce'], 'settingscat_'.get_the_ID())) 
		{
		add_action('admin_notices','mostrar_error');
		}
	else
	{
//	delete_option('nichecreator_numfichas');
//	delete_option('nichecreator_ordenacion');
//	delete_option('nichecreator_tipoordenacion');
	 $seleccion = [
    			'autor' => $_POST["autor"],
    			'type' => $_POST["type"],
    			'plantillas' => $_POST["plantillas"],
    			'campoordenacion' => $_POST["campoordenacion"],
    			'tipoordenacion' => $_POST["tipoordenacion"],
    			'numfichas' => $_POST["numfichas"],
    			'noindexpadres' => $_POST["noindexpadres"] ?? '',
    			'textoh1padre' => $_POST["textoh1padre"] ?? '',
    			'metatitlepadre' => $_POST["metatitlepadre"] ?? '',
    			'metadescpadre' => $_POST["metadescpadre"] ?? '',
    			'descripcioncatpadre' => $_POST["descripcioncatpadre"] ?? '',
    			'parrafo5' => $_POST["parrafo5"] ?? '',
    			'noindex' => $_POST["noindex"],
    			'textoh1' => $_POST["textoh1"],
    			'metatitle' => $_POST["metatitle"],
    			'metadesc' => $_POST["metadesc"],
    			'descripcioncat' => $_POST["descripcioncat"],
    			'parrafo4' => $_POST["parrafo4"],
    			'parrafo1' => $_POST["parrafo1"],
    			'textopropio' => $_POST["textopropio"],
    			'textopropiogemini' => $_POST["textopropiogemini"],
			'catprueba' => $_POST["catprueba"],
			];
	update_option('nichecreator_datoscategorias', $seleccion);
	wp_cache_delete('nichecreator_datoscategorias', 'options'); 
	if (isset($_POST["escrapeo"]) && !empty($_POST["escrapeo"])) {
    			update_option('nichecreator_selectescrapeo', $_POST["escrapeo"]);
			}
	$offset = $_POST['offsetcats'];
	$contador = $_POST['contador'];
	if ($seleccion['catprueba'] == 'Si') // Página de prueba....
	{
	$escrapeoscats = get_option('nichecreator_selectescrapeo', ''); // ahora esperamos un solo valor
	$escrapeo = sanitize_text_field($escrapeoscats); // nombre adaptado para reflejar que es solo uno
	$tabla_niche = $wpdb->prefix . 'niche_tabla';
	$query = "SELECT DISTINCT SearchRequest, categoriapadre FROM $tabla_niche WHERE escrapeo = %s";
	$cat = $wpdb->get_row($wpdb->prepare($query, $escrapeo));
	$catpadre = normalizar($cat->categoriapadre);
    $cathija  = normalizar($cat->SearchRequest);
	 // Variables de plantilla
    $descripcioncat      = devolver_etiquetas($seleccion['descripcioncat'] ?? '');
    $descripcioncatpadre = devolver_etiquetas($seleccion['descripcioncatpadre'] ?? '');
    $textoh1             = $seleccion['textoh1'] ?? '';
	$textoh1 = 'TEST '.$textoh1;
    $textoh1padre        = $seleccion['textoh1padre'] ?? '';
	$textoh1padre = 'TEST '.$textoh1padre;
    $parrafoconc         = devolver_etiquetas($seleccion['parrafo4'] ?? '');
    $parrafoconcpadre    = devolver_etiquetas($seleccion['parrafo5'] ?? '');
    $prompt              = $seleccion['textopropio'] ?? '';
    $promptgemini        = $seleccion['textopropiogemini'] ?? '';
    $parrafo1            = devolver_etiquetas($seleccion['parrafo1'] ?? '');
    $metatitle           = $seleccion['metatitle'] ?? '';
    $metatitlepadre      = $seleccion['metatitlepadre'] ?? '';
    $metadesc            = $seleccion['metadesc'] ?? '';
    $metadescpadre       = $seleccion['metadescpadre'] ?? '';
	$pluginseo = $seleccion['pluginseo'] ?? '';
	$ID        = $seleccion['plantillas'] ?? 0;
	$autor = get_current_user_id();
	$padreid = 0;
	if (!empty($catpadre)) {
            $padre_id = wp_insert_post([
                'post_title'  => ucwords($catpadre),
                'post_type'   => 'page',
                'post_parent' => 0,
                'post_author' => $autor,
                'post_status' => 'draft',
            ]);
	}
	if ($padre_id) {
            rellenar_pagina($autor,$ID,$padre_id,$catpadre,$descripcioncatpadre,$textoh1padre,$parrafoconcpadre,$prompt, $promptgemini, $metatitlepadre, $metadescpadre,$pluginseo,'','Si',$parrafo1,'');
        }
	if (!empty($cathija)) {
            $hija_id = wp_insert_post([
                'post_title'  => ucwords($cathija),
                'post_type'   => 'page',
                'post_parent' => $padre_id ?? 0,
                'post_author' => $autor,
                'post_status' => 'draft',
            ]);
	}
	if ($hija_id)
		{
		rellenar_pagina($autor,$ID,$hija_id,$cathija,$descripcioncat, $textoh1,$parrafoconc,$prompt, $promptgemini, $metatitle, $metadesc,$pluginseo,'X','', $parrafo1, $catpadre);
		}
	$final_url = add_query_arg('form','test',add_query_arg('page',$_GET['page'],'admin.php'));
	wp_redirect($final_url);
	exit;
	}
	
	//update_option('nichecreator_offsetcats',$offset);
	
	/*
	wp_enqueue_style('wp-jquery-ui-dialog');
	wp_register_script( 'carga-categorias', plugins_url('../js/comprobarcategorias.js',__FILE__), array('jquery','jquery-ui-dialog','wp-i18n'), '1.0', true );
	wp_set_script_translations( 'carga-categorias', 'nichecreator', plugin_dir_path(__FILE__) . '../languages' );
	$arr = array( 'ajaxurl' => admin_url('admin-ajax.php'),'nonce' => wp_create_nonce('categorias_nonce'),'offset'=>$offset,'contador'=>$contador);
	wp_localize_script('carga-categorias','obj',$arr ); 
	wp_enqueue_script( 'carga-categorias');
	*/
	//add_action( 'wp_loaded', 'schedule_cargar_categorias',99 );
	schedule_cargar_categorias();
	$final_url = add_query_arg('form','ok',add_query_arg('page',$_GET['page'],'admin.php'));
	wp_redirect($final_url);
	exit;
	}
	}
	///////////////////////////////////////////////////////////////////////////////////////
	// TAREAS CREAR CATEGORIAS....
	//////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////
	// FIN CREACION CATEGORIAS...
	///////////////////////////////////////////////////////////////////
	if (isset($_POST['pararproceso']))
	{
	$tabla = $wpdb->prefix.'actionscheduler_actions';
	//$resultado = $wpdb->get_results("DELETE FROM $tabla WHERE status = 'pending' AND hook = 'crear_duplicados'");
	$resultado = as_unschedule_all_actions( 'cargar_categorias');
	}
}
add_action('init','lanzar_cargar_categorias');

add_action('cargar_categorias', 'fun_cargar_categorias',10,4);


function schedule_cargar_categorias() {
	$contador = $_POST['contador'];
	$offset = $_POST['offsetcats'];
	delete_option('nichecreator_datoscategorias'); 
	update_option('nichecreator_datoscategorias', $_POST, false);
	wp_cache_delete('nichecreator_datoscategorias', 'options'); 
	//nichecreator_borrar_cache();
	nichecreator_precargar_cache();
	delete_transient('nichecreator_tag_cache');
	$escrapeoscats = get_option('nichecreator_selectescrapeo', ''); // ahora se espera un string
	$escrapeos = sanitize_text_field($escrapeoscats); // usamos el mismo nombre por coherencia
	for ($i=1;$i<=$contador;$i=$i+$offset)
	{
		//	if ( false === as_has_scheduled_action( 'cargar_categorias' ) ) {
		$inicio = $i;
		$fin = $inicio + $offset;
		if ($fin > $contador )
			$fin = $contador;
		//$datos = base64_encode(gzcompress(serialize($_POST), 9));
		$ejecucion = as_enqueue_async_action('cargar_categorias', array($contador,$inicio,$offset,$escrapeos),'',false);
		if ($ejecucion)
			{
			$transient = 'carga_categorias_'.$inicio;
			set_transient( $transient, $ejecucion, 60*60*12 );
			}
		//}
	}
	 
}
//wp_schedule_single_event( time()+20, 'eg_midnight_log',array() );


////////////////////////////////////////////////////////
////////// CARGAR CATEGORIAS /////////////////////////
////////////////////////////////////////////////////

function fun_cargar_categorias($contador, $inicio, $offset,$escrapeos) {
    global $wpdb;

    $datos = get_option('nichecreator_datoscategorias');
    $cache = nichecreator_cargar_cache(); // array: ['catpadre|cathija' => [...], ...]

    // Parámetros comunes
    $pluginseo = $datos['pluginseo'] ?? '';
    $autor     = intval($datos['autor'] ?? 0);
    $type      = sanitize_key($datos['type'] ?? 'publish');
    $ID        = $datos['plantillas'] ?? 0;

    // Variables de plantilla
    $descripcioncat      = devolver_etiquetas($datos['descripcioncat'] ?? '');
    $descripcioncatpadre = devolver_etiquetas($datos['descripcioncatpadre'] ?? '');
    $textoh1             = $datos['textoh1'] ?? '';
    $textoh1padre        = $datos['textoh1padre'] ?? '';
    $parrafoconc         = devolver_etiquetas($datos['parrafo4'] ?? '');
    $parrafoconcpadre    = devolver_etiquetas($datos['parrafo5'] ?? '');
    $prompt              = $datos['textopropio'] ?? '';
    $promptgemini        = $datos['textopropiogemini'] ?? '';
    $parrafo1            = devolver_etiquetas($datos['parrafo1'] ?? '');
    $metatitle           = $datos['metatitle'] ?? '';
    $metatitlepadre      = $datos['metatitlepadre'] ?? '';
    $metadesc            = $datos['metadesc'] ?? '';
    $metadescpadre       = $datos['metadescpadre'] ?? '';
    $noindexcats         = $datos['noindex'] ?? '';
    $noindexcatspadres   = $datos['noindexpadres'] ?? '';
	$catprueba           = $datos['catprueba'] ?? '';

    // Calcular límites
    $inicio  = max(0, intval($inicio) - 1);
    $offset  = intval($offset);
    $contador = intval($contador);
    if (($inicio + $offset) > $contador) {
        $offset = $contador - $inicio;
    }

    // Obtener bloques a procesar
    $tabla_niche = $wpdb->prefix . 'niche_tabla';
	$query = "SELECT DISTINCT SearchRequest, categoriapadre FROM $tabla_niche WHERE escrapeo = %s LIMIT %d OFFSET %d";
	$cats = $wpdb->get_results($wpdb->prepare($query, $escrapeos, $offset, $inicio));
    //$cats = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT SearchRequest, categoriapadre FROM $tabla_niche LIMIT %d OFFSET %d",$offset, $inicio));

    // Procesar cada combinación padre-hija
    foreach ($cats as $cat) {
        $catpadre = normalizar($cat->categoriapadre);
        $cathija  = normalizar($cat->SearchRequest);
        //$key      = $catpadre . '|' . $cathija;
        //$padre_key = $catpadre . '|'; // Entrada de la categoría padre sin hija
		$key       = cache_key($catpadre, $cathija);
		$padre_key = cache_key($catpadre);
		
	$is_raiz = empty($catpadre);	

/*
	if (isset($cache[$key]) && $cache[$key]['padre_id'] > 0 && $cache[$key]['hija_id'] > 0) {
		// Ya está en caché y con datos válidos → no sobrescribir
		continue;
	}
	
	if (isset($cache[$key]) && $is_raiz && $cache[$key]['hija_id'] > 0) {
		// Ya está en caché y con datos válidos → no sobrescribir
		continue;
	}
*/
        $info       = $cache[$key]       ?? ['padre_id' => 0, 'hija_id' => 0, 'etiqueta_id' => 0, 'num_fichas' => 0];
        $info_padre = $cache[$padre_key] ?? ['padre_id' => 0, 'etiqueta_id' => 0];

        $padre_id    = intval($info_padre['padre_id'] ?? 0);
        $hija_id     = intval($info['hija_id'] ?? 0);
        $etiqueta_id = intval($info_padre['etiqueta_id'] ?? 0);


        // Crear página padre si no existe
        if (!$is_raiz && $padre_id === 0) {
            $padre_id = wp_insert_post([
                'post_title'  => ucwords($catpadre),
                'post_type'   => 'page',
                'post_parent' => 0,
                'post_author' => $autor,
                'post_status' => $type,
            ]);
            if (is_wp_error($padre_id) || $padre_id == 0) {
                log_categoria_error("Error al crear padre: $catpadre");
                continue;
            }
            update_post_meta($padre_id, 'nichecreator_categoria', $catpadre);
        }
        // Rellenar contenido del padre
        if (!$is_raiz && $padre_id) {
            rellenar_pagina(
                $autor,$ID, $padre_id, $catpadre,
                $descripcioncatpadre, $textoh1padre, $parrafoconcpadre,
                $prompt, $promptgemini, $metatitlepadre, $metadescpadre,
                $pluginseo, '', $noindexcatspadres, $parrafo1, ''
            );
        }

        // Crear página hija (o raíz) si no existe
        if ($hija_id === 0 && !empty($cathija)) {
            $hija_id = wp_insert_post([
                'post_title'  => ucwords($cathija),
                'post_type'   => 'page',
                'post_parent' => $is_raiz ? 0 : $padre_id,
                'post_author' => $autor,
                'post_status' => $type,
            ]);
            if (is_wp_error($hija_id) || $hija_id == 0) {
                log_categoria_error("Error al crear hija/raíz: $cathija");
                continue;
            }
            update_post_meta($hija_id, 'nichecreator_categoria', $cathija);
            if (!$is_raiz) {
                update_post_meta($hija_id, 'nichecreator_categoriapadre', $catpadre);
            }
        }

        // Crear etiqueta si no existe
        if (!$is_raiz && $etiqueta_id === 0) {
            $nuevo = wp_insert_term($catpadre, 'post_tag', ['description' => $catpadre]);
            if (!is_wp_error($nuevo)) {
                $etiqueta_id = $nuevo['term_id'];
            }
        }

        // Asociar etiqueta
        if ($hija_id && $etiqueta_id) {
            wp_set_post_tags($hija_id, [$etiqueta_id]);
        }

        // Rellenar contenido hija o raíz
        rellenar_pagina(
            $autor,$ID, $hija_id, $cathija,
            $descripcioncat, $textoh1, $parrafoconc,
            $prompt, $promptgemini, $metatitle, $metadesc,
            $pluginseo, 'X', $noindexcats, $parrafo1, $catpadre
        );

        // Guardar en la nueva caché simplificada
        if (!$is_raiz)
       	{
        $cache[$padre_key] = [
            'padre_id'    => $padre_id,
            'etiqueta_id' => $etiqueta_id,
        ];
	}
        $cache[$key] = [
            'padre_id'    => $padre_id,
            'hija_id'     => $hija_id,
            'etiqueta_id' => $etiqueta_id,
            'num_fichas'  => $info['num_fichas'] ?? 0,
        ];
    }

    // Guardar cache final
    nichecreator_guardar_cache_completa($cache);
}



////////////////////////////////////////////////////////////////
////////////// RELLENAR PAGINA //////////////////////////////////
//////////////////////////////////////////////////////////////////

function rellenar_pagina($autor,$ID, $pageID, $pagename, $descripcion, $textoh1, $parrafoconc, $prompt, $promptgemini, $metatitle, $metadesc, $pluginseo, $hija, $noindex, $parrafo1,$categoriapadre = '') 
{
global $wpdb;   		
$seleccion = get_option('nichecreator_datoscategorias', []);
$pagename = trim($pagename);
$pagename_slug = sanitize_title($pagename); 
$tabla = $wpdb->prefix . 'niche_tabla';
//$numfichas = get_option('nichecreator_numfichas');
//$orderby = get_option('nichecreator_ordenacion');
//$order = get_option('nichecreator_tipoordenacion');
$numfichas = $seleccion['numfichas'] ?? 10;
$orderby = $seleccion['campoordenacion'] ?? 'OrganizationName';
$order = $seleccion['tipoordenacion'] ?? 'asc';
//$numerico = get_option('nichecreator_numerico');
if ($orderby == 'ReviewsTotalCount')
	$numerico = 'numerico';
else $numerico = 'alfanumerico';
$language = nombreIdioma(get_option('nichecreator_idioma'));
// Consulta de entradas
/*
if ($hija == 'X') {
	$orderby_column = preg_replace('/[^a-zA-Z0-9_]/', '', $orderby);
	$order_direction = strtoupper($order) === 'DESC' ? 'DESC' : 'ASC';
	$sql = $numerico === 'numerico' 
			? $wpdb->prepare("SELECT * FROM $tabla WHERE SearchRequest = %s AND categoriapadre = %s ORDER BY REPLACE($orderby_column, ',', '.') + 0 $order_direction LIMIT %d", $pagename, $categoriapadre, $numfichas)
			: $wpdb->prepare("SELECT * FROM $tabla WHERE SearchRequest = %s AND categoriapadre = %s ORDER BY $orderby_column $order_direction LIMIT %d", $pagename, $categoriapadre, $numfichas);
	} else {
		$sql = $wpdb->prepare("SELECT * FROM $tabla WHERE categoriapadre = %s", $pagename);
	}
*/
// Consulta de entradas
if ($hija == 'X') {
    $orderby_column = preg_replace('/[^a-zA-Z0-9_]/', '', $orderby);
    $order_direction = strtoupper($order) === 'DESC' ? 'DESC' : 'ASC';
    if ($numerico === 'numerico') {
        // Ordenar primero por ReviewsTotalCount (numérico real)
        // y luego por RateStars convertido de VARCHAR a número
        $sql = $wpdb->prepare("SELECT * FROM $tabla WHERE SearchRequest = %s AND categoriapadre = %s ORDER BY $orderby_column $order_direction,COALESCE(NULLIF(REPLACE(RateStars, ',', ''), ''), '0') + 0 $order_direction LIMIT %d",$pagename, $categoriapadre, $numfichas);
		} else {
				if ($orderby_column === 'RateStars') {
					// Ordenar por RateStars convertido a número, luego por ReviewsTotalCount
			$sql = $wpdb->prepare("SELECT * FROM $tabla WHERE SearchRequest = %s AND categoriapadre = %s ORDER BY COALESCE(NULLIF(REPLACE(RateStars, ',', ''), ''), '0') + 0 $order_direction, ReviewsTotalCount $order_direction LIMIT %d",$pagename, $categoriapadre, $numfichas);
    } else {
        // Orden alfanumérico simple
        $sql = $wpdb->prepare("SELECT * FROM $tabla WHERE SearchRequest = %s AND categoriapadre = %s ORDER BY $orderby_column $order_direction LIMIT %d",$pagename, $categoriapadre, $numfichas);
    }			}
	} else {
    $sql = $wpdb->prepare("SELECT * FROM $tabla WHERE categoriapadre = %s", $pagename);
	}	
	
	$entradas = $wpdb->get_results($sql);



	if (empty($entradas)) return true;

	$fila = $entradas[0];
	$meta = get_post_meta($pageID); // Meta en lote
	$spintax = new Spintax();
	$nuevo_cont = '';

	// SEO plugin meta
	$meta_key_prefix = ($pluginseo === 'rankmath') ? 'rank_math_' : '_yoast_wpseo_';
	update_post_meta($pageID, $meta_key_prefix . 'bctitle', $pagename);

	if ($noindex === 'Si') {
		update_post_meta($pageID, $meta_key_prefix . ($pluginseo === 'rankmath' ? 'robots' : 'meta-robots-noindex'), $pluginseo === 'rankmath' ? ['noindex'] : '1');
	}

	if (!empty($metatitle)) {
		$metatitlex = reemplazar($metatitle, $fila);
		update_post_meta($pageID, $meta_key_prefix . 'title', $metatitlex);
	}
	if (!empty($metadesc)) {
		$metadescx = reemplazar($metadesc, $fila);
		update_post_meta($pageID, $meta_key_prefix . 'description', $metadescx);
	}

	// Descripción
	if (!empty($descripcion)) {
		$descripcionx = reemplazar($spintax->spin($descripcion), $fila);
		update_post_meta($pageID, 'nichecreator_descripcion', $descripcionx);
		$contenidofinal = '<!-- wp:html --><div class="descripcion">' . $descripcionx . '</div><!-- /wp:html -->';
	} else {
		$contenidofinal = '<!-- wp:html --><div class="descripcion">' . ($meta['nichecreator_descripcion'][0] ?? '') . '</div><!-- /wp:html -->';
	}

	// H1
	if (!empty($textoh1)) {
		$textoh1x = reemplazar($textoh1, $fila);
		update_post_meta($pageID, 'nichecreator_textoh1', $textoh1x);
		$titulo = $textoh1x;
	} else {
		$titulo = $meta['nichecreator_textoh1'][0] ?? $pagename;
	}
	$titulo = ucfirst($titulo);
	// Si es hija, genera contenido basado en plantilla
	if ($hija === 'X') {
		$plantilla = get_post($ID);
		if (!$plantilla) return false;

		$contenido_base = devolver_etiquetas($plantilla->post_content);

		$meta_datos = get_post_meta($pageID, 'nichecreator_metacats', true);
		$meta_datos = is_array($meta_datos) ? $meta_datos : [];
		$datos_guardados = [];
		foreach ($entradas as $entrada) {
			$contenidox = $contenido_base;
			$id_entrada = $entrada->id;
			// %parrafo1
			if (str_contains($contenidox, '%parrafo1')) {
				if (!empty($parrafo1)) {
					$parrafo1x = reemplazar($spintax->spin($parrafo1), $entrada);
					} else {
						$parrafo1x = $meta_datos[$id_entrada]['parrafo1'] ?? '';
						}
				$contenidox = str_replace('%parrafo1', $parrafo1x, $contenidox);
				$datos_guardados[$id_entrada]['parrafo1'] = $parrafo1x;
			}
			// %openaiX y %geminitexto
			foreach (['1' => 'intro', '2' => 'content', '3' => 'conclu'] as $i => $tipo) {
				if (str_contains($contenidox, "%openai$i")) {
					$key = "openai$i";
					if (isset($meta_datos[$id_entrada][$key])) {
					$texto = $meta_datos[$id_entrada][$key];
					} else {
						$texto = openAI2($pagename, $tipo, 500, $language);
					}
					$contenidox = str_replace("%openai$i", $texto, $contenidox);
					$datos_guardados[$id_entrada][$key] = $texto;
				}
			}
			// %openaitexto con prompt
			if (str_contains($contenidox, '%openaitexto')) {
				if (!empty($prompt)) {
					$promptx = reemplazar($prompt, $entrada);
					$texto = openAI2($promptx, 'textopropio');
				} else {
					$texto = $meta_datos[$id_entrada]['openaitexto'] ?? '';
				}
				$contenidox = str_replace('%openaitexto', $texto, $contenidox);
				$datos_guardados[$id_entrada]['openaitexto'] = $texto;
			}

			// %geminitexto con prompt
			if (str_contains($contenidox, '%geminitexto')) {
				if (!empty($promptgemini)) {
					$promptx = reemplazar($promptgemini, $entrada);
					$texto = gemini($promptx);
				} else {
				$texto = $meta_datos[$id_entrada]['geminitexto'] ?? '';
			}
			$contenidox = str_replace('%geminitexto', $texto, $contenidox);
			$datos_guardados[$id_entrada]['geminitexto'] = $texto;
			}
			$nuevo_cont .= reemplazar($contenidox, $entrada);
		}
		update_post_meta($pageID, 'nichecreator_metacats', $datos_guardados);
		update_post_meta($pageID, 'nichecreator_contenido', $nuevo_cont);
		update_post_meta($pageID, 'nichecreator_fichascategoria', $numfichas);
		$contenidofinal .= $nuevo_cont . '<!-- wp:shortcode -->[nc_get_tag]<!-- /wp:shortcode -->';

	} else {
		// Si es página padre
		$contenidofinal .= '<!-- wp:shortcode -->[nc_get_children]<!-- /wp:shortcode -->';
	}

	// Párrafo de conclusión
	if (!empty($parrafoconc)) {
		$parrafoconcx = reemplazar($spintax->spin($parrafoconc), $fila);
		update_post_meta($pageID, 'nichecreator_parrafoconc', $parrafoconcx);
		$contenidofinal .= '<!-- wp:html --><div class="concl">' . $parrafoconcx . '</div><!-- /wp:html -->';
	} else {
		$contenidofinal .= '<!-- wp:html --><div class="concl">' . ($meta['nichecreator_parrafoconc'][0] ?? '') . '</div><!-- /wp:html -->';
	}

	$antes = strlen( $contenidofinal );
	$contenidofinal = nc_strip_4byte( $contenidofinal );
	$quitados = $antes - strlen( $contenidofinal );
	if ( $quitados ) {
		error_log( "Quitados $quitados bytes 4-bytes" );
	}


	$contenidofinal = wp_slash($contenidofinal);
	// Actualización final del post
	$args = [
		"ID" => $pageID,
		"post_title" => $titulo,
		"post_content" => $contenidofinal,
		"post_name" => $pagename_slug,
		"post_author" => $autor
	];

	remove_filter('content_save_pre', 'wp_filter_post_kses');
	remove_filter('content_filtered_save_pre', 'wp_filter_post_kses');

	$resultado = wp_update_post($args);
	if (is_wp_error($resultado)) {
		error_log('Error actualizando post: ' . $resultado->get_error_message());
	}

	return true;
}


// logger-categorias.php

function log_categoria_error($mensaje) {
    static $log = null; // Recurso persistente dentro de la ejecución

    if (!$log) {
        $log_path = plugin_dir_path(__FILE__) . "../logs/logcategorias.log";
        $log = fopen($log_path, "a");

        if (!$log) {
            // En caso de error al abrir el archivo, no continuar
            error_log("No se pudo abrir el log de categorías: $log_path");
            return;
        }
    }

    // Aseguramos que el mensaje sea string
    if (is_wp_error($mensaje)) {
        $mensaje = $mensaje->get_error_message();
    }

    $linea = current_datetime()->format('Y-m-d H:i:s') . ' | ' . $mensaje . "\r\n";
    fwrite($log, $linea);
}

function cerrar_log_categoria_error() {
    static $log = null;

    // Recuperamos el mismo recurso del log y lo cerramos si existe
    if ($log) {
        fclose($log);
        $log = null;
    }
}

