<?php

require_once WP_PLUGIN_DIR . '/nichecreator/includes/libraries/action-scheduler/action-scheduler.php';

require_once plugin_dir_path(__FILE__).'../includes/funcionesduplicacion.php';

function lanzar_duplicados()
{
global $wpdb;
///////////////////////////////////////////////////////////////////////
	// FORMULARIO ENVIADO PARA CLONAR PAGINAS, EMPEZAMOS EL PROCESO.....
	///////////////////////////////////////////////////////////////////
	if (isset($_POST['clonarplantilla']))
	{
		if (!wp_verify_nonce($_POST['_wpnonce'], 'clonar_plantilla'.get_the_ID())) 
			{
			add_action('admin_notices','mostrar_error');
			}
		else // Importación de campos.......proceso de clonado....
			{
			 $seleccion = [
			'plantillas' => $_POST["plantillas"],
    			'autor' => $_POST["autor"],
    			'type' => $_POST["type"],
			'programacion' => $_POST["programacion"],
    			'imagendestacada' => $_POST["imagendestacada"],
    			'h1' => $_POST["h1"] ?? '',
    			'metatitle' => $_POST["metatitle"] ?? '',
    			'metadesc' => $_POST["metadesc"] ?? '',
			'parrafo1' => $_POST["parrafo1"],
			'parrafo2' => $_POST["parrafo2"],
			'parrafo3' => $_POST["parrafo3"],
    			'textopropio' => $_POST["textopropio"],
    			'textopropiogemini' => $_POST["textopropiogemini"],
    			'fichaprueba' => $_POST["fichaprueba"],
			];
			update_option('nichecreator_datosduplicados', $seleccion);
			wp_cache_delete('nichecreator_datosduplicados', 'options');
			// Guardar escrapeos...
			if (isset($_POST["escrapeo"]) && !empty($_POST["escrapeo"])) {
    			update_option('nichecreator_dupliescrapeo', $_POST["escrapeo"]);
			}
			$ID = $_POST['plantillas'];
			$contador = $_POST['contador'];
			$offset = $_POST['offset'];
			//update_option('nc_offset',$offset);
			//add_action( 'admin_enqueue_scripts', 'cargar_dupli_scripts' );
			if ($seleccion['fichaprueba'] == 'Si') // Ficha de prueba....
			{
			$escrapeosfichas = get_option('nichecreator_dupliescrapeo','');
			$escrapeo = sanitize_text_field($escrapeosfichas); // por seguridad
			$tabla    = $wpdb->prefix . 'niche_tabla';
			$query    = "SELECT * FROM $tabla WHERE escrapeo = %s";
			$entrada  = $wpdb->get_row($wpdb->prepare($query, $escrapeo));
			$h1                = esc_attr($seleccion['h1'] ?? '');
			$title         = $entrada->h1 ?: reemplazar($h1, $entrada);
			$title = "TEST ".$title;
			$ID = $seleccion['plantillas'];
			$slug = $entrada->slug ?: sanitize_title($title);
			$migapan = $entrada->migapan ?: $title;
			$metatitle         = esc_attr($seleccion['metatitle'] ?? '');
   			$metadesc          = esc_textarea($seleccion['metadesc'] ?? '');
			$metatitlex    = $entrada->metatitle ?: reemplazar($metatitle, $entrada);
        		$metadescx     = $entrada->metadesc ?: reemplazar($metadesc, $entrada);
        		$tipo = 'draft';
        		$imagendestacada = $seleccion['imagendestacada'] ?? '';
        		$pluginseo         = esc_attr($seleccion['pluginseo'] ?? '');
        		$parrafo1          = isset($seleccion['parrafo1']) ? devolver_etiquetas($seleccion['parrafo1']) : '';
    			$parrafo2          = isset($seleccion['parrafo2']) ? devolver_etiquetas($seleccion['parrafo2']) : '';
    			$parrafo3          = isset($seleccion['parrafo3']) ? devolver_etiquetas($seleccion['parrafo3']) : '';
    			$parrafo1x     = reemplazar($parrafo1, $entrada);
        		$parrafo2x     = reemplazar($parrafo2, $entrada);
        		$parrafo3x     = reemplazar($parrafo3, $entrada);
        		$textopropio       = esc_textarea($seleccion['textopropio'] ?? '');
    			$textopropiogemini = esc_textarea($seleccion['textopropiogemini'] ?? '');
    			$textopropiox  = reemplazar($textopropio, $entrada);
        		$textopropiogeminix = reemplazar($textopropiogemini, $entrada);
        		$autor = get_current_user_id();
        		$identificador = intval($entrada->id ?? 0);
        		$telefono      = $entrada->OrganizationPhoneNr ?? '';
        		$direccion     = $entrada->OrganizationAddress ?? '';
        		$municipio     = $entrada->municipio ?? '';
        		$provincia     = $entrada->provincia ?? '';
        		$country       = $entrada->pais ?? '';
        	$horarios      = convertirhoras($entrada->lunes, $entrada->martes, $entrada->miercoles, $entrada->jueves, $entrada->viernes, $entrada->sabado, $entrada->domingo);
        		$horarios      = json_encode($horarios, JSON_UNESCAPED_UNICODE);
        		$spintax = new Spintax();
        		$hijaid = 0;
        		$post_date = date('Y-m-d H:i:s');
			$newID = duplicate_post($ID, ucfirst($title), $slug, $migapan, $metatitlex, $metadescx, $entrada,$tipo,$imagendestacada, $pluginseo,$parrafo1x,$parrafo2x,																																																																																																																																																																																																																																																																																																																																																																																																																																	 	 $parrafo3x,$textopropiox, $textopropiogeminix,$autor, $telefono, $direccion, $municipio, $provincia, 
			$horarios,$country, $identificador, $post_date,$hijaid,$spintax);
			$final_url = add_query_arg('form','test',add_query_arg('page',$_GET['page'],'admin.php'));
			wp_redirect($final_url);
			exit;
			}
			delete_option('nichecreator_email');
			/*
			wp_enqueue_style('wp-jquery-ui-dialog');
			wp_register_script( 'carga-resultadoduplis', plugins_url('../js/comprobarfinduplis.js',__FILE__), array('jquery','jquery-ui-dialog','wp-i18n'), '1.0', true );
			wp_set_script_translations( 'carga-resultadoduplis', 'nichecreator', plugin_dir_path(__FILE__) . '../languages' );
			$arr = array( 'ajaxurl' => admin_url('admin-ajax.php'),'nonce' => wp_create_nonce('duplicados_nonce'),'offset'=>$offset,'contador'=>$contador);
			wp_localize_script('carga-resultadoduplis','obj',$arr ); 
			wp_enqueue_script( 'carga-resultadoduplis');
			add_action( 'wp_loaded', 'schedule_lanzar_duplicados',99 );
			*/
			schedule_lanzar_duplicados();
			$final_url = add_query_arg('form','ok',add_query_arg('page',$_GET['page'],'admin.php'));
			wp_redirect($final_url);
			exit;
			}
	}
	///////////////////////////////////////////////////////////////////
	// FIN CLONADO PAGINAS...
	///////////////////////////////////////////////////////////////////
	if (isset($_POST['pararproceso']))
	{
	$tabla = $wpdb->prefix.'actionscheduler_actions';
	//$resultado = $wpdb->get_results("DELETE FROM $tabla WHERE status = 'pending' AND hook = 'crear_duplicados'");
	$resultado = as_unschedule_all_actions( 'crear_duplicados');
	}
}
add_action('init','lanzar_duplicados');

function schedule_lanzar_duplicados() 
{
	$ID = $_POST['plantillas'];
	$contador = $_POST['contador'];
	$offset = $_POST['offset'];
	delete_option('nichecreator_datosduplicados'); 
	update_option('nichecreator_datosduplicados', $_POST, false);
	wp_cache_delete('nichecreator_datosduplicados', 'options'); 
	nichecreator_precargar_cachefichas();
	nichecreator_precargar_cache();
	$escrapeosfichas = get_option('nichecreator_dupliescrapeo','');
	$escrapeos = sanitize_text_field($escrapeosfichas); // por seguridad
	for ($i=1;$i<=$contador;$i=$i+$offset)
	{
		$inicio = $i;
		$fin = $inicio + $offset;
		if ($fin > $contador )
			$fin = $contador;
		$ejecucion = as_enqueue_async_action('crear_duplicados', array($ID,$contador,$inicio,$offset,$escrapeos),'',false);
		if ($ejecucion)
			{
			$transient = 'crear_duplicados_'.$inicio;
			set_transient( $transient, $ejecucion, 60*60*12 );
			}
	}
}

add_action( 'crear_duplicados', 'fun_crear_duplicados',10,5);

function fun_crear_duplicados($ID, $contador, $inicio, $offset,$escrapeos) {
    // Seguridad: sólo permitir desde Action Scheduler o WP-CLI
    global $wpdb;
	$tabla     = $wpdb->prefix . 'niche_tabla';
    // Obtener datos de configuración
    $datos = get_option('nichecreator_datosduplicados');
    // Sanitizar configuración
    $h1                = esc_attr($datos['h1'] ?? '');
    $metatitle         = esc_attr($datos['metatitle'] ?? '');
    $metadesc          = esc_textarea($datos['metadesc'] ?? '');
    $parrafo1          = isset($datos['parrafo1']) ? devolver_etiquetas($datos['parrafo1']) : '';
    $parrafo2          = isset($datos['parrafo2']) ? devolver_etiquetas($datos['parrafo2']) : '';
    $parrafo3          = isset($datos['parrafo3']) ? devolver_etiquetas($datos['parrafo3']) : '';
    $textopropio       = esc_textarea($datos['textopropio'] ?? '');
    $textopropiogemini = esc_textarea($datos['textopropiogemini'] ?? '');
    //$tipo              = in_array($datos['type'] ?? '', ['publish', 'future']) ? $datos['type'] : 'publish';
    $tipo = $datos['type'] ?? 'publish';
    $imagendestacada   = $datos['imagendestacada'] ?? '';
    $pluginseo         = esc_attr($datos['pluginseo'] ?? '');
    $autor             = intval($datos['autor'] ?? 1);
    $programacion      = intval($datos['programacion'] ?? 0);
    // Ajustar inicio y offset
    $ini    = max(0, intval($inicio) - 1);
    $offset = max(1, intval($offset));
    $fin    = $inicio + $offset;
    if ($fin > $contador) {
        $offset = $contador - $ini;
    }

    // Cargar la caché de fichas (identificador => post_id)
    $cache_fichas = nichecreator_cargar_cachefichas();
	$cache_categorias = nichecreator_cargar_cache();

    //$tiponicho = get_option('nichecreator_auto', 'generico');

    // Selección de entradas
		$query = "SELECT * FROM $tabla WHERE escrapeo = %s LIMIT %d OFFSET %d";
		$entradas = $wpdb->get_results($wpdb->prepare($query, $escrapeos, $offset, $ini));

	/*	
    if ($tiponicho === 'geo' || $tiponicho === 'mini-geo') {
        $sql = $wpdb->prepare("SELECT * FROM $tabla WHERE municipio != '' AND provincia != '' LIMIT %d OFFSET %d", $offset, $ini);
    } else {
        $sql = $wpdb->prepare("SELECT * FROM $tabla LIMIT %d OFFSET %d", $offset, $ini);
    }
    $entradas = $wpdb->get_results($sql);
	*/
	$contadorprog = 0;
     $spintax = new Spintax();
    foreach ($entradas as $entrada) {
        // Preparar campos
        $identificador = intval($entrada->id ?? 0);
        $telefono      = $entrada->OrganizationPhoneNr ?? '';
        $direccion     = $entrada->OrganizationAddress ?? '';
        $municipio     = $entrada->municipio ?? '';
        $provincia     = $entrada->provincia ?? '';
        $country       = $entrada->pais ?? '';
        $horarios      = convertirhoras($entrada->lunes, $entrada->martes, $entrada->miercoles, $entrada->jueves, $entrada->viernes, $entrada->sabado, $entrada->domingo);
        $horarios      = json_encode($horarios, JSON_UNESCAPED_UNICODE);
        $title         = $entrada->h1 ?: reemplazar($h1, $entrada);
        $slug          = $entrada->slug ?: sanitize_title($title);
        $migapan       = $entrada->migapan ?: $title;
        $metatitlex    = $entrada->metatitle ?: reemplazar($metatitle, $entrada);
        $metadescx     = $entrada->metadesc ?: reemplazar($metadesc, $entrada);
        $parrafo1x     = reemplazar($parrafo1, $entrada);
        $parrafo2x     = reemplazar($parrafo2, $entrada);
        $parrafo3x     = reemplazar($parrafo3, $entrada);
        $textopropiox  = reemplazar($textopropio, $entrada);
        $textopropiogeminix = reemplazar($textopropiogemini, $entrada);

        // Fecha de publicación si es futura
        if ($tipo === 'future') {
            $fecha_programada = current_time('timestamp') + (($contadorprog + $inicio) * $programacion * 60);
            $post_date = date('Y-m-d H:i:s', $fecha_programada);
            $contadorprog++;
        } else {
            $post_date = '';
        }
		
			$catpadre = normalizar($entrada->categoriapadre);
			$cathija  = normalizar($entrada->SearchRequest);
			$hijaid = 0;
			if ($cathija != '')
				{
				$key         = $catpadre . '|' . $cathija;
				$hijaid = $cache_categorias[$key]['hija_id'] ?? 0;
				}
        // === Si el post ya existe: ACTUALIZAR ===
        if (isset($cache_fichas[$identificador])) {
            $post_id_existente = $cache_fichas[$identificador];
            try {
                actualizar_post_existente($ID,$post_id_existente, $entrada, [
				    //'identificador'      => $identificador,
                    'title'              => ucfirst($title),
                    //'slug'               => $slug,
                    'migapan'            => $migapan,
                    'metatitle'          => $metatitlex,
                    'metadesc'           => $metadescx,
                    'parrafo1'           => $parrafo1x, 
					'parrafo2'           => $parrafo2x, 
					'parrafo3'           => $parrafo3x,
                    'textopropio'        => $textopropiox,
                    'textopropiogemini'  => $textopropiogeminix,
                    'autor'              => $autor,
                    'telefono'           => $telefono,
                    'direccion'          => $direccion,
                    'municipio'          => $municipio,
                    'provincia'          => $provincia,
                    'horarios'           => $horarios,
                    'country'               => $country,
                    'pluginseo'          => $pluginseo,
                    'imagendestacada'    => $imagendestacada,
                    'tipo'               => $tipo,
                    'post_date'          => $post_date,
					'hijaid'             => $hijaid
                ],$spintax);
            } catch (Throwable $e) {
                error_log("Error actualizando post $post_id_existente: " . $e->getMessage());
            }
            continue;
        }
        // === Si no existe: CREAR ===
        if ($hijaid == 0 and $cathija != '') // Debería haber padre, pero aún no se ha creado
        	{
        	$mensaje = __("El post $title con identificador $identificador no se puede crear porque su categoría no existe","nichecreator");
        	error_log($mensaje);
        	continue;
        	}
        try {
		$newID = duplicate_post(
                $ID, ucfirst($title), $slug, $migapan, $metatitlex, $metadescx, $entrada,
                $tipo, $imagendestacada, $pluginseo,
                $parrafo1x, $parrafo2x, $parrafo3x,
                $textopropiox, $textopropiogeminix,
                $autor, $telefono, $direccion, $municipio, $provincia, $horarios,
                $country, $identificador, $post_date,$hijaid,$spintax);
            if ($newID) {
    			$cache_fichas[$identificador] = (int) $newID;
			}
            if (!$newID) {
                error_log("Error al duplicar post (Entrada $title ID: $identificador)");
            }

        } catch (Throwable $e) {
            error_log("Excepción al duplicar entrada $title ID $identificador: " . $e->getMessage());
        }
    }
    nichecreator_guardar_cachefichas($cache_fichas);
}


function convertirhoras($lunes, $martes, $miercoles, $jueves, $viernes, $sabado, $domingo) {
    $entradas = [
        'Mo' => $lunes,
        'Tu' => $martes,
        'We' => $miercoles,
        'Th' => $jueves,
        'Fr' => $viernes,
        'Sa' => $sabado,
        'Su' => $domingo
    ];

    // Día → nombre posible (en varios idiomas)
    $dias_codigos = [
        'monday' => 'Mo', 'lunes' => 'Mo', 'lundi' => 'Mo',
        'tuesday' => 'Tu', 'martes' => 'Tu', 'mardi' => 'Tu',
        'wednesday' => 'We', 'miércoles' => 'We', 'miercoles' => 'We', 'mercredi' => 'We',
        'thursday' => 'Th', 'jueves' => 'Th', 'jeudi' => 'Th',
        'friday' => 'Fr', 'viernes' => 'Fr', 'vendredi' => 'Fr',
        'saturday' => 'Sa', 'sábado' => 'Sa', 'sabado' => 'Sa', 'samedi' => 'Sa',
        'sunday' => 'Su', 'domingo' => 'Su', 'dimanche' => 'Su'
    ];

    $opening_hours = [];

    foreach ($entradas as $codigo_dia => $texto) {
        $texto_original = $texto; // guardamos para saber si estaba vacío

        // Limpia espacios invisibles y normaliza
        $texto = preg_replace('/[\x{2009}\x{202F}]/u', ' ', $texto); // narrow space, thin space
        $texto = strtolower(trim($texto));

        $registro_encontrado = false;

        // Detectar segmentos tipo "Saturday: Closed, Sunday: 10:00 AM - 6:00 PM"
        preg_match_all(
            '/\b(monday|tuesday|wednesday|thursday|friday|saturday|sunday|lunes|martes|miércoles|miercoles|jueves|viernes|sábado|sabado|domingo|lundi|mardi|mercredi|jeudi|vendredi|samedi|dimanche)\b\s*:\s*([^,]+)/i',
            $texto,
            $matches,
            PREG_SET_ORDER
        );

        foreach ($matches as $match) {
            $dia = strtolower($match[1]);
            $valor = trim(strtolower($match[2]));
            $codigo = $dias_codigos[$dia] ?? null;
            if (!$codigo) continue;

            $registro_encontrado = true;

            if (strpos($valor, 'cerrado') !== false || strpos($valor, 'closed') !== false || strpos($valor, 'fermé') !== false) {
                continue;
            }

            if (strpos($valor, '24 horas') !== false || strpos($valor, 'open 24 hours') !== false || strpos($valor, 'ouvert 24h') !== false) {
                $opening_hours[] = "$codigo 00:00-23:59";
                continue;
            }

            // Múltiples bloques
            $bloques = preg_split('/,\s*/', $valor);
            foreach ($bloques as $bloque) {
                $bloque = str_replace(['–', '—', ' to ', ' à ', ' a '], '-', $bloque);

                if (preg_match('/(\d{1,2}:\d{2})\s*(am|pm)\s*-\s*(\d{1,2}:\d{2})\s*(am|pm)/i', $bloque, $m)) {
                    $inicio = date("H:i", strtotime($m[1] . ' ' . strtoupper($m[2])));
                    $fin = date("H:i", strtotime($m[3] . ' ' . strtoupper($m[4])));
                    $opening_hours[] = "$codigo $inicio-$fin";
                } elseif (preg_match('/(\d{1,2}):(\d{2})\s*-\s*(\d{1,2}):(\d{2})/', $bloque, $m)) {
                    $inicio = sprintf('%02d:%02d', $m[1], $m[2]);
                    $fin = sprintf('%02d:%02d', $m[3], $m[4]);
                    $opening_hours[] = "$codigo $inicio-$fin";
                }
            }
        }

        // Si no había días embebidos y el campo está vacío → 24h por defecto
        if (!$registro_encontrado && empty(trim($texto_original))) {
            $opening_hours[] = "$codigo_dia 00:00-23:59";
        }
    }

    return $opening_hours;
}

