<?php

if (!defined('ABSPATH')) {
    exit; // Evita el acceso directo
}

if (!current_user_can('manage_options')) {
    return;
}



require_once WP_PLUGIN_DIR . '/nichecreator/includes/libraries/action-scheduler/action-scheduler.php';
require_once plugin_dir_path(__FILE__).'paises/obtenergeograficos.php';
function check_datos()
{
global $wpdb;
global $tabla;
	//$screen = get_current_screen();
	//var_dump($screen);
	//////////////////////////////////////////////////////////////////////////
	///////// BORRAR TAREAS DE FONDO /(///////////////////////////////////
	////////////////////////////////////////////////////////////////////////
	if (isset($_POST['pararproceso']))
	{
	$resultado = as_unschedule_all_actions('cargar_scrape');
	$final_url = add_query_arg('pararporcs','ok', add_query_arg('page', $_GET['page'], 'admin.php')	);
	wp_redirect($final_url);
	exit;

	}
	////////////////////////////////////////////////////////////////////////////////////////
	///////// BORRAR FICHERO CSV .....
	////////////////////////////////////////////////////////////////////////////////////////
	if (isset($_POST['borrarfichero'])) // Formulario de carga ya informado, proceso...
	{
	if (!wp_verify_nonce($_POST['_wpnonce'], 'borrar_csv'.get_the_ID())) 
		{
		add_action('admin_notices','mostrar_error');
		}
	else // Borramos el fichero...
		{
		$seleccion = [
    			'modo' => "manual"
			];
		update_option('nichecreator_datosescrapeo', $seleccion);
		wp_cache_delete('nichecreator_datosescrapeo', 'options'); 
		unlink( $_POST['ficheroborrado'] );
		delete_option('nichecreator_csv');
		$final_url = add_query_arg(
		'mensaje',
		'borrado',
		add_query_arg('page', $_GET['page'], 'admin.php')
		);
		wp_redirect($final_url);
		exit;
		}
	}
	////////////////////////////////////////////////////////////////////////////////////////
	///////// BORRAR FICHERO CSV .....
	////////////////////////////////////////////////////////////////////////////////////////
	
	///////////////////////////////////////////////////////////////////////////////////////
	// SUBIR EL FICHERO CSV....
	//////////////////////////////////////////////////////////////////////////////////////
	if ( !empty($_SERVER['CONTENT_LENGTH']) && empty($_FILES) && empty($_POST) )
		add_action('admin_notices','mostrar_error_size');
	if (!empty($_FILES['uploadCSV']['name'])) // Formulario de carga ya informado, proceso...
	{
	if (!wp_verify_nonce($_POST['_wpnonce'], 'subir_csv'.get_the_ID())) 
		{
		add_action('admin_notices','mostrar_error');
		}
	else // Subimos el fichero...(hay un hook creado..)
		{
		if ($_FILES['uploadCSV']['error'] == 0) // NO hay error
		{
		 $seleccion = [
    			'modo' => "manual"
			];
		$resultado = update_option('nichecreator_datosescrapeo', $seleccion);
		wp_cache_delete('nichecreator_datosescrapeo', 'options'); 
		$ext = pathinfo($_FILES['uploadCSV']['name'], PATHINFO_EXTENSION);
				if( $ext !== 'csv' ) {
					add_action('admin_notices','mostrar_subirficherocsvextension');
					}
				elseif (!verificar_CSVcoma($_FILES['uploadCSV']['tmp_name']))
					{
					add_action('admin_notices','mostrar_errorcsv');
					}
				else
					{
					//$upload = wp_upload_bits($_FILES['fileToUpload']['name'], null, $_FILES['fileToUpload']['tmp_name']);
					$upload_dir = wp_upload_dir();
					$user_dirname = $upload_dir['basedir'];
					$ficheros = glob("$user_dirname/*.csv");
					if (!empty($ficheros)) // Si hay algun fichero lo borramos... 
					{
					delete_option('nichecreator_csv');
					foreach ($ficheros as $fichero)
						{
							unlink($fichero);
						}
					}
					$filename = wp_unique_filename( $user_dirname, $_FILES['uploadCSV']['name'] );
					$csv = $user_dirname.'/'.$filename;
					$resultado = move_uploaded_file($_FILES['uploadCSV']['tmp_name'], $csv);
					if ($resultado)
					{
					$entradas = calcular_entradas($csv);
					update_option('nichecreator_csv',$entradas);
					wp_cache_delete('nichecreator_csv', 'options'); 
					$final_url = add_query_arg(
					'mensaje',
					'exito',
					add_query_arg('page', $_GET['page'], 'admin.php')
					);
					wp_redirect($final_url);
					exit;
					}
					else
					add_action('admin_notices','mostrar_error');
 					}
		}
 		else 
 		  {
 		  add_action('admin_notices','mostrar_error');
 		  }
		}
	}
	///////////////////////////////////////////////////////////////////////////////////////
	// FIN SUBIR EL FICHERO CSV....
	//////////////////////////////////////////////////////////////////////////////////////
	
	
        ///////////////////////////////////////////////////////////////////////////////
	// PULSAR EL BOTON DE BORRAR ENTRADAS DE LA TABLA.....
	//////////////////////////////////////////////////////////////////////////////
	/*
	if (isset($_POST['borrartabla'])) // Borrado de tabla...
	{
	if (!wp_verify_nonce($_POST['_wpnonce'], 'cargar_datos'.get_the_ID()))
	{
	add_action('admin_notices','mostrar_mensajes_borrartabla');
	}
	else
	{
	//$resultado = borrar_tabla();// Borramos el fichero....
	$resultado = $wpdb->query("TRUNCATE TABLE $tabla");
	delete_option('nichecreator_arreglomunicipio');
	delete_option('nichecreator_arregloprovincia');
	delete_option('nichecreator_arreglocp');
	delete_option('nichecreator_numfichas');
	delete_option('nichecreator_ordenacion');
	delete_option('nichecreator_tipoordenacion');
	delete_option('nichecreator_keyword');
	delete_option('nichecreator_keywords');
	delete_option('nichecreator_auto');
	add_action('admin_notices','mostrar_mensajes_borrartabla_exito');
	}
	}
	*/
	///////////////////////////////////////////////////////////////////////////////////////
	// FIN PULSAR EL BOTON DE BORRAR ENTRADAS DE LA TABLA.....
	///////////////////////////////////////////////////////////////////////////////////////
	
	
	
	////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////// ESCRAPEOS //////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////
	if (isset($_POST['escrapeos']))
	{
		if (!wp_verify_nonce($_POST['_wpnonce'], 'escrapear'.get_the_ID())) 
			{
			add_action('admin_notices','mostrar_error');
			}
		else // OK, seguimos...
			{
		    $seleccion = [
    			'modo' => $_POST["modo"],
    			'tipo' => $_POST["tipo"],
    			'pais' => $_POST["pais"],
    			'provincia' => $_POST["provincia"] ?? '',
    			'idioma' => $_POST["idioma"],
    			'keyword' => sanitize_text_field($_POST["keyword"]),
    			'keywords' => sanitize_textarea_field($_POST["keywords"]),
    			'herramienta' => $_POST["herramienta"],
			];
		    update_option('nichecreator_datosescrapeo', $seleccion);
		    wp_cache_delete('nichecreator_datosescrapeo', 'options'); 
			$tipo = $_POST['tipo'];
			$modo = $_POST['modo'];
			$keyword = $_POST['keyword'] ?? '';
			$pais = $_POST['pais'];
			//$provin = $_POST['provincia'];
			$provincia = $_POST['provincia'] ?? '';
			$escrapeo = '';
			if (($tipo == 'generico') && ($modo == 'automatico')) //Generico, keywords del usuario
				{
				update_option('nichecreator_auto','generico');
				update_option('nichecreator_keyword','');
				$keywords = trim($_POST['keywords']);
				$keywords = explode("\n", $keywords);
				$keywords = array_filter($keywords, 'trim');
				$primer_keyword = reset($keywords);
				$primer_keyword = trim($primer_keyword);
				if ($primer_keyword === false) {
						$primer_keyword = 'BLANK'; // valor por defecto
				}
				$escrapeo = 'GENERICO_'.$pais.'_'.$primer_keyword;
				$contador = count($keywords);
				}
			elseif (($tipo == 'geo') && ($modo == 'automatico')) // Nicho geográfico, añadimos provincias
				{
				$escrapeo = 'PAIS_'.$pais.'_'.$keyword;
				update_option('nichecreator_auto','geo');
				update_option('nichecreator_keyword',$keyword);
				$provincias = obtener_provincias($pais);
				$keywords = array_map(function($provincia) use ($keyword) 
				{
					return $keyword . ' ' . $provincia;
				}, $provincias);
				$keywords = array_filter($keywords, 'trim');
				$contador = count($keywords);
			  }
			elseif (($tipo == 'mini-geo') && ($modo == 'automatico')) // Nicho mini geográfico
				{
				$escrapeo = 'PROVINCIA_'.$pais.'_'.$provincia.'_'.$keyword;
				update_option('nichecreator_auto','mini-geo');
				update_option('nichecreator_keyword',$keyword);
				$municipios = obtener_municipios($provincia,$pais);
				$keywords = array_map(function($municipio) use ($keyword) 
				{
					return $keyword . ' ' . $municipio;
				}, $municipios);
				$keywords = array_filter($keywords, 'trim');
				$contador = count($keywords);
				}
			if ($contador == 0)
				  error_log("Tipo: $tipo Provincia: $provincia Pais: $pais NO hay datos");
			update_option('nichecreator_contadorkw',$contador);
			$offset = $_POST['offsetscrape'];
			$idioma      = isset( $_POST['idioma'] )      ? sanitize_text_field( $_POST['idioma'] )      : '';
			$herramienta = isset( $_POST['herramienta'] ) ? sanitize_text_field( $_POST['herramienta'] ) : '';
                        //$keywords = base64_encode(gzcompress(json_encode($keywords), 9));
                        delete_option('nichecreator_keywords');
			update_option('nichecreator_keywords',$keywords);
			add_action(
			    'wp_loaded',
			    function () use ( $tipo, $contador,
			                      $offset,  $pais, $idioma, $herramienta,$escrapeo ) {

			        /*  llamamos pasando TODOS los datos que después necesitaremos  */
			        schedule_cargar_scrape(
			            $tipo,
			            $contador,
			            $offset,
			            $pais,
			            $idioma,
			            $herramienta,
						$escrapeo
			        );
					$final_url = add_query_arg(
					'form',
				    'ok',
					add_query_arg('page', $_GET['page'], 'admin.php')
				    );
					wp_redirect($final_url);
				    exit;
			    },
			    99
			);
			}
	}
}

add_action('init','check_datos');



function schedule_cargar_scrape( $tipo, $contador, $offset,  $pais, $idioma, $herramienta,$escrapeo ) {
    for ( $i = 1; $i <= $contador; $i += $offset ) {
        $inicio = $i;
        /* programamos la tarea asíncrona de Action Scheduler */
		if (!has_action('cargar_scrape')) {
        error_log('ERROR: cargar_scrape hook no registrado!');
        return;
		}
        $action_id = as_enqueue_async_action(
            'cargar_scrape',
            [ $contador, $inicio, $offset, $pais, $idioma, $herramienta, $tipo,$escrapeo ],
            '',
            false
        );
        /* guardamos el ID en un transient para que comprobarscrape.php lo encuentre */
        if ( $action_id ) {
            set_transient( 'carga_scrapes_' . $inicio, $action_id, 12 * HOUR_IN_SECONDS );
        }
    }
}




function fun_cargar_scrapes($contador,$inicio,$offset,$pais,$idioma,$herramienta,$tipo,$escrapeo)
{
$fich = plugin_dir_path(__FILE__)."../logs/scrape.log";
$fichero = fopen($fich,"a");
global $wpdb;
$tabla = $wpdb->prefix.'niche_tabla';
//ini_set('max_execution_time', '60');
$ini = $inicio - 1;
$limite = 500;
//$keywords = json_decode(gzuncompress(base64_decode($keywords)), true);
$keywords = get_option('nichecreator_keywords');
$subkeywords = array_slice($keywords,$ini,$offset);
$usuarios = get_users(['number'  => 1,'orderby' => 'ID','order'   => 'ASC','fields'  => 'ID',] );
$autor = !empty($usuarios) ? $usuarios[0] : null;
/*
if (function_exists('iconv')) 
	$iconv = true;
else {
     $iconv = false;
     fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.__('Modulo PHP iconv no instalado. Es conveniente su instalación.','nichecreator')."\r\n"); 
     }
*/
foreach ($subkeywords as $keyword)
	{
	/*
	if ($iconv)
		$keyword = limpiar_keyword_usuario($keyword);
	*/
	$keyword = trim($keyword);
	$keyword = sanitize_text_field($keyword); // Limpieza básica
	//$keyword = normalizar_unicode($keyword);
	$keyword = mb_strtolower($keyword, 'UTF-8');    // Todo en minúsculas
	if ($herramienta == 'apiplaces')
	{
	  $nextPageToken = '';
	  do
	  {
		$resultados = google_places_search($keyword,$pais,$idioma,$nextPageToken);
		if (empty($resultados))
			$resultados = google_places_search($keyword,$pais,$idioma,$nextPageToken);
		if (isset($resultados->places) && is_array($resultados->places))
		{
	    foreach ($resultados->places as $resultado) // Tratamos cada keyword...
		  {
			// Insertar entrada en tabla...
			$id = $resultado->id;
			$name = $resultado->displayName->text;
			$name = limpiar_y_capitalizar($name);
			$full_address = $resultado->formattedAddress;
			$direcciones = get_direccion($resultado->addressComponents);
			$city = normalizar($direcciones["municipio"] ?? '');
			$city = ucwords($city);
			$provincia = normalizar($direcciones["provincia"] ?? '');
			$provincia = ucwords(eliminarNumeros($provincia));
			$cp = $direcciones["cp"] ?? '';
			if ($full_address == '' && $provincia == '' && $city == '' && $cp == '')
				continue;
			$categoriapadre = '';
			$categoria = '';
			if ($tipo == 'geo')
			{
			$categoriapadre = $provincia;
			$categoria = $city;
			}
			elseif ($tipo == 'mini-geo')
				$categoria = $city;
			//$country = getcountry($pais);
			$phone = $resultado->nationalPhoneNumber ?? '';
			$latitude = $resultado->location->latitude;
			$longitude = $resultado->location->longitude;
			$reviews = $resultado->userRatingCount ?? 0;
			$rating = $resultado->rating ?? '';
			//$timezone = $resultado->timezone;
			$timezone = $resultado->timezone ?? '';
			$website = esc_url_raw($resultado->websiteUri) ?? '';
			$link = $resultado->googleMapsUri;
			$imagen = $resultado->photos[0]->authorAttributions[0]->photoUri ?? '';
			$start = substr($imagen,0,2);
			if ($start == '//')
				$imagen = str_replace($start,"https://",$imagen);
			$lunes = $resultado->regularOpeningHours->weekdayDescriptions[0] ?? '';
			$martes = $resultado->regularOpeningHours->weekdayDescriptions[1] ?? '';
			$miercoles = $resultado->regularOpeningHours->weekdayDescriptions[2] ?? '';
			$jueves = $resultado->regularOpeningHours->weekdayDescriptions[3] ?? '';
			$viernes = $resultado->regularOpeningHours->weekdayDescriptions[4] ?? '';
			$sabado = $resultado->regularOpeningHours->weekdayDescriptions[5] ?? '';
			$domingo = $resultado->regularOpeningHours->weekdayDescriptions[6] ?? '';
			$lunes = rtrim($lunes,",");
			$martes = rtrim($martes,",");
			$miercoles = rtrim($miercoles,",");
			$jueves = rtrim($jueves,",");
			$viernes = rtrim($viernes,",");
			$sabado = rtrim($sabado,",");
			$domingo = rtrim($domingo,",");
			$query = "SELECT * FROM $tabla where gmapsid = '$id'"; // Si ya existe nos la saltamos...
			$querycheck = $wpdb->get_row($query);
			if (empty($querycheck))
			{
			if ($imagen != '')
				{
					$imagenurl = subir_imagen($imagen,$name,$autor);
				}
			else $imagenurl = '';
			$insercion = $wpdb->insert($tabla,array("OrganizationName"=>$name,"GMapsLink"=>$link,"ShareLink"=>$link,"SearchRequest"=>$categoria,"categoriapadre"=>$categoriapadre,"RateStars"=>$rating,"ReviewsTotalCount"=>$reviews,"OrganizationAddress"=>$full_address,
			"municipio"=>$city,"provincia"=>$provincia,"cp"=>$cp,"pais"=>$pais,"OrganizationWebsite"=>$website,"OrganizationPhoneNr"=>$phone,"OrganizationLatitude"=>$latitude,"OrganizationLongitude"=>$longitude,"OrganizationHeadPhotoURL"=>$imagenurl,
			"lunes"=>$lunes,"martes"=>$martes,"miercoles"=>$miercoles,"jueves"=>$jueves,"viernes"=>$viernes,"sabado"=>$sabado,"domingo"=>$domingo,"gmapsid"=>$id,"keyword"=>$keyword,"escrapeo"=>$escrapeo));
			if ($insercion === false)
				{
				$error = $wpdb->last_error; 
				fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.$name.' '.__('No se pudo insertar la entrada.','nichecreator').' '.$error."\r\n");
				}
			}
		  }
	    $nextPageToken = $resultados->nextPageToken ?? '';
		}
	  } while ($nextPageToken != '');
   	} // APIPLACES
   	if ($herramienta == 'valueserp')
   	{
   	$pagina = 1;
   	do     {
   		$resultados = value_serp($keyword,$pais,$idioma,$pagina);
		if (!empty($resultados) && property_exists($resultados,'places_results')) 
		{
   		foreach ($resultados->places_results as $resultado)
			{
			$name = $resultado->title;
			$name = limpiar_y_capitalizar($name);
			$full_address = $resultado->address ?? '';
			// "address":"Alameda de Recalde, 22, Abando, 48009 Bilbao, Biscay"
			$patternprovincia='/.*,\s(.*)$/i';
			$success = preg_match($patternprovincia, $full_address, $match);
			$provincia = $match[1] ?? '';
			$provincia = normalizar($provincia ?? '');
			$provincia = ucwords(eliminarNumeros($provincia));
			$patterncp = '/(\d{4,})/i';
			$success = preg_match($patterncp, $full_address, $match);
			$cp = $match[1] ?? '';
			$patternmunicipio = '/\d{4,}\s*(.*),/i';
			$success = preg_match($patternmunicipio, $full_address, $match);
			$city = normalizar($match[1] ?? '');
			$city = ucwords($city);
			if ($full_address == '' && $provincia == '' && $city == '' && $cp == '')
				continue;
			$categoriapadre = '';
			$categoria = '';
			if ($tipo == 'geo')
			{
			$categoriapadre = $provincia;
			$categoria = $city;
			}
			elseif ($tipo == 'mini-geo')
				$categoria = $city;
			$phone = $resultado->phone ?? '';
			$latitude = $resultado->gps_coordinates->latitude;
			$longitude = $resultado->gps_coordinates->longitude;
			$reviews = $resultado->reviews ?? 0;
			$rating = $resultado->rating ?? '';
			$data_cid = $resultado->data_cid; //??????????????
			$imagen = $resultado->thumbnail ?? '';
			//$timezone = $resultado->timezone;
			//$website = $resultado->website ?? '';
			$working_hours = ordenardias($resultado);
			$lunes = $working_hours['lunes'];
			$martes = $working_hours['martes'];
			$miercoles = $working_hours['miercoles'];
			$jueves = $working_hours['jueves'];
			$viernes = $working_hours['viernes'];
			$sabado = $working_hours['sabado'];
			$domingo = $working_hours['domingo'];
			$data_id = $resultado->data_id;
			//$categoria = $resultado->category;
			$website = esc_url_raw($resultado->link) ?? ''; 
			$mapsid = $resultado->place_id;
			$link = '';
			$query = "SELECT * FROM $tabla where gmapsid = '$mapsid'"; // Si ya existe nos la saltamos...
			$querycheck = $wpdb->get_row($query);
			if (empty($querycheck))
			{
			if ($imagen != '')
				{
					$imagenurl = subir_imagen($imagen,$name,$autor);
				}
			else $imagenurl = '';
			$insercion = $wpdb->insert($tabla,array("OrganizationName"=>$name,"GMapsLink"=>$link,"ShareLink"=>$link,"SearchRequest"=>$categoria,"categoriapadre"=>$categoriapadre,"RateStars"=>$rating,"ReviewsTotalCount"=>$reviews,"OrganizationAddress"=>$full_address,
			"municipio"=>$city,"provincia"=>$provincia,"cp"=>$cp,"pais"=>$pais,"OrganizationWebsite"=>$website,"OrganizationPhoneNr"=>$phone,"OrganizationLatitude"=>$latitude,"OrganizationLongitude"=>$longitude,"OrganizationHeadPhotoURL"=>$imagenurl,
			"lunes"=>$lunes,"martes"=>$martes,"miercoles"=>$miercoles,"jueves"=>$jueves,"viernes"=>$viernes,"sabado"=>$sabado,"domingo"=>$domingo,"gmapsid"=>$mapsid,"keyword"=>$keyword,"escrapeo"=>$escrapeo));
	
			if ($insercion === false)
				{
				$error = $wpdb->last_error; 
				fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.$name.' '.__('No se pudo insertar la entrada.','nichecreator').' '.$error."\r\n");
				}
			}
			}
		}
		$pagina = $pagina + 1;
   		} while (isset($resultados->places_results));
   	} //VALUESERP
   	if ($herramienta == 'outscraper')
	{
	$resultados = outscraper($keyword,$pais,$idioma);
	if (empty($resultados))
	     $resultados = outscraper($keyword,$pais,$idioma);
	if (isset($resultados) && is_array($resultados))
	     {
		foreach ($resultados as $resultado)
		{
		$id = $resultado["place_id"];
		$name = $resultado["name"];
		$name = limpiar_y_capitalizar($name);
		$full_address = $resultado["full_address"];
		$city = normalizar($resultado["city"] ?? '');
		$city = ucwords($city);
		$provincia = normalizar($resultado["state"] ?? '');
		$provincia = ucwords(eliminarNumeros($provincia));
		$cp = $resultado["postal_code"] ?? '';
		if ($full_address == '' && $provincia == '' && $city == '' && $cp == '')
		     {
			continue;
		     }
		$categoriapadre = '';
		$categoria = '';
		if ($tipo == 'geo')
		     {
		     $categoriapadre = $provincia;
		     $categoria = $city;
		     }
	 	elseif ($tipo == 'mini-geo')
	             $categoria = $city;
		$phone = $resultado["phone"] ?? '';
		$latitude = $resultado["latitude"];
		$longitude = $resultado["longitude"];
		$reviews = $resultado["reviews"] ?? 0;
		$rating = $resultado["rating"] ?? '';
		$timezone = $resultado["time_zone"] ?? '';
		$website = esc_url_raw($resultado["site"]) ?? '';
		$link = $resultado["location_link"];
		$imagen = $resultado["photo"] ?? '';
		$start = substr($imagen,0,2);
		if ($start == '//')
			$imagen = str_replace($start,"https://",$imagen);
		
		$dias = [];
		if (isset($resultado["working_hours"]) && is_array($resultado["working_hours"]))
    			$dias = array_values($resultado["working_hours"]);
		$lunes = $dias[0] ?? '';
		$martes = $dias[1] ?? '';
		$miercoles = $dias[2] ?? '';
		$jueves = $dias[3] ?? '';
		$viernes = $dias[4] ?? '';
		$sabado = $dias[5] ?? '';
		$domingo = $dias[6] ?? '';
		$lunes = rtrim($lunes,",");
		$martes = rtrim($martes,",");
		$miercoles = rtrim($miercoles,",");
		$jueves = rtrim($jueves,",");
		$viernes = rtrim($viernes,",");
		$sabado = rtrim($sabado,",");
		$domingo = rtrim($domingo,",");
		
		$query = "SELECT * FROM $tabla where gmapsid = '$id'"; // Si ya existe nos la saltamos...
		$querycheck = $wpdb->get_row($query);
		if (empty($querycheck))
			{
			if ($imagen != '')
				{
				$imagenurl = subir_imagen($imagen,$name,$autor);
				}
			else $imagenurl = '';
			$insercion = $wpdb->insert($tabla,array("OrganizationName"=>$name,"GMapsLink"=>'',"ShareLink"=>$link,"SearchRequest"=>$categoria,"categoriapadre"=>$categoriapadre,"RateStars"=>$rating,"ReviewsTotalCount"=>$reviews,"OrganizationAddress"=>$full_address,
			"municipio"=>$city,"provincia"=>$provincia,"cp"=>$cp,"pais"=>$pais,"OrganizationWebsite"=>$website,"OrganizationPhoneNr"=>$phone,"OrganizationLatitude"=>$latitude,"OrganizationLongitude"=>$longitude,"OrganizationHeadPhotoURL"=>$imagenurl,
			"lunes"=>$lunes,"martes"=>$martes,"miercoles"=>$miercoles,"jueves"=>$jueves,"viernes"=>$viernes,"sabado"=>$sabado,"domingo"=>$domingo,"gmapsid"=>$id,"keyword"=>$keyword,"escrapeo"=>$escrapeo));
			if ($insercion === false)
				{
				$error = $wpdb->last_error; 
				fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.$name.' '.__('No se pudo insertar la entrada.','nichecreator').' '.$error."\r\n");
				}
			}
		}
	     }
	} // OUTSCRAPER
	
   	/*
   	if ($herramienta == 'quickscrape')
	{
	$resultados = quick_scrape($keyword,$pais,$idioma,$limite,$fichero);
	if (empty($resultados))
		$resultados = quick_scrape($keyword,$pais,$idioma,$limite,$fichero);
	foreach ($resultados as $resultado)
		{
		// Insertar entrada en tabla...
		$name = $resultado->name;
		$name = limpiar_y_capitalizar($name);
		$full_address = $resultado->full_address;
		$phone = $resultado->phone_number;
		$latitude = $resultado->latitude;
		$longitude = $resultado->longitude;
		$reviews = $resultado->review_count;
		$rating = $resultado->rating;
		$timezone = $resultado->timezone;
		$website = esc_url_raw($resultado->website);
		$link = $resultado->place_link;
		$mapsid = $resultado->place_id;
		$city = normalizar($resultado->city ?? '');
		$city = ucwords($city);
		$patternprovincia='/.*\d*\s(.*)$/i';
		$success = preg_match($patternprovincia, $full_address, $match);
		$provincia = $match[1];
		$provincia = normalizar($provincia ?? '');
		$provincia = ucwords(eliminarNumeros($provincia));
		$patterncp = '/(\d{4,})/i';
		$success = preg_match($patterncp, $full_address, $match);
		$cp = $match[1];
		if ($full_address == '' && $provincia == '' && $city == '' && $cp == '')
				continue;
		$categoriapadre = '';
			$categoria = '';
			if ($tipo == 'geo')
			{
			$categoriapadre = $provincia;
			$categoria = $city;
			}
			elseif ($tipo == 'mini-geo')
				$categoria = $city;
		//$country = getcountry($pais);
		$imagen = $resultado->photos[0]->src;
		$lunes = $resultado->working_hours->Monday[0].','.$resultado->working_hours->Monday[1];
		$martes = $resultado->working_hours->Tuesday[0].','.$resultado->working_hours->Tuesday[1];
		$miercoles = $resultado->working_hours->Wednesday[0].','.$resultado->working_hours->Wednesday[1];
		$jueves = $resultado->working_hours->Thursday[0].','.$resultado->working_hours->Thursday[1];
		$viernes = $resultado->working_hours->Friday[0].','.$resultado->working_hours->Friday[1];
		$sabado = $resultado->working_hours->Saturday[0].','.$resultado->working_hours->Saturday[1];
		$domingo = $resultado->working_hours->Sunday[0].','.$resultado->working_hours->Sunday[1];
		$lunes = rtrim($lunes,",");
		$martes = rtrim($martes,",");
		$miercoles = rtrim($miercoles,",");
		$jueves = rtrim($jueves,",");
		$viernes = rtrim($viernes,",");
		$sabado = rtrim($sabado,",");
		$domingo = rtrim($domingo,",");
		$query = "SELECT * FROM $tabla where gmapsid = '$mapsid'"; // Si ya existe nos la saltamos...
			$querycheck = $wpdb->get_row($query);
			if (empty($querycheck))
			{
		$insercion = $wpdb->insert($tabla,array("OrganizationName"=>$name,"GMapsLink"=>$link,"ShareLink"=>$link,"SearchRequest"=>$categoria,"categoriapadre"=>$categoriapadre,"RateStars"=>$rating,"ReviewsTotalCount"=>$reviews,"OrganizationAddress"=>$full_address,
		"municipio"=>$city,"provincia"=>$provincia,"cp"=>$cp,"pais"=>$pais,"OrganizationWebsite"=>$website,"OrganizationPhoneNr"=>$phone,"OrganizationLatitude"=>$latitude,"OrganizationLongitude"=>$longitude,"OrganizationHeadPhotoURL"=>$imagen,
		"lunes"=>$lunes,"martes"=>$martes,"miercoles"=>$miercoles,"jueves"=>$jueves,"viernes"=>$viernes,"sabado"=>$sabado,"domingo"=>$domingo,"gmapsid"=>$mapsid,"keyword"=>$keyword,"escrapeo"=>$escrapeo));
			if ($insercion === false)
				{
				$error = $wpdb->last_error; 
				fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.$name.' '.__('No se pudo insertar la entrada.','nichecreator').' '.$error."\r\n");
				}
			}
		}
	}
	*/
   }
fclose($fichero);
}


function google_places_search( $query = '',$pais,$idioma,$nextpage = '')
{
$fich = plugin_dir_path(__FILE__)."../logs/scrape.log";
$fichero = fopen($fich,"a");
//$query2 = rawurlencode($query);
$API_KEY = get_option('nichecreator_apiplaces');
$fields="places.id,places.displayName,places.formattedAddress,places.websiteUri,places.nationalPhoneNumber,places.location,places.userRatingCount,places.rating,places.googleMapsUri,places.photos,places.regularOpeningHours,places.regularSecondaryOpeningHours,places.addressComponents,nextPageToken";
$url = "https://places.googleapis.com/v1/places:searchText";
$header  = [
	"Content-Type: application/json",
	"X-Goog-Api-Key: $API_KEY",
	"X-Goog-FieldMask: $fields"
	];
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$post_fields = array("textQuery" => $query,"languageCode"=>$idioma,"regionCode"=>$pais,"pageToken"=>$nextpage); //minRating
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
$result = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_errno($ch);
if ($curlError) {
	$curlErrorMsg = curl_error($ch);
	if ($curlError == CURLE_COULDNT_CONNECT) {
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$query.' '.__('No se pudo establecer una conexión con Places API. Verifica tu conexión a internet.','nichecreator')."\r\n");
			return '';
		} elseif ($curlError == CURLE_OPERATION_TIMEDOUT) {
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$query.' '.__('La solicitud a Places API tomó demasiado tiempo. Intenta de nuevo en unos minutos.','nichecreator')."\r\n");
			return '';
		} else {
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$query.' '.__('Error cURL','nichecreator'));
			echo 'Error cURL';
			return '';
		}	
		}
	curl_close($ch);
	if (!$result) 
	{                        
	fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$query.' '.__('La respuesta de Places API está vacía.','nichecreator')."\r\n");
	return '';
	}						
//	fclose($fichero);
	$response = json_decode($result);
	if (isset($response->error)) {
		$mensaje = $response->error->message ?? 'Error desconocido';
		fwrite($fichero, current_datetime()->format('Y-m-d H:i:s') . " $query - Error API: $mensaje\n");
		return '';
	}
if ($httpCode !== 200) {
    fwrite($fichero, current_datetime()->format('Y-m-d H:i:s') . " $query - Código HTTP inesperado: $httpCode\n");
}
    return $response;
}



function get_direccion($direcciones)
{
$resultado = array();
foreach ($direcciones as $direccion)
	{
	if ($direccion->types[0] == 'locality') // Municipio
		$resultado["municipio"] = $direccion->longText;
	if ($direccion->types[0] == 'administrative_area_level_2') // Provincia
		$resultado["provincia"] = $direccion->longText;
	if ($direccion->types[0] == 'postal_code') // Codigo Postal
		$resultado["cp"] = $direccion->longText;
	if ($direccion->types[0] == 'sublocality_level_1') // Barrio Distrito
		$resultado["barrio"] = $direccion->longText;
	if ($direccion->types[0] == 'administrative_area_level_1') // Comunidad Autónoma
		$resultado["ccaa"] = $direccion->longText;
	if ($direccion->types[0] == 'country') // País
		$resultado["pais"] = $direccion->longText;
	}
return $resultado;
}





/*
////////////////////////////////////////
Documentation for API Token: 
Endpoint: https://app.quickscrape.net/api/v1/search Méthod: POST
Params
{
'api_token' => 'required',
'keyword' => 'required',
'latitude' => 'nullable',
'longitude' => 'nullable',
'country_code' => 'required', // (es, us, fr, ...)
'limit' => 'nullable|numeric', // max 500
'lang' => 'nullable|string', // Default 'en'
}

Headers
{
'Accept' => 'application/json',
'Content-Type' => 'application/json',
} 
/////////////////////////////////////////////
*/


function quick_scrape($keyword,$pais,$language,$limit,$fichero)
{
//	$fich = plugin_dir_path(__FILE__)."../logs/scrape.log";
//	$fichero = fopen($fich,"a");
//    error_reporting(0);
	$apikey = get_option('nichecreator_quickscrape');
	$url = 'https://app.quickscrape.net/api/v1/search';
	$header  = [
			'Content-Type: application/json',
			'Accept: aaplication/json'
		];
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	$post_fields = array(
		"api_token" => $apikey,
		"keyword" => $keyword,
		"language" => $language,  
		"country_code" => $pais,
		"limit" => $limit		
	);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
	$result = curl_exec($ch);
	$curlError = curl_errno($ch);
	if ($curlError) {
		$curlErrorMsg = curl_error($ch);
	if ($curlError == CURLE_COULDNT_CONNECT) {
			//throw new Exception('No se pudo establecer una conexión con OpenAI. Verifica tu conexión a internet.');
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('No se pudo establecer una conexión con QuickScrape. Verifica tu conexión a internet.','nichecreator'));
			return '';
		} elseif ($curlError == CURLE_OPERATION_TIMEDOUT) {
			//throw new Exception('La solicitud a OpenAI tomó demasiado tiempo. Puede que OpenAI esté saturado o que haya un problema de conexión a Internet. Intenta de nuevo en unso minutos.');
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('La solicitud a QuickScrape tomó demasiado tiempo. Intenta de nuevo en unos minutos.','nichecreator'));
			return '';
		} else {
			//throw new Exception('Error cURL: ' . $curlErrorMsg);
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('Error cURL','nichecreator'));
			return '';
		}			}
	if (!$result) 
	{                        
	//	throw new Exception('La respuesta de OpenAI está vacía. Por favor, intenta de nuevo.');
	fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('La respuesta de QuickScrape está vacía.','nichecreator'));
	return '';
	}						
	$response = json_decode($result);
//	fclose($fichero);
    return $response->data;
}

function normalizar_hl_para_valueserp($hl,$pais) {
    if (strtolower($hl) === 'zh' && $pais === 'TW') {
        return 'zh-tw'; // o 'zh-CN', según tu caso de uso
    }
    elseif (strtolower($hl) === 'zh' && $pais === 'CN') {
        return 'zh-cn'; // o 'zh-CN', según tu caso de uso
    }
    return $hl;
}


function value_serp($keyword,$pais,$language,$pagina)
{
$fich = plugin_dir_path(__FILE__)."../logs/valueserp.log";
$fichero = fopen($fich,"a");
$language = normalizar_hl_para_valueserp($language,$pais);
//error_reporting(0);
# set up the request parameters
$apikey = get_option('nichecreator_valueserp');
$queryParams = [
	 'api_key' => $apikey,
	 'search_type' => 'places',
	 'q' => $keyword, 
	 'location' => 'location=lat:43.437677,lon:-3.8392765,zoom:15',
	 //'location' => 'location=lat:18.4655,lon:-66.1057,zoom:15',
	 'gl' => $pais,
	 'hl' => $language,
	 'page' => $pagina
		];
$queryString = array_map(
   		 fn($key, $value) => $key . '=' . str_replace('%20', '+', rawurlencode($value)),
    		array_keys($queryParams),
    		array_values($queryParams)
	);
$queryString = implode('&', $queryString);
$url = 'https://api.valueserp.com/search?' . $queryString;
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
//curl_setopt($ch, CURLOPT_HTTPHEADER, ['User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3']);
# the following options are required if you're using an outdated OpenSSL version
# more details: https://www.openssl.org/blog/blog/2021/09/13/LetsEncryptRootCertExpire/
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//curl_setopt($ch, CURLOPT_ENCODING, 'gzip');
curl_setopt($ch, CURLOPT_TIMEOUT, 180);
$api_result = curl_exec($ch);
//{"request_info":{"success":false,"message":"Supplied api_key is not valid"}}
$curlError = curl_errno($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	if ($curlError) {
		$curlErrorMsg = curl_error($ch);
	if ($curlError == CURLE_COULDNT_CONNECT) {
		//throw new Exception('No se pudo establecer una conexión con OpenAI. Verifica tu conexión a internet.');
		fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('No se pudo establecer una conexión con ValueSERP. Verifica tu conexión a internet.','nichecreator'));
			return '';
		} elseif ($curlError == CURLE_OPERATION_TIMEDOUT) {
			//throw new Exception('La solicitud a OpenAI tomó demasiado tiempo. Puede que OpenAI esté saturado o que haya un problema de conexión a Internet. Intenta de nuevo en unso minutos.');
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('La solicitud a ValueSERP tomó demasiado tiempo. Intenta de nuevo en unos minutos.','nichecreator'));
			return '';
		} else {
			//throw new Exception('Error cURL: ' . $curlErrorMsg);
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('Error cURL','nichecreator'));
			return '';
		}			
		}
curl_close($ch);
	if (!$api_result) 
		{                        
		//	throw new Exception('La respuesta de OpenAI está vacía. Por favor, intenta de nuevo.');
		fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('La respuesta de ValueSERP está vacía.','nichecreator'));
		return '';
		}
$response = json_decode($api_result);
if (isset($response->request_info) && !$response->request_info->success) {
    $mensaje = $response->request_info->message ?? 'Error desconocido';
    fwrite($fichero, current_datetime()->format('Y-m-d H:i:s') . " $keyword - Error API: $mensaje\n");
    return '';
}
if ($httpCode !== 200) {
    fwrite($fichero, current_datetime()->format('Y-m-d H:i:s') . " $keyword - Código HTTP inesperado: $httpCode\n");
}
# print the JSON response from VALUE SERP
//	echo $api_result.'<br/>';			
	
	fclose($fichero);
        return $response;
}

function outscraper(string $keyword, string $pais, string $language, int $limit = 500): array {
    $fich = plugin_dir_path(__FILE__)."../logs/outscraper.log";
    $fichero = fopen($fich,"a");
    $base = 'https://api.app.outscraper.com/maps/search-v3';
    $query = trim($keyword . (stripos($keyword, $pais) === false ? " $pais" : ''));
    $params = http_build_query(['query' => $query,'limit' => $limit,'language' => $language,'region' => $pais,'async' => 'false']);
    $url = "$base?$params";
    $apikey = get_option('nichecreator_outscraper');
    $headers = [
        "X-API-KEY: $apikey",
        "Content-Type: application/json",
        "Accept: application/json"
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    // Opcional: timeout razonable
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    $response = curl_exec($ch);
	$curlError = curl_errno($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	if ($curlError) {
		$curlErrorMsg = curl_error($ch);
		if ($curlError == CURLE_COULDNT_CONNECT) {
		//throw new Exception('No se pudo establecer una conexión con OpenAI. Verifica tu conexión a internet.');
		fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('No se pudo establecer una conexión con OutScraper. Verifica tu conexión a internet.','nichecreator')."\r\n");
			return [];
		} elseif ($curlError == CURLE_OPERATION_TIMEDOUT) {
			//throw new Exception('La solicitud a OpenAI tomó demasiado tiempo. Puede que OpenAI esté saturado o que haya un problema de conexión a Internet. Intenta de nuevo en unso minutos.');
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('La solicitud a OutScraper tomó demasiado tiempo. Intenta de nuevo en unos minutos.','nichecreator')."\r\n");
			return [];
		} else {
			//throw new Exception('Error cURL: ' . $curlErrorMsg);
			fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('Error cURL','nichecreator')."\r\n");
			return [];
		}			
		}
    curl_close($ch);
	if (!$response) 
		{                        
		//	throw new Exception('La respuesta de OpenAI está vacía. Por favor, intenta de nuevo.');
		fwrite($fichero,current_datetime()->format('Y-m-d H:i:s').' '.$keyword.' '.__('La respuesta de Outscraper está vacía.','nichecreator')."\r\n");
		return [];
		}
   if ($httpcode !== 200) {
    fwrite($fichero, current_datetime()->format('Y-m-d H:i:s') . " $keyword - Código HTTP inesperado: $httpcode\n");
	}

    $data = json_decode($response, true);
	if (isset($data["status"]) && $data["status"] != 'Success') 
	{	
    $mensaje = $data["status"] ?? 'Error desconocido';
    fwrite($fichero, current_datetime()->format('Y-m-d H:i:s') . " $keyword - Error API: $mensaje\n");
    return [];
	}
	$places = $data['data'][0] ?? [];
    if (!is_array($places)) {
        fwrite($fichero, current_datetime()->format('Y-m-d H:i:s') . " Error: No se ha devuelto valores.\n");
    }

    // Según docs, la respuesta es un array de arrays: cada query → lista de lugares :contentReference[oaicite:1]{index=1}
	fclose($fichero);
    return $places;
}


//////////////////////////////////////////////////////////
//////////////////// ORDENAR DIAS /////////////////////
///////////////////////////////////////////////////////////
function ordenardias($data)
{
    // Diccionario multilingüe: día → día en español (sin tildes)
    $dayTranslations = [
        // Español
        'lunes'=>'lunes','martes'=>'martes','miércoles'=>'miercoles','miercoles'=>'miercoles',
        'jueves'=>'jueves','viernes'=>'viernes','sábado'=>'sabado','sabado'=>'sabado','domingo'=>'domingo',
        // Inglés
        'monday'=>'lunes','tuesday'=>'martes','wednesday'=>'miercoles',
        'thursday'=>'jueves','friday'=>'viernes','saturday'=>'sabado','sunday'=>'domingo',
        // Francés
        'lundi'=>'lunes','mardi'=>'martes','mercredi'=>'miercoles','jeudi'=>'jueves',
        'vendredi'=>'viernes','samedi'=>'sabado','dimanche'=>'domingo',
        // Alemán
        'montag'=>'lunes','dienstag'=>'martes','mittwoch'=>'miercoles',
        'donnerstag'=>'jueves','freitag'=>'viernes','samstag'=>'sabado','sonntag'=>'domingo',
        // Italiano
        'lunedi'=>'lunes','lunedì'=>'lunes','martedi'=>'martes','martedì'=>'martes',
        'mercoledi'=>'miercoles','mercoledì'=>'miercoles','giovedì'=>'jueves','giovedi'=>'jueves',
        'venerdì'=>'viernes','venerdi'=>'viernes','sabato'=>'sabado','domenica'=>'domingo',
        // Portugués
        'segunda-feira'=>'lunes','terça-feira'=>'martes','terca-feira'=>'martes',
        'quarta-feira'=>'miercoles','quinta-feira'=>'jueves','sexta-feira'=>'viernes',
        'sábado'=>'sabado','sabado'=>'sabado','domingo'=>'domingo',
        // Polaco
        'poniedziałek'=>'lunes','poniedzialek'=>'lunes','wtorek'=>'martes','środa'=>'miercoles',
        'sroda'=>'miercoles','czwartek'=>'jueves','piątek'=>'viernes','piatek'=>'viernes',
        'sobota'=>'sabado','niedziela'=>'domingo',
        // Sueco
        'måndag'=>'lunes','mandag'=>'lunes','tisdag'=>'martes','onsdag'=>'miercoles',
        'torsdag'=>'jueves','fredag'=>'viernes','lördag'=>'sabado','lordag'=>'sabado','söndag'=>'domingo',
        // Holandés
        'maandag'=>'lunes','dinsdag'=>'martes','woensdag'=>'miercoles',
        'donderdag'=>'jueves','vrijdag'=>'viernes','zaterdag'=>'sabado','zondag'=>'domingo',
        // Danés / Noruego
        'mandag'=>'lunes','tirsdag'=>'martes','onsdag'=>'miercoles',
        'torsdag'=>'jueves','fredag'=>'viernes','lørdag'=>'sabado','lordag'=>'sabado','søndag'=>'domingo',
        // Finés
        'maanantai'=>'lunes','tiistai'=>'martes','keskiviikko'=>'miercoles','torstai'=>'jueves',
        'perjantai'=>'viernes','lauantai'=>'sabado','sunnuntai'=>'domingo',
        // Ruso (transliterado y cirílico)
        'понедельник'=>'lunes','ponedelnik'=>'lunes','вторник'=>'martes','vtornik'=>'martes',
        'среда'=>'miercoles','sreda'=>'miercoles','четверг'=>'jueves','chetverg'=>'jueves',
        'пятница'=>'viernes','pyatnitsa'=>'viernes','суббота'=>'sabado','subbota'=>'sabado',
        'воскресенье'=>'domingo','voskresenye'=>'domingo',
        // Griego (transliterado)
        'δευτέρα'=>'lunes','deutera'=>'lunes','τήρη'=>'martes','triti'=>'martes','terti'=>'martes',
        'τετάρτη'=>'miercoles','tetarti'=>'miercoles','πέμπτη'=>'jueves','pempti'=>'jueves',
        'παρασκευή'=>'viernes','paraskevi'=>'viernes','σάββατο'=>'sabado','savvato'=>'sabado',
        'κυριακή'=>'domingo','kyriaki'=>'domingo'
    ];
    // Días de la semana en orden correcto
    $daysOfWeek = ['lunes', 'martes', 'miercoles', 'jueves', 'viernes', 'sabado', 'domingo'];

    // Inicializamos el array de horarios
    $opening_hours = array_fill_keys($daysOfWeek, '');

    if (isset($data->opening_hours->per_day) && is_iterable($data->opening_hours->per_day)) {
        foreach ($data->opening_hours->per_day as $opening) {
            $dayName = mb_strtolower(trim($opening->name));
            $normalized = $dayTranslations[$dayName] ?? null;

            if ($normalized && in_array($normalized, $daysOfWeek)) {
                $opening_hours[$normalized] = $opening->value;
            }
        }
    }

    return $opening_hours;
}






////////////////////////////////////////////////////////////////////////////
//////////// VERIFICAR CSV COMAS /////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

function verificar_CSVcoma($rutaArchivo, $delimitador = ',') {
    // Verifica que el archivo existe y es legible
    if (!file_exists($rutaArchivo) || !is_readable($rutaArchivo)) {
        return false;
    }

    // Abre el archivo en modo lectura
    $handle = fopen($rutaArchivo, 'r');
    if (!$handle) return false;

    $esCSV = false;

    // Lee las primeras líneas (por ejemplo, las primeras 5)
    $lineasAComprobar = 1;
    $lineaActual = 0;

    while (($linea = fgets($handle)) !== false && $lineaActual < $lineasAComprobar) {
        $lineaActual++;
	
        // Cuenta cuántas comas hay en la línea
        $partes = str_getcsv($linea, $delimitador);
        // Si hay más de una columna, asumimos que es CSV con comas
        if (count($partes) > 1) {
            $esCSV = true;
            break;
        }
    }
    fclose($handle);
    return $esCSV;
}

////////////////////////////////////////////////////////////////
//////////// ELIMINAR NUMEROS EN STRING (PROVINCIAS)
////////////////////////////////////////////////////////////////
function eliminarNumeros($cadena) {
    // Verifica si la cadena contiene números
    if (preg_match('/\d/', $cadena)) {
        // Elimina todos los números de la cadena
        return preg_replace('/\d+/', '', $cadena);
    }
    // Si no contiene números, devuelve la cadena tal cual
    return $cadena;
}

//////////////////////////////////////////////////////////
///////// FUNCION SUBIDA DE IMAGENES /////////////////////
//////////////////////////////////////////////////////////
	//////// SUBIDA DE IMAGENES SI PROCEDE ////////////////
function subir_imagen($imagen,$nombre,$autor)
{
		$url = site_url();
		$parse = parse_url($url);
		$mydomain = $parse['host'];
		$urlOriginal = $imagen ?? '';
		if (is_string($urlOriginal) && trim($urlOriginal) !== '') {
    			// Si no empieza con http o https, le añadimos http://
    			if (!preg_match('#^https?://#i', $urlOriginal)) {
        		$urlOriginal = 'http://' . $urlOriginal;
    			}
		 $parsedUrl = parse_url($urlOriginal);
		 if (is_array($parsedUrl) && isset($parsedUrl['host'])) {
       			 $dominio = $parsedUrl['host'];
    			}
		else $dominio = '';
		}
			if ($mydomain != $dominio)
			{
			$fotoid = upload_file_url($imagen,$nombre,$autor,'noia');
				if ($fotoid > 0 )
				{
				update_post_meta( $fotoid, 'nichecreator_imagen', 'X' );
				$fotourl = wp_get_attachment_url($fotoid);
				// Actualizar tabla de entrdas con la URL de la imagen.....
				//$entrada->OrganizationHeadPhotoURL = $fotourl;
				//$actualizacion = $wpdb->update($tabla,array("OrganizationHeadPhotoURL"=>$fotourl),array("id"=>$entrada->id));
				return $fotourl;
				}
				elseif ($fotoid === false)
					{
					//$actualizacion = $wpdb->update($tabla,array("OrganizationHeadPhotoURL"=>''),array("id"=>$entrada->id));
					//$entrada->OrganizationHeadPhotoURL = '';
					return '';
					}
			}
}

