/*
Author: DubleyNguyen
Author URI: http://villatheme.com
Copyright 2021 villatheme.com. All rights reserved.
*/


jQuery(document).ready(function ($) {
    "use strict";
    /*Copy shortcode when click*/
    $('.vi-ui.dropdown').dropdown();
    $(document).on('click', '.viwcpf_shortcode_show', function () {
        let $this = $(this),
            this_copied_text = $this.parent().find('.viwcpf_copied_tooltip');
        /*Copy event*/
        $this.select();
        document.execCommand('copy');
        /*Show tooltip and auto hide it */
        this_copied_text.css('visibility', 'visible');
        setTimeout(function () {
            this_copied_text.css('visibility', 'hidden');
        }, 1000);
    });

    let width_content_sortable = $('#sortable_block_selected').width() - 10;
    $("#sortable_block_selected").sortable({
        revert: true,
        placeholder: "sortable-placeholder",
        stop: function (event, ui) {
            if (!ui.item.data('tag') && !ui.item.data('handle')) {

                ui.item.data('tag', true);
                if (!ui.item.hasClass('block_selected')) {
                    ui.item.find('.wrapp_btn').append('<a href="#" class="vi-ui del_block icon red button mini compact"> <i class="minus icon"></i></a>');
                    ui.item.find('.add_block').remove();
                    ui.item.addClass('block_selected');
                }
            }
        },
        sort: function (event, ui) {
            ui.item.css('width', width_content_sortable);
        },
        update: function (event, ui) {
            let new_arr_blocks_selected = [],
                $this = ui.item,
                this_block_id = $this.attr('data-block_id'),
                val_blocks_selected = $('#viwcpf_blocks_selected').val();

            if (val_blocks_selected === '') {
                $('#viwcpf_blocks_selected').val(this_block_id);
            } else {

                /*Update value to array*/

                $("#sortable_block_selected .item_block").each(function (i, el) {
                    var p = $(el).attr('data-block_id').toLowerCase();
                    new_arr_blocks_selected.push(p);
                });
                /**/
                let new_val_blocks_selected = new_arr_blocks_selected.toString();

                /*Update new value to input*/
                $('#viwcpf_blocks_selected').val(new_val_blocks_selected);

            }
        }
    });



    $(".item_block").disableSelection();

    $(document).on('click', '.del_block', function () {
        let $this = $(this),
            this_item_block = $this.closest('.item_block'),
            this_item_name = this_item_block.attr('data-block_name'),
            this_item_id = this_item_block.attr('data-block_id'),
            this_item_url = this_item_block.attr('data-block_url');

        $("#dragable_block_select").append(`
            <div class="vi-ui segment item_block add_block" data-block_id="${this_item_id}" data-block_name="${this_item_name}" data-block_url="${this_item_url}">
                <h4>${this_item_name}</h4>
                <div class="wrapp_btn">
                    <a href="${this_item_url}" class="vi-ui edit_block icon blue button mini compact"> <i class="edit icon"></i></a>
                </div>
            </div>`);

        /*Update value when item remove*/
        let val_blocks_selected = $('#viwcpf_blocks_selected').val(),
            arr_blocks_selected = val_blocks_selected.split(',');
        if (val_blocks_selected !== '') {
            /*delete duplicate elements in array*/
            arr_blocks_selected = _viwcpf_unique_arr(arr_blocks_selected);
            /*Update value to array*/
            if (jQuery.inArray(this_item_id, arr_blocks_selected) !== -1) {

                let index_remove = jQuery.inArray(this_item_id, arr_blocks_selected);

                arr_blocks_selected.splice(index_remove, 1);

                let new_val_blocks_selected = arr_blocks_selected.toString();
                /*Update new value to input*/
                $('#viwcpf_blocks_selected').val(new_val_blocks_selected);
            }

        }
        this_item_block.remove();
        return false;
    });


    $(document).on('click', '.add_block', function (e) {

        if (e.target !== e.currentTarget) return;


        let $this = $(this),
            this_item_block = $this,
            this_item_name = this_item_block.attr('data-block_name'),
            this_item_id = this_item_block.attr('data-block_id'),
            this_item_url = this_item_block.attr('data-block_url');

        $("#sortable_block_selected").append(`
            <div class="vi-ui segment item_block block_selected" data-block_id="${this_item_id}" data-block_name="${this_item_name}" data-block_url="${this_item_url}">
                <h4>${this_item_name}</h4>
                <div class="wrapp_btn">
                    <a href="${this_item_url}" class="vi-ui edit_block icon blue button mini compact"> <i class="edit icon"></i></a>
                    <a href="#" class="vi-ui del_block icon red button mini compact"> <i class="minus icon"></i></a>
                </div>
            </div>`);
        $("#sortable_block_selected").sortable('refresh');
        /*Update value when item remove*/
        let val_blocks_selected = $('#viwcpf_blocks_selected').val();
        let arr_blocks_selected = [];
        if (val_blocks_selected !== '') {
            arr_blocks_selected = val_blocks_selected.split(',');
        }
        /*delete duplicate elements in array*/
        arr_blocks_selected = _viwcpf_unique_arr(arr_blocks_selected);

        /*Update value to array*/
        if (jQuery.inArray(this_item_id, arr_blocks_selected) == -1) {

            arr_blocks_selected.push(this_item_id);

            let new_val_blocks_selected = arr_blocks_selected.toString();
            /*Update new value to input*/
            $('#viwcpf_blocks_selected').val(new_val_blocks_selected);
        }
        this_item_block.remove();
        return false;
    });


    _load_select2($('.viwcpf-display_conditions_archive_id'));

    $(document).on('change', '.viwcpf-display_conditions_archive select', function () {
        let $this = $(this),
            $this_val = $(this).val(),
            $this_closet = $this.closest('.condition_item'),
            $wrap_archive_id = $this_closet.find('.option_archive_id');

        let $this_archive_id_type_show = $wrap_archive_id.attr('data-type_show'),
            arr_archive_id_type_show = $this_archive_id_type_show.split(",");

        if (
            (jQuery.inArray($this_val, arr_archive_id_type_show) !== -1)
        ) {
            $wrap_archive_id.removeClass('hidden');
        } else {
            $wrap_archive_id.addClass('hidden');
        }
    });

    $(document).on('click', '.add_row_condition', function () {
        let $this_clone = $(`
            <div class="vi-ui field condition_item">
                <div class="item_column type">
                    <select class="vi-ui dropdown fluid viwcpf_filter_block_select viwcpf-display_conditions_type" name="viwcpf-display_conditions[0][type]">
                        <option value="include">INCLUDE</option>
                        <option value="exclude">EXCLUDE</option>
                    </select>
                </div>
                <div class="item_column archive">
                    <select class="vi-ui dropdown fluid viwcpf_filter_block_select viwcpf-display_conditions_archive" name="viwcpf-display_conditions[0][archive]">
                        <option value="all">All Product Archives</option>
                        <option value="product_search">Search results</option>
                        <option value="shop_page">Shop Page</option>
                        <option value="product_cat">Product Categories</option>
                        <option value="product_tag">Product Tags</option>
                    </select>
                </div>
                <div class="item_column option_archive_id hidden" data-type_show="product_cat,product_tag">
                    <select class="viwcpf-display_conditions_archive_id select2-hidden-accessible" name="viwcpf-display_conditions[0][archive_id][]" tabindex="-1" aria-hidden="true" multiple="multiple"></select>
                </div>
                <div class="item_column action_btn">
                    <div class="wrap_add_del_btn">
                        <a href="#" class="vi-ui add_row_condition icon green button mini compact"> <i class="plus icon"></i></a>
                        <a href="#" class="vi-ui del_row_condition icon red button mini compact"> <i class="minus icon"></i></a>
                    </div>
                </div>
            </div>
            `);

        _load_select2($this_clone.find('.viwcpf-display_conditions_archive_id'));

        $('#conditions_list').append($this_clone);
        _check_condition_input($this_clone.find('.viwcpf-display_conditions_archive select'));
        _load_name_row_duplicate($('#conditions_list'));
        $('.vi-ui.dropdown').dropdown();
        return false;
    });

    $(document).on('click', '.del_row_condition', function () {
        let $this = $(this),
            $this_val = $(this).val(),
            $this_closet = $this.closest('.condition_item');
        if (
            $('#conditions_list .condition_item').length > 1
        ) {
            $this_closet.remove();
            _load_name_row_duplicate($('#conditions_list'));
        } else {
            alert('Unable to delete row');
        }
        return false;
    });


    $(document).on('change', 'input[type="radio"],input[type="checkbox"], select', function () {
        _check_condition_input($(this));
    });

    $(document).on('click', '.refresh_blocks_filter', function () {
        let $this = $(this),
            exclude_str_id = $('#viwcpf_blocks_selected').val();
        $this.addClass('loading');
        $('#dragable_block_select').addClass('disabled');
        $.ajax({
            url: viwcpf_ajax.ajax,
            method: "POST",
            data: {
                exclude_str_id: exclude_str_id,
                action: 'viwcpf_refresh_block_filter'
            },
            dataType: "json"
        }).done(function (respon) {
            $('#dragable_block_select').html(respon).removeClass('disabled');

            $this.removeClass('loading');
        });

        return false;
    });

    /*
   Function check condition and update field.
   @param selector: $(this) of field
   @use : attribute add to field hide :    data-select="" -> Name of field condition
                                           data-typeshow="" -> value of field condition want display
   version:1.0.0
   */
    function _check_condition_input(selectors) {
        let $value = selectors.val(),
            $name = selectors.attr('name'),
            $selectors = selectors.attr('id'),
            $type = '';

        if (selectors.is("select")) {
            $type = 'select';
        } else {
            $type = selectors.attr('type');
        }
        let option_select = $('.option_select');

        switch ($type) {
            case 'checkbox':
                $value = selectors.is(':checked').toString();

                if ($value === 'true') {

                    option_select.each(function () {
                        let $this = $(this),
                            this_select = $this.attr('data-select'),
                            this_type_show = $this.attr('data-type_show'),
                            this_array_type_show = this_type_show.split(",");

                        if (
                            (this_select === $name) &&
                            (jQuery.inArray($value, this_array_type_show) !== -1)
                        ) {
                            $this.removeClass('hidden');
                        }
                    });

                } else {
                    option_select.each(function () {
                        let $this = $(this),
                            this_select = $this.attr('data-select');
                        if (this_select === $name) {
                            $this.addClass('hidden');
                        }
                    });
                }
                break;
            case 'radio':
                option_select.each(function () {
                    let $this = $(this),
                        this_select = $this.attr('data-select'),
                        this_type_show = $this.attr('data-type_show'),
                        this_array_type_show = this_type_show.split(",");
                    if (this_select === $name) {
                        $this.addClass('hidden');
                    }
                    if (
                        (this_select === $name) &&
                        (jQuery.inArray($value, this_array_type_show) !== -1)
                    ) {
                        $this.removeClass('hidden');
                    }
                });
                break;
            case 'select':
                option_select.each(function () {
                    let $this = $(this),
                        this_select = $this.attr('data-select'),
                        this_type_show = $this.attr('data-type_show'),
                        this_array_type_show = this_type_show.split(",");

                    if (this_select === $name) {
                        $this.addClass('hidden');
                    }
                    if (
                        (this_select === $name) &&
                        (jQuery.inArray($value, this_array_type_show) !== -1)
                    ) {
                        $this.removeClass('hidden');
                    }
                });
                break;
            default:
                break;

        }

    }

    /*Function delete duplicate elements in array */
    function _viwcpf_unique_arr(arr) {
        let newArr = [];
        for (let i = 0; i < arr.length; i++) {
            if (newArr.indexOf(arr[i]) === -1) {
                newArr.push(arr[i])
            }
        }
        return newArr
    }

    function _load_name_row_duplicate(seletor) {
        let _this_wrap_loop = seletor.find('.condition_item');

        let i = 0;
        _this_wrap_loop.each(function () {
            $(this).find('.viwcpf-display_conditions_type').attr('name', 'viwcpf-display_conditions[' + i + '][type]');
            $(this).find('.viwcpf-display_conditions_archive').attr('name', 'viwcpf-display_conditions[' + i + '][archive]');
            $(this).find('.viwcpf-display_conditions_archive_id').attr('name', 'viwcpf-display_conditions[' + i + '][archive_id][]');
            i++;
        });
    }

    function _load_select2(selector) {
        selector.select2({
            // theme: "classic",
            minimumInputLength: 1,
            dropdownParent: selector.parent(),
            placeholder: 'All',
            closeOnSelect: false,
            scrollAfterSelect: false,
            ajax: {
                type: 'post',
                url: viwcpf_ajax.ajax,
                data: function (params) {
                    let query = {
                        keysearch: params.term,
                        tax_search: $(this).closest('.condition_item').find('.viwcpf-display_conditions_archive select').val(),
                        type: 'public',
                        action: 'viwcpf_search_term'
                    };
                    return query;
                },
                processResults: function (data) {
                    // Transforms the top-level key of the response object from 'items' to 'results'

                    return {
                        results: data
                    };

                    let newOption = new Option(data.text, data.id, false, false);

                    selector.append(newOption);
                }
            }
        });
    }
});
//load data by Filter For
jQuery(window).on('load', function ($) {
    "use strict";
    setTimeout(function () {

        let option_select = jQuery('.option_select');
        option_select.each(function () {
            let $this = jQuery(this),
                this_select = $this.attr('data-select');
            jQuery('input[name=' + this_select + '] , select[name=' + this_select + ']').trigger('change');
        });
        jQuery('.viwcpf-display_conditions_archive select').trigger('change');
    }, 100);

});