<?php

namespace PublishPress\FuturePro\Modules\Notifications;

use PublishPress\Future\Core\HookableInterface;
use PublishPress\Future\Framework\InitializableInterface;
use PublishPress\Future\Framework\WordPress\Models\CurrentUserModel;
use PublishPress\FuturePro\Modules\Notifications\Models\NotificationUserModel;

class Module implements InitializableInterface
{
    /**
     * @var HookableInterface
     */
    private $hooks;

    /**
     * @var CurrentUserModel
     */
    private $currentUserModel;

    /**
     * @var string
     */
    private $restApiV1BasePath;

    /**
     * @var string
     */
    private $pluginVersion;

    public function __construct(
        HookableInterface $hooksFacade,
        \Closure $currentUserModelFactory,
        string $restApiV1BasePath,
        string $pluginVersion
    ) {
        $this->hooks = $hooksFacade;
        $this->currentUserModel = $currentUserModelFactory();
        $this->restApiV1BasePath = $restApiV1BasePath;
        $this->pluginVersion = $pluginVersion;
    }

    public function initialize()
    {
        $this->initializeControllers();
    }

    private function initializeControllers()
    {
        $notificationUserModel = new NotificationUserModel();

        $controllers = [
            new Controllers\AdminNotifications(
                $this->pluginVersion,
                $this->restApiV1BasePath,
                $this->hooks,
                $notificationUserModel
            ),
            new Controllers\RestApiV1(
                $this->restApiV1BasePath,
                $this->hooks
            ),
        ];

        foreach ($controllers as $controller) {
            $controller->initialize();
        }
    }
}
