<?php

namespace PublishPress\FuturePro\Modules\Workflows;

use PublishPress\Future\Modules\Workflows\HooksAbstract as WorkflowsHooksAbstract;
use PublishPress\FuturePro\Modules\Notifications\HooksAbstract as NotificationsHooksAbstract;

abstract class HooksAbstract
{
    public const FILTER_UPDATE_METADATA = 'update_%s_metadata';

    public const FILTER_UPDATE_METADATA_BY_MID = 'update_%s_metadata_by_mid';

    public const ACTION_UPDATED_META = 'updated_%s_meta';

    public const ACTION_ADDED_META = 'added_%s_meta';

    public const ACTION_DELETED_META = 'deleted_%s_meta';

    public const FILTER_POST_AUTHOR_CHANGED = 'publishpressfuture_workflow_post_author_changed';

    public const FILTER_POST_ROW_ACTIONS = 'post_row_actions';

    public const FILTER_PAGE_ROW_ACTIONS = 'page_row_actions';

    public const ACTION_RUN_POST_ROW_ACTION = 'publishpressfuture_run_post_row_action';

    /**
     * @since 4.6.0
     */
    public const ACTION_MIGRATE_V040600_ON_NOTIFICATIONS = 'publishpressfuture_migrate_v040600_on_notifications';

    /**
     * @since 4.6.0
     */
    public const ACTION_MARKED_NOTIFICATION_AS_READ = NotificationsHooksAbstract::ACTION_MARKED_NOTIFICATION_AS_READ;

    /**
     * @since 4.6.0
     */
    public const ACTION_CREATED_NOTIFICATION = 'publishpressfuture_created_notification';

    public const ACTION_WORKFLOW_ENGINE_START = WorkflowsHooksAbstract::ACTION_WORKFLOW_ENGINE_START;

    /**
     * Represents steps that run asynchronously in response to external events.
     * Uses a new hook name since this is a new feature.
     *
     * @since 4.6.0
     */
    public const ACTION_EVENT_DRIVEN_STEP_EXECUTE = 'publishpressfuture_workflow_event_driven_execute_step';

    /**
     * @since 4.6.0
     */
    public const ACTION_MIGRATE_V040600_ON_EVENT_DRIVEN_ACTIONS =
        'publishpressfuture_migrate_v040600_on_event_driven_actions';

    /**
     * @since 4.6.0
     */
    public const ACTION_MIGRATE_V040600_ON_EVENT_DRIVEN_ACTIONS_LOG =
        'publishpressfuture_migrate_v040600_on_event_driven_actions_log';

    /**
     * @since 4.6.0
     */
    public const ACTION_DELETE_EXPIRED_DONE_ACTIONS = WorkflowsHooksAbstract::ACTION_DELETE_EXPIRED_DONE_ACTIONS;

    /**
     * @since 4.6.0
     */
    public const ACTION_WORKFLOW_TRIGGER_EXECUTED = WorkflowsHooksAbstract::ACTION_WORKFLOW_TRIGGER_EXECUTED;

    /**
     * @since 4.6.0
     */
    public const ACTION_MARKED_ALL_NOTIFICATIONS_AS_READ = 'publishpressfuture_marked_all_notifications_as_read';

    /**
     * @since 4.6.0
     */
    public const ACTION_EXECUTE_STEP = WorkflowsHooksAbstract::ACTION_EXECUTE_STEP;

    /**
     * @since 4.7.0
     */
    public const ACTION_EXECUTE_NOTIFICATION_OPTION = NotificationsHooksAbstract::ACTION_EXECUTE_NOTIFICATION_OPTION;

    /**
     * @since 4.7.0
     */
    public const ACTION_WORKFLOW_ENGINE_EXECUTE_EVENT_DRIVEN_STEP =
        'publishpressfuture_workflow_engine_execute_event_driven_step';
}
