<?php
/**
 * Filters out only queries generated by a function.
 *
 * @package lucatume\WPBrowser\Iterators\Filters
 */

namespace lucatume\WPBrowser\Iterators\Filters;

use Iterator;

/**
 * Class FunctionQueriesFilter
 *
 * @package lucatume\WPBrowser\Iterators\Filters
 */
class FunctionQueriesFilter extends QueriesCallerBasedKeepingFilterIterator
{
    /**
     * ClassMethodQueriesFilter constructor.
     *
     * @param Iterator<array{0: string, 1: float, 2: string, 3: float, 4?: array<int|string,mixed>}> $iterator
     * @param string            $function The function to filter queries by.
     */
    public function __construct(Iterator $iterator, $function)
    {
        parent::__construct($iterator);

        $this->needles = [
            $function
        ];
    }
}
