<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}



function pwbe_field( $pwbe_product, $column, $output_html = true ) {
    global $pw_bulk_edit;

    $field = $column['field'];
    $field_value = null;
    $input_type = $column['type'];
    $visibility = $column['visibility'];
    $readonly = '';

    if ( isset( $column['readonly'] ) && $column['readonly'] == 'true' ) {
        $readonly = 'pwbe-field-readonly';
    }

    // If this is an array field, then we want the first part of the array as the meta field name.
    if ( strpos( $field, '___' ) !== false ) {
        $array_name = substr( $field, 0, strpos( $field, '___' ) );
        $array_key = substr( $field, strpos( $field, '___' ) + 3 );

        if ( property_exists( $pwbe_product, $array_name ) ) {
            $array_value = apply_filters( 'pwbe_results_decode_array', maybe_unserialize( $pwbe_product->{$array_name} ), $field, $pwbe_product, $array_name ) ;

            if ( $array_name === '_downloadable_files' && is_array( $array_value ) ) {
                $index = substr( $array_key, 0, strpos( $array_key, '___' ) );
                $download_field = substr( $array_key, strpos( $array_key, '___' ) + 3 );
                $keys = array_keys( $array_value );

                if ( count( $array_value ) > $index && is_array( $array_value[ $keys[ $index ] ] ) ) {
                    if ( isset( $array_value[ $keys[ $index ] ][ $download_field ] ) ) {
                        $field_value = $array_value[ $keys[ $index ] ][ $download_field ];
                    }
                }

            } else {
                while ( strpos( $array_key, '___' ) !== false ) {
                    $array_name = substr( $array_key, 0, strpos( $array_key, '___' ) );
                    $array_key = substr( $array_key, strpos( $array_key, '___' ) + 3 );

                    if ( isset( $array_value[ $array_name ] ) ) {
                        $array_value = $array_value[ $array_name ];
                    }
                }

                if ( isset( $array_value[ $array_key ] ) ) {
                    $field_value = $array_value[ $array_key ];
                } else if ( empty( $array_key ) ) {
                    $field_value = $array_value;
                }
            }
        }
    } else if ( property_exists( $pwbe_product, $field ) ) {
        $field_value = $pwbe_product->{$field};
    }

    $display_value = $field_value;
    $additional_input_attributes = '';

    switch ( $input_type ) {
        case 'image':
        case 'images':
            if ( $field == '_thumbnail_id' ) {
                if ( isset( $pwbe_product->_thumbnail_id ) ) {
                    $display_value = $pw_bulk_edit->get_image_html( $pwbe_product->_thumbnail_id );
                } else {
                    $display_value = $pw_bulk_edit->get_image_html( 0 );
                }
            } else {
                $display_value = '';
                $images = explode( ',', $field_value );
                array_walk( $images, 'absint' );
                foreach ( $images as $image_id ) {
                    if ( !empty( $image_id ) ) {
                        $display_value .= $pw_bulk_edit->get_image_html( $image_id );
                    }
                }
                if ( empty( $display_value ) ) {
                    $display_value = 'n/a';
                }
            }
        break;

        case 'select':
            $select_options = PWBE_Select_Options::get();
            if ( is_array( $field_value ) ) {
                if ( count( $field_value ) > 0 ) {
                    $field_value = $field_value[0];
                } else {
                    $field_value = '';
                }
            }

            // Blank options with select2 are "placeholders" but for Tax Class blank = Standard so we swap it with a single space for the value.
            if ( '_tax_class' == $field && empty( $field_value ) ) {
                $field_value = ' ';
            }

            if ( isset( $select_options[$field][$field_value] ) && !empty( $select_options[$field][$field_value]['name'] ) ) {
                $display_value = htmlspecialchars( $select_options[$field][$field_value]['name'], ENT_QUOTES );
                $field_value = htmlspecialchars( $field_value, ENT_QUOTES );
            } else {
                $field_value = htmlspecialchars( $field_value, ENT_QUOTES );
                $display_value = 'n/a';
            }
        break;

        case 'multiselect':
            if ( !is_array( $field_value ) ) {
                if ( !empty( $field_value ) ) {
                    $field_value = maybe_unserialize( $field_value );
                }

                if ( !is_array( $field_value ) ) {
                    $field_value = array();
                }
            }

            $display_value = 'Edit (' . count( $field_value ) . ')';
            if ( $field_value && count( $field_value ) > 0 ) {
                $field_value = implode(',', $field_value);
            } else {
                $field_value = '';
            }
        break;

        case 'date':
            if ( !empty( $field_value ) ) {
                if ( function_exists( 'wc_string_to_datetime' ) ) {
                    $display_value = wc_string_to_datetime( date( 'c', $field_value ) )->date( 'Y-m-d' );
                } else {
                    $display_value = date_i18n( 'Y-m-d', $field_value, true );
                }
                $field_value = $display_value;
            } else {
                $display_value = 'n/a';
            }
            $additional_input_attributes = 'maxlength="10" pattern="[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])"';
        break;

        case 'currency':
            $field_value = wc_format_localized_price( $field_value );
            $display_value = wc_format_localized_price( $display_value );

            if ( $display_value === '' ) {
                $display_value = 'n/a';
            }
        break;

        case 'checkbox':
            if ( 'open' == $field_value || 'featured' == $field_value ) {
                $display_value = 'yes';
                $field_value = 'yes';
            } else if ( 'closed' == $field_value ) {
                $display_value = 'no';
                $field_value = 'no';
            }

            if ( !isset( $field_value ) || empty( $field_value ) ) {
                $display_value = 'no';
                $field_value = 'no';
            }

            if ( isset( $column['checked_value'] ) && $field_value == $column['checked_value'] ) {
                $display_value = 'yes';
                $field_value = 'yes';
            }

            if ( isset( $column['unchecked_value'] ) && $field_value == $column['unchecked_value'] ) {
                $display_value = 'no';
                $field_value = 'no';
            }
        break;

        case 'number':
            if ( !isset( $display_value ) || $display_value == '' ) {
                $display_value = 'n/a';
            }
        break;

        default:
            if ( !isset( $display_value ) || empty( $display_value ) ) {
                $display_value = 'n/a';
            }

            if ( !empty( $field_value ) ) {
                $field_value = htmlspecialchars( $field_value, ENT_QUOTES );
                $display_value = htmlspecialchars( $display_value, ENT_QUOTES );
            }
        break;
    }

    // Some fields are always hidden.
    switch ( $pwbe_product->product_type ) {
        case 'variable':
            if ( $visibility != 'parent' && $visibility != 'both' ) {
                $readonly = 'pwbe-field-readonly';
                $field_value = '';
                $display_value = '<div class="pwbe-field-variable-product">' . __( 'Variable product', 'pw-bulk-edit' ) . '</div>';
            }
        break;

        case 'variation':
            if ( $visibility != 'variation' && $visibility != 'parent_variation' && $visibility != 'both' ) {
                $readonly = 'pwbe-field-readonly';
                $field_value = '';

                if ( $field == 'post_title' ) {
                    $display_value = '<div class="pwbe-field-variation" data-post-id="' . $pwbe_product->parent_post_id . '">' . sprintf( __( 'Variation of %s', 'pw-bulk-edit' ), substr( $pwbe_product->post_title, 0, 100 ) ) . '</div>';
                } else if ( $field == 'product_type' ) {
                    $display_value = '<div class="pwbe-field-variable-product">' . __( 'Variation', 'pw-bulk-edit' ) . '</div>';
                } else {
                    $attributes = PWBE_Attributes::get_values();
                    if ( isset( $attributes[ $field ] ) ) {
                        $display_value = '<div class="pwbe-field-variable-product">' . __( 'Variation', 'pw-bulk-edit' ) . '</div>';
                    } else {
                        $display_value = '<div class="pwbe-field-variable-product">' . __( 'Same as parent', 'pw-bulk-edit' ) . '</div>';
                    }
                }
            }
        break;

        default:
            if ( $visibility != 'parent' && $visibility != 'parent_variation' && $visibility != 'both' && $visibility != 'simple' ) {
                $readonly = 'pwbe-field-readonly';
                $field_value = '';
                $display_value = '<div class="pwbe-field-variable-product">' . __( 'Variation field', 'pw-bulk-edit' ) . '</div>';
            }
        break;
    }

    if ( $pwbe_product->product_type == 'variation' && $field == 'post_title' ) {
        $variation = wc_get_product( $pwbe_product->post_id );
        if ( $variation ) {
            $display_value = $variation->get_formatted_name();
        }
    }

    if ( !$output_html ) {
        return $field_value;
    }

    $html = "
        <div class='pwbe-td pwbe-results-table-td pwbe-results-table-cell-td' data-field='$field'>
            <div class='pwbe-field pwbe-field-$field $readonly'>
                <input type='hidden' name='pwbe_field_{$field}_{$pwbe_product->post_id}' value='$field_value' class='pwbe-field-value' data-input-type='$input_type' data-original-value='$field_value' data-field='$field' data-post-id='{$pwbe_product->post_id}' data-parent-post-id='{$pwbe_product->parent_post_id}' data-product-type='{$pwbe_product->product_type}' $additional_input_attributes />
                <div class='pwbe-field-label'>$display_value</div>
            </div>
        </div>
    ";

    return $html;
}
