let Dashboard;

Dashboard = () => {
    return {
        renderChart: function() {
            let c = false;

            Chart.helpers.each(Chart.instances, function(instance) {
                if (instance.chart.canvas.id == 'chart') {
                    c = instance;
                }
            });

            if (c) {
                c.destroy();
            }

            let chartID = document.getElementById('chart'),
                ctx = chartID.getContext('2d'),
                dataLabel = false,
                dataCount1 = false,
                dataCount2 = false,
                dataCount3 = false;

            if (chartID.hasAttribute('data-label')) {
                dataLabel = JSON.parse(chartID.getAttribute('data-label'));
            }

            if (chartID.hasAttribute('data-count1')) {
                dataCount1 = JSON.parse(chartID.getAttribute('data-count1'));
            }

            if (chartID.hasAttribute('data-count2')) {
                dataCount2 = JSON.parse(chartID.getAttribute('data-count2'));
            }

            if (chartID.hasAttribute('data-count3')) {
                dataCount3 = JSON.parse(chartID.getAttribute('data-count3'));
            }

            let chart = new Chart(ctx, {
                type: "line",
                data: {
                    labels: dataLabel,
                    datasets: [{
                        label: 'Clicks',
                        backgroundColor: "rgba(255, 255, 255, 0.1)",
                        borderColor: "rgba(255, 255, 255, 1)",
                        pointBackgroundColor: "rgba(255, 255, 255, 1)",
                        data: dataCount1,
                    }, {
                        label: 'Unique Clicks',
                        backgroundColor: "rgba(252, 165, 165, 0.5)",
                        borderColor: "rgba(252, 165, 165, 1)",
                        pointBackgroundColor: "rgba(252, 165, 165, 1)",
                        data: dataCount2,
                    }, {
                        label: 'Sales',
                        backgroundColor: "rgba(16, 185, 129, 0.5)",
                        borderColor: "rgba(16, 185, 129, 1)",
                        pointBackgroundColor: "rgba(16, 185, 129, 1)",
                        data: dataCount3,
                    }, ],
                },
                layout: {
                    padding: {
                        right: 10
                    }
                },
                options: {
                    legend: {
                        display: true,
                        labels: {
                            fontColor: '#ffffff'
                        }
                    },
                    scales: {
                        yAxes: [{
                            ticks: {
                                fontColor: "rgba(255, 255, 255, 1)",
                            },
                            gridLines: {
                                display: false,
                            },
                        }],
                        xAxes: [{
                            ticks: {
                                fontColor: "rgba(255, 255, 255, 1)",
                            },
                            gridLines: {
                                color: "rgba(255, 255, 255, .2)",
                                borderDash: [5, 5],
                                zeroLineColor: "rgba(255, 255, 255, .2)",
                                zeroLineBorderDash: [5, 5]
                            },
                        }]
                    }
                }
            });
        }
    }
}