<div class="wrap">
    <h1 class="wp-heading-inline"><?php _e('Add new Product', 'salesloo'); ?></h1>
    <hr class="wp-header-end">
    <?php echo $notice; ?>
    <form name="post" action="" method="post" class="salesloo-form">
        <?php wp_nonce_field('salesloo-coupon'); ?>
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <div id="post-body-content" style="position: relative;">

                    <?php
                    \salesloo_field_hidden([
                        'name' => 'ID',
                        'value' => $couponID
                    ]);

                    \salesloo_field_title([
                        'label' => 'Coupon Title',
                        'name' => 'title',
                        'value' => sanitize_text_field($coupon->title)
                    ]);

                    \salesloo_field_content([
                        'name' => 'description',
                        'value' => sanitize_text_field($coupon->description)
                    ]);

                    ?>

                </div>

                <div id="postbox-container-1" class="postbox-container">
                    <div id="side-sortables" class="meta-box-sortables ui-sortable">

                        <div class="postbox">
                            <div class="postbox-header">
                                <h2 class="hndle ui-sortable-handle">Rebate</h2>
                            </div>
                            <div class="inside">
                                <div class="submitbox">

                                    <div id="minor-publishing">

                                        <div class="misc-publishing-actions">
                                            <div class="misc-pub-section">
                                                <?php

                                                \salesloo_field_text([
                                                    'label'           => __('Rebate Amount', 'salesloo'),
                                                    'name'            => 'rebate',
                                                    'description'     => __('the amount of the discounted price, type fixed discounted without money simbol or percentage discount example: 50% or 10', 'salesloo'),
                                                    'class' => 'large-text',
                                                    'direction'       => 'column',
                                                    'value'   => $coupon->rebate,
                                                ]);

                                                ?>
                                            </div>
                                            <div class="clear"></div>
                                        </div>

                                        <div class="clear"></div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="postbox">
                            <div class="postbox-header">
                                <h2 class="hndle ui-sortable-handle">Limitations</h2>
                            </div>
                            <div class="inside">
                                <div class="submitbox">

                                    <div id="minor-publishing">

                                        <div class="misc-publishing-actions">
                                            <div class="misc-pub-section">
                                                <?php

                                                \salesloo_field_toggle([
                                                    'label'           => __('Is private coupon?', 'salesloo'),
                                                    'name'            => 'is_private',
                                                    'description'     => __('Is this coupon is private, coupon not visible for all affiliate', 'salesloo'),
                                                    'direction'       => 'column',
                                                    'value'   => $coupon->is_private,
                                                ]);

                                                \salesloo_field_number([
                                                    'label'           => __('Max Usage', 'salesloo'),
                                                    'name'            => 'max_usage',
                                                    'description'     => __('Maximum coupon usage, leave empty or 0 to unlimited usage', 'salesloo'),
                                                    'class' => 'large-text',
                                                    'direction'       => 'column',
                                                    'value'   => $coupon->max_usage,
                                                ]);

                                                $products = $coupon->products;

                                                $options = [];
                                                foreach ((array)$products as $p) {
                                                    $product = Salesloo\Models\Product::query('WHERE ID = %d', $p)->first();
                                                    $options[$p] = $product->title;
                                                }

                                                \salesloo_field_select2([
                                                    'label'           => __('Products Include', 'salesloo'),
                                                    'name'            => 'products',
                                                    'description'     => __('Coupon only work for this spesifict product', 'salesloo'),
                                                    'direction'       => 'column',
                                                    'multiple'        => true,
                                                    'select2_options' => [
                                                        'action' => 'get_all_products',
                                                        'nonce'  => wp_create_nonce('salesloo-ajax')
                                                    ],
                                                    'value'   => $coupon->products,
                                                    'options' => $options
                                                ]);

                                                ?>
                                            </div>
                                            <div class="clear"></div>
                                        </div>

                                        <div class="clear"></div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div id="submitdiv" class="postbox">
                            <div class="postbox-header">
                                <h2 class="hndle ui-sortable-handle">Publish</h2>
                            </div>
                            <div class="inside">
                                <div class="submitbox" id="submitpost">

                                    <div id="minor-publishing">

                                        <div class="misc-publishing-actions">
                                            <div class="misc-pub-section">
                                                <?php
                                                \salesloo_field_select([
                                                    'label'    => __('Status', 'salesloo'),
                                                    'name'     => 'status',
                                                    'required' => true,
                                                    'options'  => salesloo_get_coupon_statuses(),
                                                    'value'     => $coupon->status,
                                                    'direction' => 'column'
                                                ]);

                                                \salesloo_field_datepicker([
                                                    'label'        => __('Active start', 'salesloo'),
                                                    'name'         => 'active_start',
                                                    'direction'    => 'column',
                                                    'class'        => 'small',
                                                    'date_options' => [
                                                        'minDate' => date('Y-m-d'),
                                                        'singleDatePicker' => true,
                                                    ],
                                                    'conditional' => [
                                                        [
                                                            'field'   => 'status',
                                                            'value'   => 'inactive',
                                                            'compare' => '=='
                                                        ],
                                                    ],
                                                    'value' => $coupon->active_start
                                                ]);

                                                \salesloo_field_datepicker([
                                                    'label'        => __('Active end', 'salesloo'),
                                                    'name'         => 'active_end',
                                                    'direction'    => 'column',
                                                    'class'        => 'small',
                                                    'date_options' => [
                                                        'minDate' => date('Y-m-d'),
                                                    ],
                                                    'conditional' => [
                                                        'compare' => 'OR',
                                                        [
                                                            'field'   => 'status',
                                                            'value'   => 'active',
                                                            'compare' => '=='
                                                        ],
                                                        [
                                                            'field'   => 'status',
                                                            'value'   => 'inactive',
                                                            'compare' => '=='
                                                        ]
                                                    ],
                                                    'value' => $coupon->active_end
                                                ]);

                                                ?>
                                            </div>
                                            <div class="clear"></div>
                                        </div>

                                        <div class="clear"></div>
                                    </div>

                                    <div id="major-publishing-actions">
                                        <div id="delete-action" style="display: none">
                                            <a class="submitdelete deletion" href="">Delete</a>
                                        </div>

                                        <div id="publishing-action">
                                            <span class="spinner"></span>
                                            <button type="submit" class="button button-primary button-large">Save
                                                Product</button>
                                        </div>
                                        <div class="clear"></div>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div id="postbox-container-2" class="postbox-container">
                    <div id="normal-sortables" class="ui-sortable">
                        <div class="postbox ">
                            <div class="postbox-header">
                                <h2 class="hndle ui-sortable-handle">Code</h2>
                            </div>
                            <div class="inside">

                                <?php

                                \salesloo_field_text([
                                    'label'           => __('General Code', 'salesloo'),
                                    'name'            => 'code',
                                    'description'     => __('The general coupon code', 'salesloo'),
                                    'direction'       => 'column',
                                    'value'   => salesloo_get_coupon_code($couponID),
                                ]);

                                ?>
                                <?php

                                $list_table = new Salesloo\AdminTable\Coupon_Codes();
                                $list_table->prepare_items();
                                ?>
                                <hr class="wp-header-end">
                                <form method="get" action="">
                                    <?php $list_table->views(); ?>
                                    <?php $list_table->display();
                                    ?>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
        </div>

    </form>
</div>