<div class="wrap">
    <h1 class="wp-heading-inline">Add new Product</h1>
    <hr class="wp-header-end">
    <?php echo $notice; ?>
    <form name="post" action="" method="post" class="salesloo-form">
        <?php wp_nonce_field('salesloo-product'); ?>
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <div id="post-body-content" style="position: relative;">

                    <?php
                    \salesloo_field_hidden([
                        'name' => 'ID',
                        'value' => $productID
                    ]);

                    \salesloo_field_title([
                        'label' => 'Product name',
                        'name' => 'title',
                        'value' => sanitize_text_field($product->title)
                    ]);

                    \salesloo_field_content([
                        'name' => 'description',
                        'value' => stripslashes_deep($product->description)
                    ]);

                    ?>

                </div>

                <div id="postbox-container-1" class="postbox-container">
                    <div id="side-sortables" class="meta-box-sortables ui-sortable">

                        <div class="postbox">
                            <div class="postbox-header">
                                <h2 class="hndle ui-sortable-handle">Thumbnails</h2>
                            </div>
                            <div class="inside">
                                <div class="submitbox">
                                    <div id="minor-publishing">

                                        <div class="misc-publishing-actions">
                                            <div class="misc-pub-section">
                                                <?php
                                                \salesloo_field_image([
                                                    'label'     => __('Choose thumbnail', 'salesloo'),
                                                    'name'      => 'thumbnail_id',
                                                    'direction' => 'column',
                                                    'value'     => $product->thumbnail_id
                                                ]);

                                                ?>
                                            </div>
                                            <div class="clear"></div>
                                        </div>

                                        <div class="clear"></div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="postbox">
                            <div class="postbox-header">
                                <h2 class="hndle ui-sortable-handle">Items</h2>
                            </div>
                            <div class="inside">
                                <div class="submitbox">

                                    <div id="minor-publishing">

                                        <div class="misc-publishing-actions">
                                            <div class="misc-pub-section">
                                                <?php
                                                $items = $product->items;

                                                $options = [];
                                                foreach ((array)$items as $item) {
                                                    $options[$item] = get_the_title($item);
                                                }
                                                \salesloo_field_select2([
                                                    'label'           => __('Choose items', 'salesloo'),
                                                    'name'            => 'items',
                                                    'description'     => __('Type items title', 'salesloo'),
                                                    'direction'       => 'column',
                                                    'multiple'        => true,
                                                    'select2_options' => [
                                                        'action' => 'get_all_items',
                                                        'nonce'  => wp_create_nonce('salesloo-ajax')
                                                    ],
                                                    'value'   => $product->items,
                                                    'options' => $options,
                                                    'required' => true,
                                                ]);

                                                ?>
                                            </div>
                                            <div class="clear"></div>
                                        </div>

                                        <div class="clear"></div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div id="submitdiv" class="postbox">
                            <div class="postbox-header">
                                <h2 class="hndle ui-sortable-handle">Publish</h2>
                            </div>
                            <div class="inside">
                                <div class="submitbox" id="submitpost">

                                    <div id="minor-publishing">

                                        <div class="misc-publishing-actions">
                                            <div class="misc-pub-section">
                                                <?php
                                                \salesloo_field_select([
                                                    'label'    => __('Status', 'salesloo'),
                                                    'name'     => 'status',
                                                    'required' => true,
                                                    'options'  => salesloo_get_product_statuses(),
                                                    'value'     => $product->status,
                                                    'direction' => 'column'
                                                ]);

                                                \salesloo_field_datepicker([
                                                    'label'        => __('Scheduled start', 'salesloo'),
                                                    'name'         => 'scheduled_start',
                                                    'direction'    => 'column',
                                                    'class'        => 'small',
                                                    'date_options' => [
                                                        'minDate' => date('Y/m/d'),
                                                        'singleDatePicker' => true,
                                                    ],
                                                    'conditional' => [
                                                        [
                                                            'field'   => 'status',
                                                            'value'   => 'inactive',
                                                            'compare' => '=='
                                                        ],
                                                    ],
                                                    'value' => salesloo_get_product_meta($productID, 'scheduled_start', true)
                                                ]);

                                                \salesloo_field_datepicker([
                                                    'label'        => __('Scheduled end', 'salesloo'),
                                                    'name'         => 'scheduled_end',
                                                    'direction'    => 'column',
                                                    'class'        => 'small',
                                                    'date_options' => [
                                                        'minDate' => date('Y/m/d'),
                                                    ],
                                                    'conditional' => [
                                                        'compare' => 'OR',
                                                        [
                                                            'field'   => 'status',
                                                            'value'   => 'active',
                                                            'compare' => '=='
                                                        ],
                                                        [
                                                            'field'   => 'status',
                                                            'value'   => 'inactive',
                                                            'compare' => '=='
                                                        ]
                                                    ],
                                                    'value' => salesloo_get_product_meta($productID, 'scheduled_end', true)
                                                ]);

                                                ?>
                                            </div>
                                            <div class="clear"></div>
                                        </div>

                                        <div class="clear"></div>
                                    </div>

                                    <div id="major-publishing-actions">
                                        <div id="delete-action" style="display: none">
                                            <a class="submitdelete deletion" href="">Delete</a>
                                        </div>

                                        <div id="publishing-action">
                                            <span class="spinner"></span>
                                            <button type="submit" class="button button-primary button-large">Save
                                                Product</button>
                                        </div>
                                        <div class="clear"></div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="postbox-container-2" class="postbox-container">
                    <div id="normal-sortables" class="ui-sortable">
                        <div class="postbox ">
                            <div class="postbox-header">
                                <h2 class="hndle ui-sortable-handle">Product Data</h2>
                            </div>
                            <div class="salesloo-tabs">
                                <ul>
                                    <?php foreach ($tabs as $tab) {
                                        echo '<li><a href="#' . $tab['content_id'] . '">' . $tab['name'] . '</a></li>';
                                    } ?>
                                </ul>
                                <div class="salesloo-tabs-content inside">
                                    <div id="tab-content-general">
                                        <?php do_action('salesloo/admin/product/edit/general/before', $product); ?>
                                        <?php
                                        \salesloo_field_radiobutton([
                                            'label'    => __('Duration', 'salesloo'),
                                            'name'     => 'duration',
                                            'required' => true,
                                            'options'  => salesloo_product_duration(),
                                            'value'    => $product->duration ? $product->duration : 'onetime'
                                        ]);

                                        \salesloo_field_number([
                                            'label' => __('Regular price', 'salesloo'),
                                            'name'  => 'regular_price',
                                            'min'   => '0',
                                            'value' => salesloo_get_product_meta($productID, 'regular_price', true)
                                        ]);

                                        \salesloo_field_number([
                                            'label' => __('Renew price', 'salesloo'),
                                            'name'  => 'renew_price',
                                            'min'   => '0',
                                            'value' => salesloo_get_product_meta($productID, 'renew_price', true),
                                            'conditional' => [
                                                [
                                                    'field'   => 'duration',
                                                    'value'   => 'onetime',
                                                    'compare' => '!='
                                                ]
                                            ],
                                        ]);

                                        \salesloo_field_text([
                                            'label'       => __('Salespage', 'salesloo'),
                                            'name'        => 'salespage_url',
                                            'placeholder' => 'https://',
                                            'value'       => salesloo_get_product_meta($productID, 'salespage_url', true)
                                        ]);
                                        ?>
                                        <?php do_action('salesloo/admin/product/edit/general/after', $product); ?>
                                    </div>
                                    <div id="tab-content-affiliate">
                                        <?php do_action('salesloo/admin/product/edit/affiliate/before', $product); ?>
                                        <?php
                                        \salesloo_field_toggle([
                                            'label' => 'Enable Affiliate',
                                            'name'  => 'affiliate',
                                            'value' => $product->affiliate
                                        ]);

                                        \salesloo_field_text([
                                            'label'       => __('Affiliate Commission', 'salesloo'),
                                            'name'        => 'affiliate_commission',
                                            'description' => __('If fixed commissions put full integer or if percentage commission put integers with percentage simbol, example 50 for $50 commission or 50% for 50 percen commision', 'salesloo'),
                                            'conditional' => [
                                                [
                                                    'field'   => 'affiliate',
                                                    'value'   => 1,
                                                    'compare' => '='
                                                ]
                                            ],
                                            'value' => salesloo_get_product_meta($productID, 'affiliate_commission', true)
                                        ]);
                                        ?>
                                        <?php do_action('salesloo/admin/product/edit/affiliate/after', $product); ?>
                                    </div>
                                    <div id="tab-content-license">
                                        <?php do_action('salesloo/admin/product/edit/license/before', $product); ?>
                                        <?php

                                        \salesloo_field_number([
                                            'label'       => __('License Limit', 'salesloo'),
                                            'name'        => 'license_limit',
                                            'description' => __('Leave blank if unlimited license or none of the items use the license', 'salesloo'),
                                            'class'       => 'small',
                                            'value'       => salesloo_get_product_meta($productID, 'license_limit', true)
                                        ]);

                                        ?>
                                        <?php do_action('salesloo/admin/product/edit/license/after', $product); ?>
                                    </div>
                                    <div id="tab-content-autoresponder">
                                        <?php do_action('salesloo/admin/product/edit/autoresponder/before', $product); ?>
                                        <?php

                                        $autoresponder_service_provider = apply_filters('salesloo/admin/product/edit/autoresponder/service_provider', [
                                            'none' => __('None', 'salesloo'),
                                            'custom' => __('Custom Form', 'salesloo')
                                        ]);

                                        \salesloo_field_select([
                                            'label'    => __('Service Provider', 'salesloo'),
                                            'name'     => 'autoresponder_service_provider',
                                            'required' => false,
                                            'options'  => $autoresponder_service_provider,
                                            'value'     => salesloo_get_product_meta($productID, 'autoresponder_service_provider', true),
                                        ]);

                                        $value = salesloo_get_product_meta($productID, 'custom_autoresponder_on_place_order_event', true);

                                        $list_form = '';
                                        foreach ((array)$value as $form) {
                                            $f = isset($form['action']) ? 'Action url : ' . $form['action'] . '<br/>' : '';
                                            $f .= isset($form['method']) ? 'Method : ' . $form['method'] . '<br/>' : '';
                                            $f .= isset($form['fields']) ? 'Fields : ' . implode(',', $form['fields']) . '<br/>' : '';
                                            $list_form .= $f . '<br/>';
                                        }

                                        \salesloo_field_textarea([
                                            'label'    => __('On Place Order Form', 'salesloo'),
                                            'name'     => 'custom_autoresponder_on_place_order_event',
                                            'required' => false,
                                            'class' => 'large-text',
                                            'style' => 'height: 200px',
                                            'direction' => 'column',
                                            'before' => $list_form,
                                            'conditional' => [
                                                [
                                                    'field'   => 'autoresponder_service_provider',
                                                    'value'   => 'custom',
                                                    'compare' => '='
                                                ]
                                            ],
                                            'description' => __('This form will be excetuted on place order event', 'salesloo')
                                        ]);

                                        $value = salesloo_get_product_meta($productID, 'custom_autoresponder_on_invoice_completed_event', true);

                                        $list_form = '';
                                        foreach ((array)$value as $form) {
                                            $f = isset($form['action']) ? 'Action url : ' . $form['action'] . '<br/>' : '';
                                            $f .= isset($form['method']) ? 'Method : ' . $form['method'] . '<br/>' : '';
                                            $f .= isset($form['fields']) ? 'Fields : ' . implode(',', $form['fields']) . '<br/>' : '';
                                            $list_form .= $f . '<br/>';
                                        }

                                        \salesloo_field_textarea([
                                            'label'    => __('On Completed Invoice Form', 'salesloo'),
                                            'name'     => 'custom_autoresponder_on_completed_invoice_event',
                                            'required' => false,
                                            'class' => 'large-text',
                                            'style' => 'height: 200px',
                                            'direction' => 'column',
                                            'before' => $list_form,
                                            'conditional' => [
                                                [
                                                    'field'   => 'autoresponder_service_provider',
                                                    'value'   => 'custom',
                                                    'compare' => '='
                                                ]
                                            ],
                                            'description' => __('This form will be excetuted on invoice completed event', 'salesloo')
                                        ]);

                                        ?>
                                        <?php do_action('salesloo/admin/product/edit/autoresponder/after', $product); ?>
                                    </div>
                                    <?php do_action('salesloo/admin/product/edit/tabs/content', $product); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
        </div>

    </form>
</div>