<?php

namespace Salesloo\Abstracts;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

abstract class Frontend
{
    /**
     * ID
     */
    protected $id;

    /**
     * template page
     */
    protected $template;

    /**
     * target page for: logedin user, non loggedin user or both;
     * 
     * "user" only loggedin user can access
     * "guest" for non loggedin user can access
     * "both" all guset and user can access
     */
    protected $target;

    /**
     * page title
     */
    protected $title;

    /**
     * get id
     * 
     * return string
     */
    public function get_id()
    {
        return $this->id;
    }

    /**
     * get template
     * 
     * return string
     */
    public function get_template()
    {
        return $this->template;
    }

    /**
     * get user target
     */
    public function get_target()
    {
        return $this->target;
    }

    /**
     * get page title
     */
    public function get_title()
    {
        return $this->title;
    }

    /**
     * enqueue styles
     */
    public function enqueue_styles()
    {
        return [];
    }

    /**
     * enqueue scripts
     */
    public function enqueue_scripts()
    {
        return [];
    }

    /**
     * handle process action
     */
    public function process_action($request)
    {
        return;
    }

    /**
     * load page
     */
    public function load()
    {

        return;
    }
}
