<?php

namespace Salesloo\Abstracts;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

abstract class Payment_Method
{
    /**
     * payment ID
     */
    protected $id;

    /**
     * payment name
     */
    protected $name;

    /**
     * payment icon url
     */
    protected $icon_id;

    /**
     * payment title
     */
    protected $title;

    /**
     * payment currency
     */
    protected $currency;

    protected $currency_symbol;

    /**
     * payment method description
     */
    protected $description;

    /**
     * payment method currency rate
     */
    protected $currency_rate;

    /**
     * is support unique number ?
     */
    protected $unique_number = false;

    protected $instruction = '';

    protected $enable = false;

    /**
     * enable payment status
     */
    public function enable()
    {
        return salesloo_get_option('payment_method_' . $this->id . '_enable');
    }

    /**
     * unique number
     */
    public function use_unique_number()
    {
        $unique_number = \salesloo_get_option('payment_method_' . $this->id . '_unique_number', $this->unique_number);

        $unique_number = apply_filters('salesloo/payment_method/unique_number/status', $unique_number, $this);

        if (salesloo_get_option('unique_number')) {
            return $unique_number;
        }

        return false;
    }

    /**
     * get payment method ID
     */
    public function get_id()
    {
        return $this->id;
    }

    /**
     * get payment method title
     */
    public function get_icon()
    {
        $icon = \salesloo_get_option('payment_method_' . $this->id . '_icon', $this->icon_id);

        //check if icon is url
        if (filter_var($icon, FILTER_VALIDATE_URL)) {
            $url = $icon;
        } else {
            $url = wp_get_attachment_url($icon);
        }

        return esc_url($url);
    }

    /**
     * get payment method title
     */
    public function get_name()
    {
        return $this->name;
    }

    /**
     * get payment method title
     */
    public function get_title()
    {
        $option = \salesloo_get_option('payment_method_' . $this->id . '_title', $this->title);

        return sanitize_text_field($option);
    }

    /**
     * get payment method currency
     */
    public function get_currency()
    {
        $currencies = array_keys(salesloo_currencies());

        $currency = \salesloo_get_option('currency');
        if (in_array($this->currency, $currencies)) {
            $currency = $this->currency;
        }

        $option = \salesloo_get_option('payment_method_' . $this->id . '_currency', $currency);

        return sanitize_text_field($option);
    }

    public function get_currency_symbol()
    {
        $currency_symbol = $this->currency_symbol;

        if (empty($currency_symbol)) {
            $currency_symbol = $this->get_currency();
        }

        $option = \salesloo_get_option('payment_method_' . $this->id . '_currency_symbol', $currency_symbol);

        return sanitize_text_field($option);
    }

    /**
     * get payment method currency rate
     */
    public function get_currency_rate()
    {
        $rate = \salesloo_get_option('payment_method_' . $this->id . '_currency_rate', $this->currency_rate);

        $option = apply_filters('salesloo\payment_method\currency_rate', $rate, $this);

        return sanitize_text_field($option);
    }

    /**
     * get payment method description
     */
    public function get_description()
    {
        $option = \salesloo_get_option('payment_method_' . $this->id . '_description', $this->description);

        return wp_kses_post(wpautop(wptexturize(wp_kses_post($option))));
    }

    public function get_instruction()
    {
        $option = \salesloo_get_option('payment_method_' . $this->id . '_instruction', $this->instruction);

        return wp_kses_post(wpautop(wptexturize(wp_kses_post($option))));
    }

    /**
     * payment method settings
     */
    public function settings()
    {
        return;
    }

    /**
     * handle payment action
     */
    public function handle_action($invoice)
    {
        return;
    }

    /**
     * handle load payment method;
     */
    public function handle_load()
    {
        return;
    }

    /**
     * print payment action on frontend
     */
    public function print_action()
    {
        return;
    }
}
