<?php

namespace Salesloo\Abstracts;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

abstract class Rest_Api
{
    /**
     * namespace
     */
    protected $namespace = 'salesloo';

    protected $version;

    protected $route;

    /**
     * Register routes
     */
    abstract function register_routes();

    /**
     * Show endpoint
     */
    protected function endpoint($slug = false)
    {
        $slug = $slug ? '/' . $slug : $slug;
        $url = get_rest_url(null, $this->namespace . '/' . $this->version . '/' . $this->route . $slug);

        return esc_url_raw($url);
    }

    /**
     * Handle dynamic static method calls.
     *
     * @param  string  $method
     * @param  array  $parameters
     * @return mixed
     */
    public static function __callStatic($method, $parameters)
    {
        return (new static)->$method(...$parameters);
    }

    /**
     * Handle dynamic method calls.
     */
    public function __call($method, $parameters)
    {
        return $this->$method(...$parameters);
    }
}
