<?php

namespace Salesloo;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\AdminTable\Addon as Addon_Table;

/**
 * Addon classes
 */
class Addon
{

    /**
     * Instance.
     *
     * Holds the affiliates instance.
     *
     * @since 1.0.0
     * @access public
     */
    public static $instance = null;

    /**
     * Init.
     *
     * @since 1.0.0
     */
    public static function init()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Register Menu
     * 
     * register system info menu
     */
    public function register_menu($submenu)
    {
        $submenu[] = [
            'page_title' => __('Add On', 'salesloo'),
            'menu_title' => __('Add On', 'salesloo'),
            'capability' => 'manage_options',
            'slug'       => 'salesloo-addon',
            'callback'   => [$this, 'page'],
            'position'   => 90
        ];

        return $submenu;
    }

    /**
     * show menu page
     */
    public function page()
    {
        global $salesloo_install_addon;

        $list_table = new Addon_Table();
        $list_table->prepare_items();

        if ($salesloo_install_addon) {
            $t = salesloo_install_plugin($salesloo_install_addon);
        }

?>
        <div class="wrap">
            <h1 class="wp-heading-inline"><?php echo esc_html(__('Add On', 'salesloo')); ?></h1>

            <hr class="wp-header-end">

            <form method="get" action="">
                <input type="hidden" name="page" value="salesloo-addon" />
                <?php $list_table->views(); ?>
                <?php $list_table->display();
                ?>
            </form>
        </div>
<?php
    }

    public function action()
    {
        global $salesloo_install_addon;

        if (!isset($_GET['action'])) return;

        if (!isset($_GET['_wpnonce']) || !wp_verify_nonce($_GET['_wpnonce'], 'salesloo_install_addon')) return;

        if ($_GET['action'] == 'install') {
            $salesloo_install_addon = esc_url($_GET['plugin']);
        }
    }


    /**
     * Constructor
     */
    public function __construct()
    {
        add_filter('salesloo/admin/submenu', [$this, 'register_menu'], 1, 10);
        add_action('admin_init', [$this, 'action']);
    }
}
