<?php

namespace Salesloo\AdminTable;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


if (!class_exists('WP_List_Table')) {
    require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

use Salesloo\Models\Order;

class Addon extends \WP_List_Table
{
    /**
     * constructor
     */
    public function __construct()
    {
        parent::__construct(
            array(
                'singular' => 'addon',     // Singular name of the listed records.
                'plural'   => 'addons',    // Plural name of the listed records.
                'ajax'     => false,       // Does this table support ajax?
            )
        );
    }

    /**
     * Get columns
     * @return [type] [description]
     */
    public function get_columns()
    {
        $columns = array(
            'name'     => __('Name', 'salesloo'),
            'category' => __('Category', 'salesloo'),
            'author'   => __('Author', 'salesloo'),
            'action'   => '&nbsp;'
        );
        return $columns;
    }

    /**
     * Define column name
     * @param  [type] $item [description]
     * @return [type]       [description]
     */
    protected function column_name($item)
    {
        return sprintf(
            '<div style="font-weight:bold;margin-bottom:5px;">%1$s</div><div>%2$s</div>',
            $item->name,
            $item->description
        );
    }

    /**
     * Define column category
     * @param  [type] $item [description]
     * @return [type]       [description]
     */
    protected function column_category($item)
    {
        $cats = (array)$item->category;

        return sprintf(
            '<div>%1$s</div>',
            implode(', ', $cats),
        );
    }

    /**
     * Define column author
     * @param  [type] $item [description]
     * @return [type]       [description]
     */
    protected function column_author($item)
    {
        return sprintf(
            '<div>%1$s</div>',
            $item->author,
        );
    }

    /**
     * define column action
     * @param  [type] $item [description]
     * @return [type]       [description]
     */
    protected function column_action($item)
    {
        $installed_plugins = get_plugins();

        $install_url = wp_nonce_url('admin.php?page=salesloo-addon&action=install&plugin=' . $item->source, 'salesloo_install_addon');
        $activation_url = wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $item->file . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $item->file);

        $button = '<a target="" href="' . $install_url . '" class="button">Install</a>';

        if (isset($installed_plugins[$item->file])) {
            if (!is_plugin_active($item->file)) {
                $button = '<a target="" href="' . $activation_url . '" class="button">Activate</a>';
            } else {
                $button = 'Active';
            }
        }

        ob_start();

        echo '<div style="text-align:right;">';
        echo $button;
        echo '&nbsp;';
        echo '</div>';

        $html = ob_get_contents();
        ob_end_clean();

        return $html;
    }


    protected function get_bulk_actions()
    {
        return;
    }

    protected function display_tablenav($which)
    {
?>
        <div class="tablenav <?php echo esc_attr($which); ?>">

            <?php if ($this->has_items()) : ?>
                <div class="alignleft actions bulkactions">
                    <?php $this->bulk_actions($which); ?>
                </div>
            <?php
            endif;
            $this->extra_tablenav($which);
            $this->pagination($which);
            ?>

            <br class="clear" />
        </div>
<?php
    }

    /**
     * prepare items list
     * @return [type] [description]
     */
    public function prepare_items()
    {
        global $wp_filesystem;

        $current_screen = get_current_screen();
        $per_page = 20;
        $columns  = $this->get_columns();
        $hidden   = array();
        $sortable = $this->get_sortable_columns();

        /*
		 * REQUIRED. Finally, we build an array to be used by the class for column
		 * headers. The $this->_column_headers property takes an array which contains
		 * three other arrays. One for all columns, one for hidden columns, and one
		 * for sortable columns.
		 */
        $this->_column_headers = array($columns, $hidden, $sortable);

        /**
         * Optional. You can handle your bulk actions however you see fit. In this
         * case, we'll handle them within our package just to keep things clean.
         */
        $this->process_bulk_action();

        $data = get_transient('salesloo_addon');

        if (empty($data)) {
            $json = wp_remote_retrieve_body(wp_remote_get(esc_url_raw('http://repo.salesloo.com/index.json')));
            $data = json_decode($json);
            set_transient('salesloo_addon', $data, 1 * HOUR_IN_SECONDS);
        }

        $total = count($data);
        $total_page = ceil($total / $per_page);

        $this->items = $data;
        $this->set_pagination_args(
            array(
                'total_items' => $total,
                'total_pages' => $total_page,
                'per_page' => $per_page,
            )
        );
    }
}
