<?php

namespace Salesloo;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Models\Commission as Model_Commission;

/**
 * Affiliate classes
 */
class Affiliate
{

    public function commission_payout_method_types()
    {
        $methods = [
            'paypal' => [
                'title' => __('Paypal', 'salesloo'),
                'example' => 'Type your paypal email eg: yourname@mail.com'
            ],
            'bank_transfer' => [
                'title' => __('Bank Transfer', 'salesloo'),
                'example' => 'Type your bank account number eg: Bank Name | Jhone Doe | 1234567890'
            ]
        ];

        $methods = apply_filters('salesloo/affiliate/payout/method/types', $methods);

        return $methods;
    }

    /**
     * commission_payout_methods
     * 
     * payout methods for spesifict user
     *
     * @param  int $user_id
     * @return array
     */
    public function commission_payout_methods($user_id = false)
    {
        global $wpdb;

        $meta_key = 'salesloo_commissions_withdrawal_methods';
        if (false === $user_id)
            $user_id = get_current_user_id();

        $user_id = intval($user_id);

        $query = $wpdb->prepare("SELECT * FROM $wpdb->usermeta WHERE user_id=%d AND meta_key=%s", $user_id, $meta_key);

        $results = $wpdb->get_results($query);

        $methods = [];
        foreach ($results as $result) {
            $methods[$result->umeta_id] = maybe_unserialize($result->meta_value);
        }

        return $methods;
    }
}
