<?php

namespace Salesloo\Email\Affiliate;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Email;

class New_Lead extends Email
{
    public function __construct()
    {

        $this->target = 'affiliate';
        $this->event = 'new_lead';
        $this->target_title = __('Affiliate', 'salesloo');
        $this->event_title = __('Get New Lead', 'salesloo');
    }

    public function shortcodes()
    {
        $shortcodes = [
            'affiliate_name' => __('Affiliate Name', 'salesloo'),
            'summary'       => __('Summary Affiliate', 'salesloo')
        ];

        return $shortcodes;
    }

    public function default_subject()
    {
        return 'You got new lead at [site_name]';
    }

    public function default_body()
    {
        return 'Hi [affiliate_name]

Thanks, You have a new referred customer with the following detail.

[summary]

You can follow up with your customer to make payment on their purchased product, after payment is completed you will get a commission for your hard work.';
    }

    public function content($args)
    {
        if (isset($args['summary'])) {
            $args['summary'] = $this->template_summary($args['summary']);
        }

        $this->build_subject($args);
        $this->build_body($args);

        return $this;
    }

    public function preview()
    {

        $args = [
            'site_name'     => get_bloginfo('name'),
            'affiliate_name' => 'Doe Jhon',
            'summary'       => $this->template_summary()
        ];

        $this->content($args);

        echo $this->_body;
    }

    public function template_summary($args = [])
    {
        $default = [
            'customer_name'  => 'Jhone Doe',
            'customer_email' => 'jhondoe@mail.com',
            'product_name'  => 'Test product name',
            'commission'     => salesloo_convert_money(200000)
        ];

        $args = wp_parse_args($args, $default);

        ob_start()

?>
        <table cellpadding="0" cellspacing="0" style="width:100%;background-color:#ffffff;border-radius:12px">
            <tbody>
                <tr>
                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table cellpadding="0" cellspacing="0" style="width:100%">
                            <tbody>
                                <tr>
                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Customer Name'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['customer_name']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Customer Email'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['customer_email']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="26" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;padding-left:0px">
                                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                                            <tbody>
                                                                <tr>
                                                                    <td height="3" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                                        <div>&nbsp;</div>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#999999;font-size:12px;line-height:14px;font-style:italic"><?php _e('Product Purchased', 'salesloo'); ?></span>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:14px;line-height:16px;font-weight:500"><?php echo $args['product_name']; ?></span>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td colspan="5" height="0" style="border:0;border-collapse:collapse;margin:0;padding:0;height:0px;font-size:1px;line-height:1px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td colspan="3" height="16" style="border:0;border-collapse:collapse;margin:0;padding:0;height:16px;font-size:1px;line-height:1px">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td height="1" style="border:0;border-collapse:collapse;margin:0;padding:0;height:1px;font-size:1px;background-color:#ebebeb;line-height:1px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td colspan="3" height="16" style="border:0;border-collapse:collapse;margin:0;padding:0;height:16px;font-size:1px;line-height:1px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;padding-left:0px">

                                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#999999;font-size:12px;line-height:14px;font-style:italic"><?php _e('Your potential commission', 'salesloo'); ?></span>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:14px;line-height:16px;font-weight:500"><?php echo $args['commission']; ?></span>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td colspan="5" height="0" style="border:0;border-collapse:collapse;margin:0;padding:0;height:0px;font-size:1px;line-height:1px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="32" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
<?php
        return ob_get_clean();
    }
}
