<?php

namespace Salesloo\Email\Customer;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Email;

class Invoice_Cancelled extends Email
{
    public function __construct()
    {

        $this->target = 'customer';
        $this->event = 'invoice_cancelled';
        $this->target_title = __('Customer', 'salesloo');
        $this->event_title = __('Invoice Cancelled', 'salesloo');
    }

    public function shortcodes()
    {
        $shortcodes = [
            'customer_name' => __('Customer Name', 'salesloo'),
            'invoice_number' => __('Invoice Number', 'salesloo'),
            'invoice_amount' => __('Invoice Amount', 'salesloo'),
            'prodcut_name' => __('Product Name', 'salesloo')
        ];

        return $shortcodes;
    }

    public function default_subject()
    {
        return '';
    }

    public function default_body()
    {
        return '';
    }

    public function content($args)
    {
        $this->build_subject($args);
        $this->build_body($args);

        return $this;
    }

    public function preview()
    {
        $args = [
            'site_name'      => get_bloginfo('name'),
            'customer_name'  => 'Jhon Doe',
            'invoice_number' => 'INV/20210531/00001',
            'invoice_amount' => salesloo_convert_price(200000),
            'prodcut_name'   => 'Test product name',
        ];

        $this->content($args);

        echo $this->_body;
    }
}
