<?php

namespace Salesloo\Email\Customer;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Email;

class Invoice_Checking_Payment extends Email
{
    public function __construct()
    {

        $this->target = 'customer';
        $this->event = 'invoice_checking_paymnet';
        $this->target_title = __('Customer', 'salesloo');
        $this->event_title = __('Invoice Checking Payment', 'salesloo');
    }

    public function shortcodes()
    {
        $shortcodes = [
            'customer_name' => __('Customer Name', 'salesloo'),
            'summary'       => __('Summary Invoice', 'salesloo')
        ];

        return $shortcodes;
    }

    public function default_subject()
    {
        return 'Thanks for your payment [customer_name]';
    }

    public function default_body()
    {
        return 'Hi [customer_name]

Thanks for your payment, We will check your payment and immediately activated of your purchase after we receive your payment.

[summary]';
    }

    public function content($args)
    {
        if (isset($args['summary'])) {
            $args['summary'] = $this->template_summary($args['summary']);
        }

        $this->build_subject($args);
        $this->build_body($args);

        return $this;
    }

    public function preview()
    {

        $args = [
            'site_name'     => get_bloginfo('name'),
            'customer_name' => 'Jhon Doe',
            'summary'       => []
        ];

        $this->content($args);

        echo $this->_body;
    }

    public function template_summary($args)
    {
        $default = [
            'number'         => 'INV/20210531/00001',
            'payment_method' => \Salesloo\Plugin::instance()->payment_method->get()->get_title(),
            'amount'    => salesloo_convert_money(200000)
        ];

        $args = wp_parse_args($args, $default);

        ob_start()

?>
        <table cellpadding="0" cellspacing="0" style="width:100%;background-color:#ffffff;border-radius:12px">
            <tbody>
                <tr>
                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table cellpadding="0" cellspacing="0" style="width:100%">
                            <tbody>
                                <tr>
                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Invoice Number'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['number']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php _e('Payment Method'); ?>
                                                        </span>
                                                    </td>
                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#7a7a7a;font-size:14px;line-height:20px;font-weight:500">
                                                            <?php echo $args['payment_method']; ?>
                                                        </span>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;padding-left:0px;height:70px">
                                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:14px;line-height:16px;font-weight:500">
                                                                            <?php _e('Amount', 'salesloo') ?>
                                                                        </span>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td align="right" style="border:0;border-collapse:collapse;margin:0;padding:0;text-align:right;">
                                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="right" nowrap="" style="border:0;border-collapse:collapse;margin:0;padding:0;width:100%">
                                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:14px;line-height:16px;font-weight:500;white-space:nowrap">
                                                                            <?php echo $args['amount']; ?>
                                                                        </span>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
<?php
        return ob_get_clean();
    }
}
