<?php

namespace Salesloo\Email\Customer;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Email;

class Order_Expired_Reminder extends Email
{
    public function __construct()
    {
        $day = isset($_GET['day']) ? sanitize_text_field($_GET['day']) : '';
        $this->target       = 'customer';
        $this->event        = 'order_expired_reminder_' . $day;
        $this->target_title = __('Customer', 'salesloo');
        $this->event_title  = sprintf(__('Reminder %s order expired', 'salesloo'), str_replace('_', ' days ', $day));
    }

    public function set_day($day)
    {
        $this->event = 'order_expired_reminder_' . $day . '_before';
        return $this;
    }

    public function shortcodes()
    {
        $shortcodes = [
            'customer_name'      => __('Customer Name', 'salesloo'),
            'order_expired_date' => __('Order expired date', 'salesloo'),
            'product_name'       => __('Product Name', 'salesloo'),
            'renew_button'       => __('Renew button link', 'salesloo')
        ];

        return $shortcodes;
    }

    public function default_subject()
    {
        return 'Access for [product_name] will expire';
    }

    public function default_body()
    {
        return 'Hi [customer_name]

This is a reminder message because You have an expire access for [product_name] on [order_expired_date]

please renew before it expire

[renew_button]';
    }

    public function content($args)
    {
        if (isset($args['renew_button'])) {
            $args['renew_button'] = $this->template_renew_button($args['renew_button']);
        }
        $this->build_subject($args);
        $this->build_body($args);

        return $this;
    }

    public function preview()
    {
        $args = [
            'customer_name'      => 'Jhon Doe',
            'product_name'       => ' Test product name',
            'order_expired_date' => date('Y-M-d H:i', strtotime('+ 7 days')),
            'renew_button'       => []
        ];

        $this->content($args);

        echo $this->_body;
    }

    public function template_renew_button($args = array())
    {
        $default = [
            'product_name' => 'Test product name',
            'renew_url'    => ''
        ];

        $args = wp_parse_args($args, $default);

        ob_start()

?>
        <table cellpadding="0" cellspacing="0" style="width:100%;background-color:#ffffff;border-radius:12px">
            <tbody>
                <tr>
                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table cellpadding="0" cellspacing="0" style="width:100%">
                            <tbody>
                                <tr>
                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0">
                                                        <span style="font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;text-decoration:none;color:#1a1a1a;font-size:18px;line-height:20px;font-weight:500">
                                                            <?php echo $args['product_name']; ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>

                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                                <tr>
                                                    <td height="10" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                                        <div>&nbsp;</div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <table cellpadding="0" cellspacing="0" style="width:100%">
                                            <tbody>
                                                <tr>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                    <td width="100%" valign="top" align="center" style="padding:50px 0 30px">
                                                        <table cellpadding="0" cellspacing="0" border="0" style="border-collapse:initial">
                                                            <tbody>
                                                                <tr>
                                                                    <td width="100%" align="center" valign="middle" bgcolor="#1a73e8"><a href="<?php echo $args['renew_url']; ?>" style="height: 40px;padding:0 30px;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Ubuntu,sans-serif;font-weight:bold;color:#ffffff;font-size:14px;line-height:40px;letter-spacing:normal;display:block;border-radius:10px;text-decoration:none"><?php _e('Renew Now', 'salesloo'); ?></a></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td style="border:0;border-collapse:collapse;margin:0;padding:0;min-width:32px;width:32px">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                                <tr>
                                    <td height="16" style="border:0;margin:0;padding:0;font-size:1px;line-height:1px;max-height:1px">
                                        <div>&nbsp;</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>
<?php
        return ob_get_clean();
    }
}
