<?php

namespace Salesloo\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Frontend;

/**
 * Profile
 */
class Profile extends Frontend
{

    /**
     * construction
     */
    public function __construct()
    {
        $this->id       = 'profile';
        $this->template = 'profile.php';
        $this->target   = 'user';
        $this->title    = __('Profile', 'salesloo');
    }

    public function process_action($request)
    {

        if (isset($_POST['nonce']) && salesloo_verify_nonce($_POST['nonce'])) {
            if (isset($_POST['action']) && $_POST['action'] == 'upload_avatar' && isset($_FILES['file'])) {
                $file = $_FILES['file'];
                $type = $file['type'];
                $extensions = array('image/jpeg', 'image/png', 'image/gif');
                if (in_array($type, $extensions)) {
                    $upload = wp_upload_bits($file['name'], null, file_get_contents($file['tmp_name']));

                    if (!is_wp_error($upload)) {
                        update_user_meta(get_current_user_id(), 'avatar', esc_url_raw($upload['url']));

                        $respons = [
                            'message' => __('Avatar Updated', 'salesloo')
                        ];

                        header("HTTP/1.0 200 OK");

                        echo json_encode($respons);
                        exit;
                    } else {
                        $respons = [
                            'message' => __('Error upload please contact admin', 'salesloo')
                        ];

                        header("HTTP/1.0 400 Bad Request");

                        echo json_encode($respons);
                        exit;
                    }
                }

                $respons = [
                    'message' => __('Unallowed file, please use png or jpg image file', 'salesloo')
                ];

                header("HTTP/1.0 400 Bad Request");

                echo json_encode($respons);
                exit;
            }
        }

        if ($request->action == 'edit_profile') {
            $data = $request->data;
            unset($data['username']);
            unset($data['email']);
            unset($data['nonce']);
            unset($data['action']);
            unset($data['avatar']);
            foreach ($data as $key => $val) {
                update_user_meta(get_current_user_id(), wp_unslash($key), wp_unslash($val));
            }

            $respons = [
                'message' => __('Profile Updated', 'salesloo'),
                'data' => $data
            ];

            header("HTTP/1.0 200 OK");

            echo json_encode($respons);
            exit;
        }

        if ($request->action == 'update_password') {
            $data = $request->data;

            if (isset($data['pass1']) && isset($data['pass2']) && $data['pass1'] == $data['pass2']) {

                $password = sanitize_text_field($data['pass1']);
                wp_set_password($password, get_current_user_id());

                $respons = [
                    'message' => __('Password Updated', 'salesloo')
                ];

                header("HTTP/1.0 200 OK");
            } else {
                $respons = [
                    'message' => __('Password must be equals', 'salesloo')
                ];

                header("HTTP/1.0 400 Bad Request");
            }

            echo json_encode($respons);
            exit;
        }
    }

    public function load()
    {
        global $___salesloo;

        $data = [
            'ajax' => [
                'url'    => '',
                'method' => 'post',
                'data'   => [
                    'avatar'      => get_user_meta(get_current_user_id(), 'avatar', true),
                    'username'    => wp_get_current_user()->user_login,
                    'first_name'  => wp_get_current_user()->first_name,
                    'last_name'   => wp_get_current_user()->last_name,
                    'email'       => wp_get_current_user()->user_email,
                    'phone'       => get_user_meta(get_current_user_id(), 'phone', true),
                    'nonce'       => salesloo_create_nonce(),
                    'action'      => 'edit_profile'
                ]
            ],
            'upload' => [
                'file' => '',
                'nonce'       => salesloo_create_nonce(),
                'action'      => 'upload_avatar'
            ]
        ];

        $___salesloo['data'] = $data;
    }
}
