<?php

namespace Salesloo\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Frontend;
use \Salesloo\Models\Invoice as Model_Invoice;

/**
 * Salesloo Transaction Invoice page
 */
class Transaction_Invoice extends Frontend
{

    /**
     * construction
     */
    public function __construct()
    {
        $this->id       = 'transaction/invoice';
        $this->template = 'transaction-invoice.php';
        $this->target   = 'user';
        $this->title    = __('Invoice', 'salesloo');
    }

    public function load()
    {
        global $___salesloo;

        $search = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';

        $query = 'WHERE user_id = "' . get_current_user_id() . '"';

        if ($search) {
            $query .= ' AND number LIKE "%' . $search . '%"';
        }

        $invoices = Model_Invoice::query($query)->paginate(20, salesloo_get_current_paged())->order('ID', 'DESC')->get();

        $___salesloo['invoices'] = $invoices;
    }
}
