<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
function salesloo_field_submit($args = array())
{
    $default_args = [
        'label' => __('Save Changes', 'salesloo'),
    ];

    $args = wp_parse_args($args, $default_args);
    include SALESLOO_PATH . 'assets/fields/admin/submit.php';
}
function salesloo_field_heading($args)
{
    $default_args = [
        'label'       => '',
        'description' => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);
    include SALESLOO_PATH . 'assets/fields/admin/heading.php';
}
function salesloo_field_hidden($args)
{
    $default_args = [
        'name'  => '',
        'id'    => '',
        'value' => '',
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/hidden.php';
}
function salesloo_field_text($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'placeholder' => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default',
        'readonly' => false
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/text.php';
}
function salesloo_field_textarea($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'placeholder' => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/textarea.php';
}
function salesloo_field_number($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'placeholder' => '',
        'min'         => '',
        'max'         => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/number.php';
}
function salesloo_field_select($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/select.php';
}
function salesloo_field_select2($args)
{
    $default_args = [
        'label'           => '',
        'name'            => '',
        'description'     => '',
        'class'           => '',
        'id'              => '',
        'value'           => '',
        'style'           => '',
        'required'        => '',
        'options'         => [],
        'before'          => '',
        'after'           => '',
        'direction'       => 'default',
        'multiple'        => false,
        'select2_options' => [],
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/select2.php';
}
function salesloo_field_title($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'options'     => array(),
        'before'      => '',
        'after'       => '',
        'direction'   => 'default',
        'readonly' => false
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/title.php';
}
function salesloo_field_content($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'placeholder' => '',
        'options'     => array(
            'textarea_rows' => 15,
        ),
        'before'      => '',
        'after'       => '',
        'direction'   => 'default',
        'readonly' => false
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/content.php';
}
function salesloo_field_editor($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'placeholder' => '',
        'options'     => array(
            'textarea_rows' => 15,
        ),
        'before'    => '',
        'after'     => '',
        'direction' => 'default',
        'readonly' => false
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/editor.php';
}
function salesloo_field_radio($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'options'     => array(),
        'before'      => '',
        'after'       => '',
        'direction'   => 'default',
        'readonly' => false
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/radio.php';
}
function salesloo_field_radiobutton($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'options'     => array(),
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/radiobutton.php';
}
function salesloo_field_toggle($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'options'     => array(),
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/toggle.php';
}
function salesloo_field_checkbox($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/checkbox.php';
}
function salesloo_field_datepicker($args)
{
    $default_args = [
        'label'        => '',
        'name'         => '',
        'description'  => '',
        'class'        => '',
        'id'           => '',
        'value'        => '',
        'style'        => '',
        'required'     => '',
        'placeholder'  => '',
        'before'       => '',
        'after'        => '',
        'direction'    => 'default',
        'date_options' => ''
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/datepicker.php';
}

function salesloo_field_daterangepicker($args)
{
    $default_args = [
        'label'        => '',
        'name'         => '',
        'description'  => '',
        'class'        => '',
        'id'           => '',
        'value'        => '',
        'style'        => '',
        'required'     => '',
        'placeholder'  => '',
        'before'       => '',
        'after'        => '',
        'direction'    => 'default',
        'date_options' => ''
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/daterangepicker.php';
}

function salesloo_field_image($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/image.php';
}

function salesloo_field_file($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/file.php';
}

function salesloo_field_link($args)
{
    $default_args = [
        'label'       => '',
        'placeholder' => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default'
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/link.php';
}

function salesloo_field_notice($args)
{
    $default_args = [
        'type'       => 'info', //notice type is : info, error, warning, success, 
        'message' => ''
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/notice.php';
}


/**
 * salesloo_field_get_conditional_data
 *
 * @param  mixed $args
 * @return array
 */
function salesloo_field_get_conditional_data($args)
{
    $conditional = [];
    if (isset($args['conditional']) && $args['conditional'] && is_array($args['conditional'])) {
        $conditional[] = 'style="display:none"';

        $compare = 'OR';
        if (isset($args['conditional']['compare'])) {
            if (in_array($args['conditional']['compare'], ['OR', 'AND'])) {
                $compare = sanitize_text_field($args['conditional']['compare']);
            }

            unset($args['conditional']['compare']);
        }

        $conditional[] = 'data-conditional-compare=\'' . $compare . '\'';

        $con = [];
        foreach ((array)$args['conditional'] as $c) {

            if (!isset($c['field']) || !isset($c['value'])) continue;

            $con[] = $c;
        }

        $conditional[] = 'data-conditional=\'' . json_encode($con) . '\'';
    }

    return $conditional;
}

function salesloo_field_color_picker($args)
{
    $default_args = [
        'label'       => '',
        'name'        => '',
        'description' => '',
        'class'       => '',
        'id'          => '',
        'value'       => '',
        'style'       => '',
        'required'    => '',
        'placeholder' => '',
        'before'      => '',
        'after'       => '',
        'direction'   => 'default',
        'readonly' => false
    ];

    $args = wp_parse_args($args, $default_args);

    include SALESLOO_PATH . 'assets/fields/admin/color-picker.php';
}
