<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

function salesloo_get_template($file)
{
    if (empty($file)) return false;

    $custom_path = apply_filters('salesloo/template/directory', false);
    $plugin_path = SALESLOO_PATH . 'templates/';
    $theme_path = get_template_directory() . '/salesloo/';

    $template = $plugin_path . $file;

    if (file_exists($theme_path . $file)) {
        $template = $theme_path . $file;
    }

    if (file_exists($custom_path . $file)) {
        $template = $custom_path . $file;
    }

    $template = apply_filters('salesloo/template/file', $template, $file);
    if (!file_exists($template)) return false;

    return $template;
}

function salesloo_header()
{
    $header = 'header.php';
    $template = salesloo_get_template($header);

    if (false === $template) return false;

    load_template($template);
}

function salesloo_topbar()
{
    $header = 'topbar.php';
    $template = salesloo_get_template($header);

    if (false === $template) return false;

    load_template($template);
}

function salesloo_load_layout($target, $template)
{
    global $___salesloo;

    $layout = salesloo_get_template('layout/' . $target . '.php');
    $___salesloo['template'] = $template;

    if (false === $layout) {
        wp_die('Template not found');
    }

    load_template($layout);
}


function salesloo_footer()
{
    $footer = 'footer.php';
    $template = salesloo_get_template($footer);

    if (false === $template) return false;

    load_template($template, true);
}

function salesloo_template_navigation()
{
    $template = salesloo_get_template('navigation.php');

    if (false === $template) return false;

    require $template;
}

function salesloo_template_branding()
{
    $template = salesloo_get_template('branding.php');

    if (false === $template) return false;

    require $template;
}

function salesloo_template_section($file)
{
    $template = salesloo_get_template($file);

    if (false === $template) return false;

    require $template;
}
