<?php

function salesloo_apply_new_order_database_model_v_0_10_0()
{
    global $wpdb;

    if (isset($_GET['upgrade']) && isset($_GET['nonce'])) {
        if ($_GET['upgrade'] == 'order_database_model_v_0_10_0' && wp_verify_nonce($_GET['nonce'], 'salesloo_upgraded')) {
            $limit = 100;

            $query = "SELECT * FROM {$wpdb->prefix}salesloo_order";
            $query .= " LEFT JOIN {$wpdb->prefix}salesloo_ordermeta";
            $query .= " ON {$wpdb->prefix}salesloo_order.ID = {$wpdb->prefix}salesloo_ordermeta.order_id";
            $query .= " WHERE meta_key IS NULL";
            $query .= " LIMIT %d";

            $orders = $wpdb->get_results($wpdb->prepare($query, $limit));

            if ($orders) {
                foreach ($orders as $order) {
                    salesloo_update_order_meta($order->ID, 'affiliate_id', $order->affiliate_id);
                    salesloo_update_order_meta($order->ID, 'renew_price', $order->total);
                    salesloo_update_order_meta($order->ID, 'license_limit', $order->license_limit);
                }
            }

            $args = $_GET;
            unset($args['upgrade']);
            unset($args['nonce']);

            $redirect_url = add_query_arg($args, admin_url('admin.php'));
            wp_redirect($redirect_url);
            exit;
        }
    }
}

function salesloo_upgrade_order_database_model_v_0_10_0_notices()
{
    global $wpdb;

    $query = "SELECT count(ID) as total FROM {$wpdb->prefix}salesloo_order";
    $query .= " LEFT JOIN {$wpdb->prefix}salesloo_ordermeta";
    $query .= " ON {$wpdb->prefix}salesloo_order.ID = {$wpdb->prefix}salesloo_ordermeta.order_id";
    $query .= " WHERE meta_key IS NULL";

    $orders = $wpdb->get_row($query);

    if ($orders->total <= 0) return;

    $args = $_GET;
    $args['upgrade'] = 'order_database_model_v_0_10_0';
    $args['nonce'] = wp_create_nonce('salesloo_upgraded');

    ob_start();
?>
    <div class="notice">
        <h3>Salesloo need to be upgraded to new database</h3>
        <p>"<?php echo $orders->total; ?>" Database order need to be upgraded</p>
        <p><a class="button button-primary" href="<?php echo add_query_arg($args, admin_url('admin.php')); ?>">Upgraded 100 order database now</a></p>
        <br />
    </div>
<?php

    echo ob_get_clean();
}


function salesloo_upgrade_currencies_v_0_10_3()
{
    $currency = get_option('salesloo_currency');
    $currency_symbol = get_option('salesloo_currency_symbol');
    if (empty($currency_symbol)) {
        $currency = get_option('salesloo_currency');
        update_option('salesloo_currency_symbol', $currency);
    }

    if (in_array($currency, ['Rp', '$'])) {
        if ($currency == 'Rp') {
            $new_currency = 'IDR';
        } else {
            $new_currency = 'USD';
        }
        update_option('salesloo_currency', $new_currency);
    }
}

function salesloo_upgrade_currencies_v_0_10_4()
{
    global $wpdb;

    $q = "SELECT * FROM $wpdb->options WHERE option_name LIKE 'salesloo_payment_method_%_currency' AND option_value IN ('Rp', '$')";
    $result = $wpdb->get_results($q);

    if ($result) {
        foreach ($result as $r) {
            $new_value = $r->option_value == 'Rp' ? 'IDR' : 'USD';
            update_option($r->option_name, $new_value);
        }
    }
}

add_action('salesloo/upgrade', 'salesloo_upgrade_v_1_1_19');
function salesloo_upgrade_v_1_1_19()
{
    global $wpdb;

    if (isset($_GET['upgrade']) && isset($_GET['nonce'])) {
        if ($_GET['upgrade'] == 'v_1_1_19' && wp_verify_nonce($_GET['nonce'], 'salesloo_upgraded')) {

            $column = $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s AND COLUMN_NAME = %s ",
                DB_NAME,
                $wpdb->prefix . 'salesloo_invoice',
                'total'
            ));

            if ($column->COLUMN_TYPE != 'decimal(20,4)') {
                $wpdb->query("ALTER TABLE {$wpdb->prefix}salesloo_invoice MODIFY total decimal(20, 4)");
            }
        }
    }
}

add_action('salesloo/upgrade/notice', 'salesloo_upgrade_v_1_1_19_notices');
function salesloo_upgrade_v_1_1_19_notices()
{
    global $wpdb;

    $args      = $_GET;
    $args['upgrade'] = 'v_1_1_19';
    $args['nonce']   = wp_create_nonce('salesloo_upgraded');

    $column = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s AND COLUMN_NAME = %s ",
        DB_NAME,
        $wpdb->prefix . 'salesloo_invoice',
        'total'
    ));

    if ($column->COLUMN_TYPE == 'decimal(20,4)') return;

    ob_start();
?>
    <div class="notice notice-warning">
        <p><strong><?php _e('Salesloo need to be upgraded to new database', 'salesloo'); ?></strong></p>
        <p><a class="button button-primary" href="<?php echo add_query_arg($args, get_admin_url()); ?>"><?php _e('Upgraded now', 'salesloo'); ?></a></p>
    </div>
<?php

    echo ob_get_clean();
}
