<?php

namespace Salesloo\Models;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Database;

/**
 * Order Model
 */
class Order extends Database
{
    protected $table = 'salesloo_order';

    protected $columns = [
        'ID'                   => 'integer',
        'code'                 => 'string',
        'user_id'              => 'integer',
        'invoice_id'           => 'integer',
        'product_id'           => 'integer',
        'status'               => 'string',
        'expired_at'           => 'string',
        'created_at'           => 'string',
        'updated_at'           => 'string'
    ];

    protected $attributes = [];

    protected $log = [];

    protected $invoices = [];

    protected $product = null;

    /**
     * get log
     */
    public function log()
    {
        if (empty($this->log)) {
            $this->log = Order_Log::query('WHERE order_id = %d', $this->ID)->order('log_id', 'DESC')->get();
        }

        return $this->log;
    }

    /**
     * get invoices
     *
     * @return void
     */
    public function invoices()
    {
        if (empty($this->invoices)) {
            $this->invoices = Invoice::join('right', 'salesloo_invoice_order', ['ID', 'invoice_id', '='])
                ->select(
                    ['salesloo_invoice.*'],
                    ['salesloo_invoice_order.order_id']
                )
                ->query('WHERE order_id = %d', $this->ID)
                ->order('ID', 'DESC')
                ->get();
        }

        return $this->invoices;
    }

    public function meta($meta_key = false)
    {
        if (empty($this->meta)) {
            $get_all_meta = Order_Meta::query('WHERE order_id = %d', $this->ID)->get();

            $all_meta = [];

            if ($get_all_meta) {
                foreach ($get_all_meta as $key => $value) {
                    if (isset($all_meta[$value->meta_key])) {

                        if (is_array($all_meta[$value->meta_key])) {
                            $all_meta[$value->meta_key][] = \maybe_unserialize($value->meta_value);
                        } else {
                            $temp = array(
                                $all_meta[$value->meta_key],
                                \maybe_unserialize($value->meta_value)
                            );

                            unset($all_meta[$value->meta_key]);

                            $all_meta[$value->meta_key] = $temp;
                        }
                    } else {
                        $all_meta[$value->meta_key] = \maybe_unserialize($value->meta_value);
                    }
                }
            }

            $this->meta = $all_meta;
        }

        if ($meta_key) {
            return isset($this->meta[$meta_key]) ? $this->meta[$meta_key] : false;
        }

        return $this->meta;
    }

    public function get_product()
    {
        if (is_null($this->product)) {
            $this->product = Product::query('WHERE ID = %d', $this->product_id)->first();
        }
        return $this->product;
    }

    /**
     * get_renew_price
     *
     * @return string
     */
    public function get_renew_price()
    {
        $renew_price = salesloo_get_order_meta($this->ID, 'renew_price', true);

        /**
         * compability with version before 0.10.0 
         */
        if (empty($renew_price)) {
            $renew_price = $this->total;
        }

        return $renew_price;
    }

    /**
     * get_affiliate_id
     *
     * @return string
     */
    public function get_affiliate_id()
    {
        $affiliate_id = salesloo_get_order_meta($this->ID, 'affiliate_id', true);

        /**
         * compability with version before 0.10.0 
         */
        if (empty($affiliate_id)) {
            $affiliate_id = $this->affiliate_id;
        }

        return intval($affiliate_id);
    }

    /**
     * get_license_limit
     *
     * @return string
     */
    public function get_license_limit()
    {
        $license_limit = salesloo_get_order_meta($this->ID, 'license_limit', true);

        /**
         * compability with version before 0.10.0 
         */
        if (empty($license_limit)) {
            $license_limit = $this->license_limit;
        }

        return intval($license_limit);
    }
}
