<?php

namespace Salesloo;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Notification
 */
class Notifications
{
    /**
     * construct
     *
     * @return array
     */
    public static function classes()
    {
        $classes = [
            '\Salesloo\Notification\Email',
        ];

        return apply_filters('salesloo/notification/classes', $classes);
    }

    public function run()
    {
        $notifications = \Salesloo\Models\Notification::query('WHERE executed_at IS NULL AND executed = 0')->paginate(10)->get();

        foreach ($notifications as $notification) {
            foreach (self::classes() as $class) {
                $class = new $class;

                if ($notification->event == 'place_order') {
                    $class->on_place_order($notification->data);
                }

                if ($notification->event == 'invoice_unpaid_reminder') {
                    $class->on_invoice_unpaid_reminder($notification->data);
                }

                if ($notification->event == 'invoice_checking_payment') {
                    $class->on_invoice_checking_payment($notification->data);
                }

                if ($notification->event == 'invoice_completed') {
                    $class->on_invoice_completed($notification->data);
                }

                if ($notification->event == 'invoice_refunded') {
                    $class->on_invoice_refunded($notification->data);
                }

                if ($notification->event == 'invoice_cancelled') {
                    $class->on_invoice_cancelled($notification->data);
                }

                if ($notification->event == 'commission_paid') {
                    $class->on_commission_paid($notification->data);
                }

                if ($notification->event == 'order_expired_reminder') {
                    $class->on_order_expired_reminder($notification->data);
                }

                if ($notification->event == 'order_expired') {
                    $class->on_order_expired($notification->data);
                }

                if ($notification->event == 'register') {
                    $class->on_register($notification->data);
                }
            }

            salesloo_executed_notification($notification->ID);
        }
    }

    /**
     * __construct
     *
     * @return void
     */
    public function __construct()
    {
        add_action('salesloo/cron/minute', [$this, 'run']);
        //add_action('init', [$this, 'run']);
    }
}
