<?php

namespace Salesloo;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use WP_Error;

/**
 * Payment Method classes
 */
class Payment_Method
{
    private $classes;

    /**
     * __construct
     *
     * @return void
     */
    public function __construct()
    {
        $this->load_classes();
    }

    /**
     * load_classes
     *
     * load payment method classes
     * @return void
     */
    private function load_classes()
    {
        $classes = [
            'Salesloo\Payment_Method\Bacs',
            'Salesloo\Payment_Method\Paypal'
        ];

        $classes = apply_filters('salesloo/payment_method/classes', $classes);

        $this->classes = $classes;
    }

    /**
     * get all registered payment methods
     *
     * @return array
     */
    public function all()
    {
        $classes = [];
        foreach ($this->classes as $class) {

            $class = new $class;
            if (empty($class->get_id())) continue;

            $classes[$class->get_id()] = $class;
        }

        return $classes;
    }

    /**
     * active
     * 
     * get list of active only payment methods
     *
     * @return array
     */
    public function active()
    {
        $classes = [];
        foreach ($this->classes as $class) {

            $class = new $class;
            if (empty($class->get_id())) continue;

            if (!$class->enable()) continue;

            $classes[$class->get_id()] = $class;
        }

        return $classes;
    }

    /**
     * get_payment_method
     * 
     * get single payment method
     *
     * @param  string $name
     * @return mixed
     */
    public function get($name = false)
    {
        $classes = $this->active();

        if (empty($classes)) return NULL;

        list($class) = array_values($classes);
        if ($name && isset($classes[$name])) {
            $class = $classes[$name];
        }

        return $class;
    }
}
