<?php

namespace Salesloo\Payment_Method;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use \Salesloo\Abstracts\Payment_Method;

/**
 * Manual payment methods
 */
class Bacs extends Payment_Method
{
    private $account_details = [];

    /**
     * construction
     */
    public function __construct()
    {
        $this->id              = 'bacs';
        $this->name            = 'BACS';
        $this->icon_id         = '';
        $this->title           = __('Direct Bank Transfer', 'salesloo');
        $this->description     = __('Payment with direct to local bank/wire transfer', 'salesloo');
        $this->currency        = 'IDR';
        $this->currency_symbol = 'Rp';
        $this->currency_rate   = '';
        $this->unique_number   = true;
        $this->instruction     = __('Transfer your payment to one of the bank accounts below', 'salesloo');
    }

    /**
     * settings
     */
    public function settings()
    {
        ob_start();

        $accounts = salesloo_get_option('bacs_account');

?>
        <div class="salesloo-field default">
            <div class="salesloo-field-label">
                <label><?php _e('Bank Accounts') ?></label>
            </div>
            <div class="salesloo-field-input">
                <div class="salesloo-field__number">
                    <div class="salesloo_input_table_wrapper" id="bacs_accounts">
                        <table class="widefat sortable" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="sort">&nbsp;</th>
                                    <th><?php esc_html_e('Account name', 'salesloo'); ?></th>
                                    <th><?php esc_html_e('Account number', 'salesloo'); ?></th>
                                    <th><?php esc_html_e('Bank name', 'salesloo'); ?></th>
                                    <th><?php esc_html_e('IBAN (Bank Code)', 'salesloo'); ?></th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody class="accounts">
                                <?php
                                $i = -1;
                                if ($accounts) {
                                    foreach ($accounts as $account) {
                                        $i++;

                                        echo '<tr class="account">
										<td class="sort"><span class="dashicons dashicons-menu-alt2" style="cursor:pointer"></span></td>
										<td><input type="text" value="' . esc_attr(wp_unslash($account['bank_account_name'])) . '" name="bacs_account[' . esc_attr($i) . '][bank_account_name]" /></td>
										<td><input type="text" value="' . esc_attr($account['bank_account_number']) . '" name="bacs_account[' . esc_attr($i) . '][bank_account_number]" /></td>
										<td><input type="text" value="' . esc_attr(wp_unslash($account['bank_name'])) . '" name="bacs_account[' . esc_attr($i) . '][bank_name]" /></td>
										<td><input type="text" value="' . esc_attr($account['iban']) . '" name="bacs_account[' . esc_attr($i) . '][iban]" /></td>
										<td class="sort" onclick="let el = this.parentNode; el.parentNode.removeChild(el);"><span class="dashicons dashicons-no-alt" style="cursor:pointer"></span></td>
									</tr>';
                                    }
                                }
                                ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="7"><button type="button" class="add button"><?php esc_html_e('+ Add account', 'salesloo'); ?></button> </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <script type="text/javascript">
                        jQuery(function() {

                            jQuery('#bacs_accounts').on('click', 'button.add', function() {

                                var size = jQuery('#bacs_accounts').find('tbody .account').length;

                                jQuery('<tr class="account">\
									<td class="sort"><span class="dashicons dashicons-menu-alt2" style="cursor:pointer"></span></td>\
									<td><input type="text" name="bacs_account[' + size + '][bank_account_name]" /></td>\
									<td><input type="text" name="bacs_account[' + size + '][bank_account_number]" /></td>\
									<td><input type="text" name="bacs_account[' + size + '][bank_name]" /></td>\
									<td><input type="text" name="bacs_account[' + size + '][iban]" /></td>\
                                    <td class="sort" onclick="let el = this.parentNode; el.parentNode.removeChild(el);"><span class="dashicons dashicons-no-alt" style="cursor:pointer"></span></td>\
								</tr>').appendTo('#bacs_accounts table tbody');

                                return false;
                            });
                        });
                    </script>

                </div>
            </div>
        </div>
<?php
        return ob_get_clean();
    }

    /**
     * 
     */
    public function print_action()
    {

        ob_start();
        salesloo_template_section('payment/bacs-action.php');

        return ob_get_clean();
    }

    public function handle_action($invoice)
    {
        global $___salesloo;

        if ('POST' != $_SERVER['REQUEST_METHOD']) return;

        if (!isset($_REQUEST['__nonce'])) return;

        if (wp_verify_nonce($_POST['__nonce'], 'salesloo-invoice')) {

            if (\Salesloo\Invoice::instance()->status == 'checking_payment') return;

            $updated = salesloo_update_invoice_status(\Salesloo\Invoice::instance()->ID, 'checking_payment');

            if ($updated) {
                $___salesloo['warning'] = __('Thank you for Your payment. we will check your payment and immediately confirm the status of your purchase', 'salesloo');

                return true;
            } else {
                $___salesloo['warning'] = __('error processing confirm payment', 'salesloo');
            }
        }

        return false;
    }
}
