<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * Setting checkout payment
 */
class Checkout_Payment extends Setting_Page
{
    /**
     * Setting General constructor
     */
    public function __construct()
    {
        $this->tab = 'checkout';
        $this->name = 'payment';
        $this->label = __('Payment', 'salesloo');
    }

    public function fields()
    {

        \salesloo_field_editor([
            'label'       => __('Payment information', 'salesloo'),
            'name'        => 'payment_information',
            'description' => '',
            'value'       => \salesloo_get_option('payment_information')
        ]);

        \salesloo_field_submit();
    }
}
