<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * 
 * Checkout Unique Number
 */
class Checkout_Unique_Number extends Setting_Page
{
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tab = 'checkout';
        $this->name = 'unique-number';
        $this->label = __('Unique Number', 'salesloo');
    }

    public function fields()
    {

        \salesloo_field_toggle([
            'label'           => __('Enable', 'salesloo'),
            'name'            => 'unique_number',
            'description'     => __('If this is enabled, the system will automatically add a random unique number to your total purchases to make your total payment unique on the checkout page if the payment method is applicable', 'salesloo'),
            'value'   => \salesloo_get_option('unique_number'),
        ]);

        \salesloo_field_text([
            'label' => __('Unique number label', 'salesloo'),
            'name' => 'unique_number_label',
            'description' => '',
            'value' => \salesloo_get_option('unique_number_label')
        ]);

        \salesloo_field_select([
            'label' => __('Unique number operation', 'salesloo'),
            'name' => 'unique_number_operation',
            'description' => '',
            'options' => [
                '+' => __('Added', 'salesloo'),
                '-' => __('Reduce', 'salesloo'),
            ],
            'value' => \salesloo_get_option('unique_number_operation')
        ]);

        \salesloo_field_number([
            'label' => __('Maximum Unique number', 'salesloo'),
            'name' => 'unique_number_max',
            'description' => '',
            'class' => 'small-text',
            'value' => \salesloo_get_option('unique_number_max')
        ]);

        \salesloo_field_submit();
    }
}
