<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * 
 * Affiliate General
 */
class Design_Color_Scheme extends Setting_Page
{
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tab = 'design';
        $this->name = 'color-scheme';
        $this->label = __('Color Scheme', 'salesloo');
    }

    public function fields()
    {
        \salesloo_field_color_picker([
            'label' => __('Primary Background', 'salesloo'),
            'name' => 'design_primary_bg',
            'value' => \salesloo_get_option('design_primary_bg', '#f4f7fc'),
        ]);

        \salesloo_field_color_picker([
            'label' => __('Secondary Background', 'salesloo'),
            'name' => 'design_secondary_bg',
            'value' => \salesloo_get_option('design_secondary_bg', '#ffffff'),
        ]);

        \salesloo_field_color_picker([
            'label' => __('Primary Button Background', 'salesloo'),
            'name' => 'design_primary_button_bg',
            'value' => \salesloo_get_option('design_primary_button_bg', '#2564eb'),
        ]);

        \salesloo_field_color_picker([
            'label' => __('Secondary Button Background', 'salesloo'),
            'name' => 'design_secondary_button_bg',
            'value' => \salesloo_get_option('design_secondary_button_bg', '#4b5563'),
        ]);

        \salesloo_field_color_picker([
            'label' => __('Primary Text Color', 'salesloo'),
            'name' => 'design_primary_text_color',
            'value' => \salesloo_get_option('design_primary_text_color', '#6b7280'),
        ]);

        \salesloo_field_color_picker([
            'label' => __('Secondary Text Color', 'salesloo'),
            'name' => 'design_secondary_text_color',
            'value' => \salesloo_get_option('design_secondary_text_color', '#9ca3af'),
        ]);

        \salesloo_field_color_picker([
            'label' => __('Tertiary Text Color', 'salesloo'),
            'name' => 'design_tertiary_text_color',
            'value' => \salesloo_get_option('design_tertiary_text_color', '#ef4444'),
        ]);

        \salesloo_field_color_picker([
            'label' => __('Quaternary Text Color', 'salesloo'),
            'name' => 'design_quaternary_text_color',
            'value' => \salesloo_get_option('design_quaternary_text_color', '#2564eb'),
        ]);

        \salesloo_field_submit();
    }
}
